package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupMemberPersistence
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class ReleaseGroupPersistenceInterceptor @Autowired()(releaseRepository: ReleaseRepository,
                                                      releaseGroupMemberPersistence: ReleaseGroupMemberPersistence)
  extends PersistenceInterceptor[Release] {

  releaseRepository.registerPersistenceInterceptor(this)

  override def onDelete(ciId: String): Unit = releaseGroupMemberPersistence.deleteMembersByReleaseId(ciId)
}
