package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.actors.ReleaseGroupActorInitializer.ReleaseGroupActorHolder
import com.xebialabs.xlrelease.actors.ReleaseGroupMessages._
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.group.ReleaseGroup
import grizzled.slf4j.Logging
import org.apache.pekko.util.Timeout
import org.springframework.stereotype.Component

import scala.concurrent.{Await, TimeoutException}
import scala.jdk.CollectionConverters._

@Component
class ReleaseGroupActorService(releaseGroupActorHolder: ReleaseGroupActorHolder, xlrConfig: XlrConfig) extends Logging {

  def createGroup(group: ReleaseGroup): ReleaseGroup = askAndAwait {
    CreateGroup(group)
  }

  def updateGroup(group: ReleaseGroup): ReleaseGroup = askAndAwait {
    UpdateGroup(group)
  }

  def deleteGroup(groupId: String): Unit = askAndAwait {
    DeleteGroup(groupId)
  }

  def addMembersToGroup(groupId: String, memberIds: java.util.List[String]): Unit = askAndAwait {
    AddMembersToGroup(groupId, memberIds.asScala.toSeq)
  }

  def removeMembersFromGroup(groupId: String, memberIds: java.util.List[String]): Unit = askAndAwait {
    RemoveMembersFromGroup(groupId, memberIds.asScala.toSeq)
  }

  def updateGroupStatus(groupId: String): Unit = tell {
    UpdateGroupStatus(groupId)
  }

  def updateGroupRisk(groupId: String): Unit = tell {
    UpdateGroupRisk(groupId)
  }

  private def askAndAwait[T](msg: AnyRef): T = {
    implicit val askTimeout: Timeout = xlrConfig.timeouts.releaseActionResponse
    try {
      Await.result(
        releaseGroupActorHolder ? msg,
        askTimeout.duration
      ).asInstanceOf[T]
    } catch {
      case e: TimeoutException => throw new RuntimeException(e)
      case e: InterruptedException => throw new RuntimeException(e)
    }
  }

  private def tell(msg: AnyRef): Unit = releaseGroupActorHolder ! msg

}
