/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.ReleaseGroupCreatedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupDeletedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupUpdatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseGroupTimelineCalculator;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\rUa\u0001B\u0014)\u0001EB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0001S\u0011!1\u0006A!A!\u0002\u0013\u0019\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011m\u0003!\u0011!Q\u0001\nqC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"Aq\u000e\u0001BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003r\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+BqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003z\u0001!IAa\u001f\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BT\u0001\u0011%!\u0011\u0016\u0005\b\u0005k\u0003A\u0011\u0002B\\\u0011%\u0011\t\rAI\u0001\n\u0013\u0011\u0019\rC\u0004\u0003X\u0002!IA!7\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!1\u001d\u0001\u0005\n\t\u0015\bb\u0002B|\u0001\u0011%!\u0011 \u0002\u0014%\u0016dW-Y:f\u000fJ|W\u000f]*feZL7-\u001a\u0006\u0003S)\nqa]3sm&\u001cWM\u0003\u0002,Y\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003[9\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u001a9\u0001B\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003u\n\u0001b\u001a:jujdW\rZ\u0005\u0003\u007fi\u0012q\u0001T8hO&tw\r\u0005\u0002B\u00056\t\u0001&\u0003\u0002DQ\tq\"+\u001a7fCN,wI]8vaRKW.\u001a7j]\u0016\u001c\u0015\r\\2vY\u0006$xN]\u0001\u0017e\u0016dW-Y:f\u000fJ|W\u000f\u001d*fa>\u001c\u0018\u000e^8ssB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JK\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001&H\u0005Y\u0011V\r\\3bg\u0016<%o\\;q%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\tQ\n\u0005\u0002G\u001d&\u0011qj\u0012\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001T!\t\tE+\u0003\u0002VQ\tq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003\u0003fK!A\u0017\u0015\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\"!\u00181\u000e\u0003yS!a\u0018\u0016\u0002\u0005\u0011\u0014\u0017BA1_\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/A\u0007g_2$WM]*feZL7-\u001a\t\u0003\u0003\u0012L!!\u001a\u0015\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00051d\u0013\u0001\u00033fa2|\u00170\u001b;\n\u00059L'a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AOK\u0001\u0007KZ,g\u000e^:\n\u0005Y\u001c(!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019i\\H0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0011\u0005\u0005\u0003\u0001\"\u0002#\r\u0001\u0004)\u0005\"B&\r\u0001\u0004i\u0005\"B)\r\u0001\u0004\u0019\u0006\"B,\r\u0001\u0004A\u0006\"B.\r\u0001\u0004a\u0006\"\u00022\r\u0001\u0004\u0019\u0007\"\u00024\r\u0001\u00049\u0007\"B8\r\u0001\u0004\t\bf\u0001\u0007\u0002\nA!\u00111BA\u0011\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AC1o]>$\u0018\r^5p]*!\u00111CA\u000b\u0003\u001d1\u0017m\u0019;pefTA!a\u0006\u0002\u001a\u0005)!-Z1og*!\u00111DA\u000f\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\tiAA\u0005BkR|w/\u001b:fI\u0006Aq-\u001a;He>,\b\u000f\u0006\u0003\u0002*\u0005e\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0006OJ|W\u000f\u001d\u0006\u0004\u0003gQ\u0013A\u00023p[\u0006Lg.\u0003\u0003\u00028\u00055\"\u0001\u0004*fY\u0016\f7/Z$s_V\u0004\bbBA\u001e\u001b\u0001\u0007\u0011QH\u0001\bOJ|W\u000f]%e!\u0011\ty$!\u0014\u000f\t\u0005\u0005\u0013\u0011\n\t\u0004\u0003\u0007\"TBAA#\u0015\r\t9\u0005M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-C'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017\"\u0004fA\u0007\u0002VA!\u0011qKA2\u001b\t\tIF\u0003\u0003\u0002\u0010\u0005m#\u0002BA/\u0003?\nq!\\3ue&\u001c7OC\u0002\u0002b9\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003K\nIFA\u0003US6,G-A\u0006fq&\u001cHo]$s_V\u0004H\u0003BA6\u0003c\u00022aMA7\u0013\r\ty\u0007\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tYD\u0004a\u0001\u0003{A3ADA+\u0003-\u0019'/Z1uK\u001e\u0013x.\u001e9\u0015\t\u0005%\u0012\u0011\u0010\u0005\b\u0003wz\u0001\u0019AA\u0015\u00031\u0011X\r\\3bg\u0016<%o\\;qQ\ry\u0011QK\u0001\fkB$\u0017\r^3He>,\b\u000f\u0006\u0003\u0002*\u0005\r\u0005bBA>!\u0001\u0007\u0011\u0011\u0006\u0015\u0004!\u0005U\u0013a\u00033fY\u0016$Xm\u0012:pkB$B!a#\u0002\u0012B\u00191'!$\n\u0007\u0005=EG\u0001\u0003V]&$\bbBA\u001e#\u0001\u0007\u0011Q\b\u0015\u0004#\u0005U\u0013!E1eI6+WNY3sgR{wI]8vaR1\u00111RAM\u00037Cq!a\u000f\u0013\u0001\u0004\ti\u0004C\u0004\u0002\u001eJ\u0001\r!a(\u0002\u00135,WNY3s\u0013\u0012\u001c\bCBAQ\u0003W\u000biD\u0004\u0003\u0002$\u0006\u001df\u0002BA\"\u0003KK\u0011!N\u0005\u0004\u0003S#\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003[\u000byKA\u0002TKFT1!!+5Q\r\u0011\u0012QK\u0001\u0017e\u0016lwN^3NK6\u0014WM]:Ge>lwI]8vaR1\u00111RA\\\u0003sCq!a\u000f\u0014\u0001\u0004\ti\u0004C\u0004\u0002\u001eN\u0001\r!a()\u0007M\t)&\u0001\u0004tK\u0006\u00148\r\u001b\u000b\t\u0003\u0003\f\t.!;\u0002tB1\u00111YAg\u0003Si!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u0005kRLGN\u0003\u0002\u0002L\u0006!!.\u0019<b\u0013\u0011\ty-!2\u0003\t1K7\u000f\u001e\u0005\b\u0003'$\u0002\u0019AAk\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!a6\u0002f6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.A\u0003g_Jl7O\u0003\u0003\u0002`\u0006\u0005\u0018A\u0001<2\u0015\r\t\u0019OK\u0001\u0004CBL\u0017\u0002BAt\u00033\u00141CU3mK\u0006\u001cXm\u0012:pkB4\u0015\u000e\u001c;feNDq!a;\u0015\u0001\u0004\ti/\u0001\u0003qC\u001e,\u0007c\u0001$\u0002p&\u0019\u0011\u0011_$\u0003\tA\u000bw-\u001a\u0005\b\u0003k$\u0002\u0019AA|\u0003\u001dy'\u000fZ3s\u0005f\u0004B!a6\u0002z&!\u00111`Am\u0005U\u0011V\r\\3bg\u0016<%o\\;q\u001fJ$WM]'pI\u0016D3\u0001FA+\u0003-9W\r\u001e+j[\u0016d\u0017N\\3\u0015\r\t\r!q\u0002B\t!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003;\fQA^5foNLAA!\u0004\u0003\b\t!\"+\u001a7fCN,wI]8vaRKW.\u001a7j]\u0016Dq!a\u000f\u0016\u0001\u0004\ti\u0004C\u0004\u0003\u0014U\u0001\rA!\u0006\u0002\u00079|w\u000f\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\tQLW.\u001a\u0006\u0005\u0005?\ti\"\u0001\u0003k_\u0012\f\u0017\u0002\u0002B\u0012\u00053\u0011\u0001\u0002R1uKRKW.\u001a\u0015\u0004+\u0005U\u0013!E;qI\u0006$Xm\u0012:pkB\u001cF/\u0019;vgR!\u00111\u0012B\u0016\u0011\u001d\tYD\u0006a\u0001\u0003{A3AFA+\u0003=)\b\u000fZ1uK\u001e\u0013x.\u001e9SSN\\G\u0003BAF\u0005gAq!a\u000f\u0018\u0001\u0004\ti\u0004K\u0002\u0018\u0003+\nAC]3dC2\u001cW\u000f\\1uKJK7o[*d_J,G\u0003BAF\u0005wAq!a\u001f\u0019\u0001\u0004\tI#\u0001\u000bhKR\u0014V\r\\3bg\u0016\u0014\u0016n]6TG>\u0014Xm\u001d\u000b\u0005\u0005\u0003\u0012I\u0005\u0005\u0004\u0002\"\u0006-&1\t\t\u0004g\t\u0015\u0013b\u0001B$i\t\u0019\u0011J\u001c;\t\u000f\t-\u0013\u00041\u0001\u0002 \u0006Q!/\u001a7fCN,\u0017\nZ:\u0002\u0017\u001d,GOR8mI\u0016\u0014\u0018\n\u001a\u000b\u0005\u0003{\u0011\t\u0006C\u0004\u0002<i\u0001\r!!\u0010\u00029\u0019Lg\u000eZ$s_V\u00048OU3gKJ,gnY5oOJ+G.Z1tKR!\u0011q\u0014B,\u0011\u001d\u0011If\u0007a\u0001\u0003{\t\u0011B]3mK\u0006\u001cX-\u00133)\u0007m\t)&A\u0011gS:$\u0017i\u0019;jm\u0016<%o\\;qgJ+g-\u001a:f]\u000eLgn\u001a$pY\u0012,'\u000f\u0006\u0003\u0003b\tM\u0004CBAQ\u0003W\u0013\u0019\u0007\u0005\u0003\u0003f\t=TB\u0001B4\u0015\u0011\u0011IGa\u001b\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0004\u0005[:\u0015aA:rY&!!\u0011\u000fB4\u00055\u0019\u0015.\u00133XSRDG+\u001b;mK\"9!Q\u000f\u000fA\u0002\u0005u\u0012\u0001\u00034pY\u0012,'/\u00133)\u0007q\t)&\u0001\u000fsK\u000e\fGnY;mCR,7\u000b^1ukN\fe\u000e\u001a)s_\u001e\u0014Xm]:\u0015\t\u0005-%Q\u0010\u0005\b\u0003wj\u0002\u0019AA\u0015\u0003I9W\r\u001e*fY\u0016\f7/Z*uCR,8/Z:\u0015\t\t\r%\u0011\u0013\t\u0007\u0003C\u000bYK!\"\u0011\t\t\u001d%QR\u0007\u0003\u0005\u0013SAAa#\u00022\u000511\u000f^1ukNLAAa$\u0003\n\ni!+\u001a7fCN,7\u000b^1ukNDqAa\u0013\u001f\u0001\u0004\ty*\u0001\fdC2\u001cW\u000f\\1uK\u001e\u0013x.\u001e9Qe><'/Z:t)\u0011\u00119Ja)\u0011\t\te%qT\u0007\u0003\u00057SAA!(\u0002J\u0006!A.\u00198h\u0013\u0011\u0011\tKa'\u0003\u000f%sG/Z4fe\"9!QU\u0010A\u0002\t\r\u0015\u0001C:uCR,8/Z:\u0002)\r\fGnY;mCR,wI]8vaN#\u0018\r^;t)\u0019\u0011YK!-\u00034B!\u00111\u0006BW\u0013\u0011\u0011y+!\f\u0003%I+G.Z1tK\u001e\u0013x.\u001e9Ti\u0006$Xo\u001d\u0005\b\u0003w\u0002\u0003\u0019AA\u0015\u0011\u001d\u0011)\u000b\ta\u0001\u0005\u0007\u000b\u0001c\u00195fG.L5/\u00169eCR\f'\r\\3\u0015\r\u0005-%\u0011\u0018B_\u0011\u001d\u0011Y,\ta\u0001\u0003S\tQ\"\u001a=jgRLgnZ$s_V\u0004\b\"\u0003B`CA\u0005\t\u0019AA\u001f\u0003\u0019\t7\r^5p]\u0006Q2\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0019\u0016\u0005\u0003{\u00119m\u000b\u0002\u0003JB!!1\u001aBj\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017!C;oG\",7m[3e\u0015\r\ty\u0001N\u0005\u0005\u0005+\u0014iMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003\u0017\u0013Y\u000eC\u0004\u0002|\r\u0002\r!!\u000b\u0002\u001dY\fG.\u001b3bi\u0016lU-\u001c2feR!\u00111\u0012Bq\u0011\u001d\u0011I\u0006\na\u0001\u0003{\t\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t+\t\u00119\u000f\u0005\u0004\u0003j\n=(1_\u0007\u0003\u0005WT1A!<5\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005c\u0014YO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\u0011IJ!>\n\t\u0005=#1T\u0001\u000fGV\u0014(/\u001a8u%>dW-\u00133t+\t\u0011Y\u0010\u0005\u0004\u0003~\u000e\r!1_\u0007\u0003\u0005\u007fTAa!\u0001\u0003l\u00069Q.\u001e;bE2,\u0017\u0002BB\u0003\u0005\u007f\u0014aAQ;gM\u0016\u0014\bf\u0001\u0001\u0004\nA!11BB\t\u001b\t\u0019iA\u0003\u0003\u0004\u0010\u0005e\u0011AC:uKJ,w\u000e^=qK&!11CB\u0007\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ReleaseGroupService
implements ReleaseGroupTimelineCalculator {
    private final ReleaseGroupRepository releaseGroupRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public ReleaseGroupTimeline calculateTimeline(ReleaseGroup releaseGroup, DateTime now) {
        return ReleaseGroupTimelineCalculator.calculateTimeline$(this, releaseGroup, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return ReleaseGroupTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseGroupService releaseGroupService = this;
        synchronized (releaseGroupService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        return this.releaseGroupRepository.read(groupId);
    }

    @Timed
    public boolean existsGroup(String groupId) {
        return this.releaseGroupRepository.exists(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable)() -> "Creating new release group [" + releaseGroup + "]");
        this.validate(releaseGroup);
        releaseGroup.setId(this.ciIdService.getUniqueId(Type.valueOf(ReleaseGroup.class), ReleaseGroup.GROUP_ROOT));
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.create(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupCreatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public ReleaseGroup updateGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable)() -> "Updating release group [" + releaseGroup + "]");
        this.validate(releaseGroup);
        this.checkIsUpdatable(this.releaseGroupRepository.read(releaseGroup.getId()), this.checkIsUpdatable$default$2());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting release group [" + groupId + "]");
        if (this.releaseGroupRepository.exists(groupId)) {
            ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
            this.checkIsUpdatable(releaseGroup, "delete");
            this.releaseGroupRepository.delete(groupId);
            this.eventBus().publish((XLReleaseEvent)new ReleaseGroupDeletedEvent(releaseGroup));
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + groupId + "] already deleted");
    }

    @Timed
    public void addMembersToGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable)() -> "Adding members " + memberIds + " to release group [" + groupId + "]");
        memberIds.foreach((Function1 & Serializable)releaseId -> {
            this.validateMember(releaseId);
            return BoxedUnit.UNIT;
        });
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.getReleaseIds().addAll(CollectionConverters$.MODULE$.SeqHasAsJava(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public void removeMembersFromGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable)() -> "Removing members " + memberIds + " from release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.removeReleaseIds(CollectionConverters$.MODULE$.SeqHasAsJava(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public List<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.releaseGroupRepository.search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds())).asJava();
    }

    @Timed
    public ReleaseGroupTimeline getTimeline(String groupId, DateTime now) {
        ReleaseGroup releaseGroup = this.getGroup(groupId);
        return this.calculateTimeline(releaseGroup, now);
    }

    @Timed
    public void updateGroupStatus(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Recalculating status for release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateStatusAndProgress(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void updateGroupRisk(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Recalculating risk for release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    private void recalculateRiskScore(ReleaseGroup releaseGroup) {
        Seq releaseIds = CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSeq();
        Seq<Object> riskScores = this.getReleaseRiskScores((Seq<String>)releaseIds);
        releaseGroup.setRiskScore(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)riskScores.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / riskScores.length()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] risk score is now: " + releaseGroup.getRiskScore());
    }

    public Seq<Object> getReleaseRiskScores(Seq<String> releaseIds) {
        if (releaseIds.nonEmpty()) {
            return (Seq)this.releaseRepository().getRiskScores(releaseIds).padTo(releaseIds.size(), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String getFolderId(String groupId) {
        return this.releaseGroupRepository.findFolderId(groupId);
    }

    @Timed
    public Seq<String> findGroupsReferencingRelease(String releaseId) {
        return this.releaseGroupRepository.findGroupsReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolder(String folderId) {
        return this.releaseGroupRepository.findActiveGroupsReferencingFolderId(folderId);
    }

    private void recalculateStatusAndProgress(ReleaseGroup releaseGroup) {
        Seq releaseIds = CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSeq();
        Seq<ReleaseStatus> statuses = this.getReleaseStatuses((Seq<String>)releaseIds);
        releaseGroup.setStatus(this.calculateGroupStatus(releaseGroup, statuses));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] status is now: " + releaseGroup.getStatus());
        releaseGroup.setProgress(this.calculateGroupProgress(statuses));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] progress is now: " + releaseGroup.getProgress());
    }

    private Seq<ReleaseStatus> getReleaseStatuses(Seq<String> releaseIds) {
        if (releaseIds.nonEmpty()) {
            return (Seq)this.releaseRepository().getStatuses(releaseIds).padTo(releaseIds.size(), (Object)ReleaseStatus.COMPLETED);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Integer calculateGroupProgress(Seq<ReleaseStatus> statuses) {
        if (statuses.isEmpty()) {
            return Predef$.MODULE$.int2Integer(0);
        }
        return Predef$.MODULE$.int2Integer((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)statuses.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInactive())) / (double)statuses.size() * (double)100)));
    }

    private ReleaseGroupStatus calculateGroupStatus(ReleaseGroup releaseGroup, Seq<ReleaseStatus> statuses) {
        if (statuses.isEmpty()) {
            return ReleaseGroupStatus.PLANNED;
        }
        if (statuses.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$1(statuses, x$2)))) {
            return ReleaseGroupStatus.fromRelease((ReleaseStatus)((ReleaseStatus)statuses.head()));
        }
        if (statuses.contains((Object)ReleaseStatus.FAILING) || statuses.contains((Object)ReleaseStatus.FAILED)) {
            return ReleaseGroupStatus.FAILING;
        }
        if (statuses.contains((Object)ReleaseStatus.IN_PROGRESS) || statuses.contains((Object)ReleaseStatus.PLANNED) || statuses.contains((Object)ReleaseStatus.PAUSED)) {
            return ReleaseGroupStatus.IN_PROGRESS;
        }
        if (!statuses.exists((Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$2(status)))) {
            return ReleaseGroupStatus.COMPLETED;
        }
        return releaseGroup.getStatus();
    }

    private void checkIsUpdatable(ReleaseGroup existingGroup, String action) {
        Checks.checkArgument((boolean)existingGroup.isUpdatable(), (String)("Cannot " + action + " release group '" + existingGroup.getTitle() + "' because it is " + existingGroup.getStatus()), (Object[])new Object[0]);
    }

    private String checkIsUpdatable$default$2() {
        return "update";
    }

    private void validate(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)releaseGroup, (String)"Release group");
        Checks.checkArgument((releaseGroup.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((boolean)releaseGroup.getEndDate().after(releaseGroup.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)releaseGroup.getFolderId()) ? 1 : 0) != 0, (String)("Provided folder ID '" + releaseGroup.getFolderId() + "' must not be a root folder"), (Object[])new Object[0]);
        if (releaseGroup.getReleaseIds() == null) {
            releaseGroup.setReleaseIds(new HashSet());
        }
        releaseGroup.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        Checks.checkArgument((boolean)this.folderService.exists(releaseGroup.getFolderId()), (String)("Provided folder ID '" + releaseGroup.getFolderId() + "' must exist in the database"), (Object[])new Object[0]);
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must be a valid release ID"), (Object[])new Object[0]);
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases.exists(releaseId) ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must exist in the database"), (Object[])new Object[0]);
    }

    private Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$3 -> x$3.getId());
    }

    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$1(Seq statuses$1, ReleaseStatus x$2) {
        ReleaseStatus releaseStatus = x$2;
        Object object = statuses$1.head();
        return !(releaseStatus != null ? !releaseStatus.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$2(ReleaseStatus status) {
        ReleaseStatus releaseStatus = status;
        ReleaseStatus releaseStatus2 = ReleaseStatus.COMPLETED;
        if (releaseStatus == null) {
            if (releaseStatus2 == null) return false;
        } else if (releaseStatus.equals(releaseStatus2)) return false;
        ReleaseStatus releaseStatus3 = status;
        ReleaseStatus releaseStatus4 = ReleaseStatus.ABORTED;
        if (releaseStatus3 == null) {
            if (releaseStatus4 == null) return false;
            return true;
        } else if (releaseStatus3.equals(releaseStatus4)) return false;
        return true;
    }

    @Autowired
    public ReleaseGroupService(ReleaseGroupRepository releaseGroupRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.releaseGroupRepository = releaseGroupRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        ReleaseGroupTimelineCalculator.$init$(this);
    }
}

