package com.xebialabs.xlrelease.api.internal;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseGroupService;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

/**
 * Fixtures for release groups
 */
@Path("/fixtures/release-groups")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesReleaseGroupResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesReleaseGroupResource.class);

    private ReleaseGroupService releaseGroupService;
    private PermissionChecker permissions;
    private ReleaseGroupRepository releaseGroupRepository;

    @Autowired
    public FixturesReleaseGroupResource(ReleaseGroupService releaseGroupService, PermissionChecker permissions, ReleaseGroupRepository releaseGroupRepository) {
        this.releaseGroupService = releaseGroupService;
        this.permissions = permissions;
        this.releaseGroupRepository = releaseGroupRepository;
    }

    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    public ReleaseGroup createReleaseGroup(ReleaseGroup releaseGroup) {
        this.permissions.check(ADMIN);

        logger.debug("creating release group", releaseGroup.getId());
        return this.releaseGroupService.createGroup(releaseGroup);
    }

    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @DELETE
    @Path("/{groupId:.*ReleaseGroup[^/]*}")
    public void deleteReleaseGroup(@PathParam("groupId") String groupId) {
        this.permissions.check(ADMIN);

        logger.debug("removing release group %s", groupId);
        if (releaseGroupRepository.exists(groupId)) {
            this.releaseGroupRepository.delete(groupId);
        }
    }


}
