/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.actors.ReleaseGroupActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/release-groups")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class ReleaseGroupApi
implements ApiService {
    private final ReleaseGroupActorService releaseGroupActorService;
    private final ReleaseGroupService releaseGroupService;
    private final PermissionChecker permissions;

    @Autowired
    public ReleaseGroupApi(ReleaseGroupActorService releaseGroupActorService, ReleaseGroupService releaseGroupService, PermissionChecker permissions) {
        this.releaseGroupActorService = releaseGroupActorService;
        this.releaseGroupService = releaseGroupService;
        this.permissions = permissions;
    }

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    @Timed
    public ReleaseGroup getGroup(@PathParam(value="groupId") String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return this.releaseGroupService.getGroup(groupId);
    }

    @DELETE
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    @Timed
    public void deleteGroup(@PathParam(value="groupId") String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.deleteGroup(groupId);
    }

    @POST
    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)releaseGroup.getFolderId(), (String)"folderId");
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_GROUP, releaseGroup.getFolderId());
        return this.releaseGroupActorService.createGroup(releaseGroup);
    }

    @PUT
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    @Timed
    public ReleaseGroup updateGroup(@PathParam(value="groupId") String groupId, ReleaseGroup releaseGroup) {
        releaseGroup.setId(groupId);
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        return this.releaseGroupActorService.updateGroup(releaseGroup);
    }

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    @Timed
    public List<String> getMembers(@PathParam(value="groupId") String groupId) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return new ArrayList<String>(this.releaseGroupService.getGroup(groupId).getReleaseIds());
    }

    @POST
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    @Timed
    public void addMembersToGroup(@PathParam(value="groupId") String groupId, List<String> memberIds) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        Checks.checkNotNull(memberIds, (String)"memberIds");
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.addMembersToGroup(groupId, memberIds);
    }

    @DELETE
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    @Timed
    public void removeMembersFromGroup(@PathParam(value="groupId") String groupId, List<String> memberIds) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        Checks.checkNotNull(memberIds, (String)"memberIds");
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.removeMembersFromGroup(groupId, memberIds);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<ReleaseGroup> searchGroups(ReleaseGroupFilters groupFilters, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage, @DefaultValue(value="RISK") @QueryParam(value="orderBy") ReleaseGroupOrderMode orderBy) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == groupFilters) {
            groupFilters = new ReleaseGroupFilters();
        }
        return this.releaseGroupService.search(groupFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()), orderBy);
    }

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/timeline")
    @Timed
    public ReleaseGroupTimeline getReleaseGroupTimeline(@PathParam(value="groupId") String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return this.releaseGroupService.getTimeline(groupId, DateTime.now());
    }

    public String serviceName() {
        return "releaseGroupApi";
    }

    private void checkPermissions(String groupId, Permission permission) {
        String folderId = this.releaseGroupService.getFolderId(groupId);
        this.permissions.check(permission, folderId);
    }
}

