/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001\u0002\u001b6\u0001\u0001C\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003W\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\u0004!Q1A\u0005\u0002\u0015D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011)\u0019!C\u0001W\"A!\u000f\u0001B\u0001B\u0003%A\u000e\u0003\u0005t\u0001\t\u0015\r\u0011\"\u0001u\u0011!A\bA!A!\u0002\u0013)\b\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0001>\t\u0013\u0005\u001d\u0001A!A!\u0002\u0013Y\bBCA\u0005\u0001\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqA!\u0012\u0001\t\u0003\u00119\u0005C\u0005\u0003h\u0001\t\n\u0011\"\u0001\u0003j!9!Q\t\u0001\u0005\u0002\tu\u0004b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!(\u0001\t\u0003\u0011\u0019\fC\u0004\u0003>\u0002!\tAa0\t\u000f\tu\u0006\u0001\"\u0001\u0003H\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005o\u0004A\u0011\u0002B}\u0011\u001d\u0011i\u0010\u0001C\u0005\u0005\u007fDqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\n\u0001!Iaa\u0003\t\u000f\re\u0001\u0001\"\u0003\u0004\u001c!91q\u0004\u0001\u0005\n\r\u0005\u0002\"CB\u0015\u0001E\u0005I\u0011BB\u0016\u0011\u001d\u0019y\u0003\u0001C\u0005\u0007cAqaa\u0010\u0001\t\u0013\u0019\t\u0005C\u0004\u0004|\u0001!Ia! \t\u0013\r\u0015\u0005!%A\u0005\n\r\u001d\u0005bBBF\u0001\u0011E3Q\u0012\u0002\u0017\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]N+'O^5dK*\u0011agN\u0001\bg\u0016\u0014h/[2f\u0015\tA\u0014(\u0001\u0005eK2Lg/\u001a:z\u0015\tQ4(A\u0005yYJ,G.Z1tK*\u0011A(P\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AP\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\r\u0005\u0002I\u00136\tQ'\u0003\u0002Kk\t!B)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW-\u0016;jYN\f!\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ssV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002Qo\u0005Q!/\u001a9pg&$xN]=\n\u0005I{%A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u00051\u0006CA,Z\u001b\u0005A&B\u0001):\u0013\tQ\u0006LA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#\u00010\u0011\u0005}\u000bW\"\u00011\u000b\u0005YJ\u0014B\u00012a\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\fG&LEmU3sm&\u001cW-F\u0001g!\tyv-\u0003\u0002iA\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/F\u0001m!\ti\u0007/D\u0001o\u0015\ty\u0017(\u0001\u0002eE&\u0011\u0011O\u001c\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\f\u0011#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:!\u000351w\u000e\u001c3feN+'O^5dKV\tQ\u000f\u0005\u0002`m&\u0011q\u000f\u0019\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001d\u0019|G\u000eZ3s'\u0016\u0014h/[2fA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006A1/Z2ve&$\u0018PC\u0002\u0002\u0002m\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0004\u0003\u000bi(a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fAB]8mKN+'O^5dK\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'I\u0014AB3wK:$8/\u0003\u0003\u0002\u0018\u0005E!!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012q\u0006\t\u0003\u0011\u0002AQaS\tA\u00025CQ\u0001V\tA\u0002YCQ\u0001X\tA\u0002yCQ\u0001Z\tA\u0002\u0019DQA[\tA\u00021DQa]\tA\u0002UDQ!_\tA\u0002mDq!!\u0003\u0012\u0001\u0004\ti\u0001K\u0002\u0012\u0003g\u0001B!!\u000e\u0002L5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0006b]:|G/\u0019;j_:TA!!\u0010\u0002@\u00059a-Y2u_JL(\u0002BA!\u0003\u0007\nQAY3b]NTA!!\u0012\u0002H\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002J\u0005\u0019qN]4\n\t\u00055\u0013q\u0007\u0002\n\u0003V$xn^5sK\u0012\f!bZ3u!\u0006$H/\u001a:o)\u0011\t\u0019&!\u0019\u0011\t\u0005U\u0013QL\u0007\u0003\u0003/R1\u0001OA-\u0015\r\tY&O\u0001\u0007I>l\u0017-\u001b8\n\t\u0005}\u0013q\u000b\u0002\t\t\u0016d\u0017N^3ss\"9\u00111\r\nA\u0002\u0005\u0015\u0014!\u00039biR,'O\\%e!\u0011\t9'!\u001e\u000f\t\u0005%\u0014\u0011\u000f\t\u0004\u0003W\u001aUBAA7\u0015\r\tygP\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M4)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u001a\u0005f\u0001\n\u0002~A!\u0011qPAF\u001b\t\t\tI\u0003\u0003\u0002:\u0005\r%\u0002BAC\u0003\u000f\u000bq!\\3ue&\u001c7OC\u0002\u0002\nv\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u001b\u000b\tIA\u0003US6,G-A\u000bhKR\u0004\u0016\r\u001e;fe:\u0014\u00150\u00133PeRKG\u000f\\3\u0015\t\u0005M\u00131\u0013\u0005\b\u0003+\u001b\u0002\u0019AA3\u0003A\u0001\u0018\r\u001e;fe:LEm\u0014:USRdW\rK\u0002\u0014\u0003{\na#\u001a=jgR\u001c\b+\u0019;uKJtw+\u001b;i)&$H.\u001a\u000b\u0007\u0003;\u000b\u0019+a*\u0011\u0007\t\u000by*C\u0002\u0002\"\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002&R\u0001\r!!\u001a\u0002\u0005%$\u0007bBAU)\u0001\u0007\u0011QM\u0001\u0006i&$H.\u001a\u0015\u0004)\u0005u\u0014!D3ySN$8\u000fU1ui\u0016\u0014h\u000e\u0006\u0003\u0002\u001e\u0006E\u0006bBAZ+\u0001\u0007\u0011QM\u0001\u000bI\u0016d\u0017N^3ss&#\u0007fA\u000b\u0002~\u0005)2M]3bi\u0016$U\r\\5wKJL\b+\u0019;uKJtG\u0003BA*\u0003wCq!!0\u0017\u0001\u0004\t\u0019&A\u0004qCR$XM\u001d8)\u0007Y\ti(A\u000bva\u0012\fG/\u001a#fY&4XM]=QCR$XM\u001d8\u0015\t\u0005M\u0013Q\u0019\u0005\b\u0003\u000f<\u0002\u0019AA*\u0003\u001d)\b\u000fZ1uK\u0012D3aFA?\u0003U!W\r\\3uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$B!a4\u0002VB\u0019!)!5\n\u0007\u0005M7I\u0001\u0003V]&$\bbBA21\u0001\u0007\u0011Q\r\u0015\u00041\u0005u\u0014\u0001\u00073va2L7-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R1\u00111KAo\u0003?Dq!a\u0019\u001a\u0001\u0004\t)\u0007C\u0004\u0002bf\u0001\r!a9\u0002\rA\f'/Y7t!\u0011\t)/a=\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fQAZ8s[NTA!!<\u0002p\u0006\u0011a/\r\u0006\u0004\u0003cL\u0014aA1qS&!\u0011Q_At\u0005a!U\u000f\u001d7jG\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u0015\u00043\u0005u\u0014!G2sK\u0006$X\rR3mSZ,'/\u001f$s_6\u0004\u0016\r\u001e;fe:$b!a\u0015\u0002~\u0006}\bbBA25\u0001\u0007\u0011Q\r\u0005\b\u0005\u0003Q\u0002\u0019\u0001B\u0002\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0003K\u0014)!\u0003\u0003\u0003\b\u0005\u001d(AD\"sK\u0006$X\rR3mSZ,'/\u001f\u0015\u00045\u0005u\u0014AD:fCJ\u001c\u0007\u000eU1ui\u0016\u0014hn\u001d\u000b\u0007\u0005\u001f\u0011yB!\u000b\u0011\r\tE!1DA*\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\t]\u0011\u0001B;uS2T!A!\u0007\u0002\t)\fg/Y\u0005\u0005\u0005;\u0011\u0019B\u0001\u0003MSN$\bb\u0002B\u00117\u0001\u0007!1E\u0001\bM&dG/\u001a:t!\u0011\t)O!\n\n\t\t\u001d\u0012q\u001d\u0002\u0017\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]\u001aKG\u000e^3sg\"9!1F\u000eA\u0002\t5\u0012\u0001\u00029bO\u0016\u00042a\u0016B\u0018\u0013\r\u0011\t\u0004\u0017\u0002\u0005!\u0006<W\rK\u0002\u001c\u0003{\n\u0011bZ3u'R\fw-Z:\u0015\t\te\"\u0011\t\t\u0007\u0005#\u0011YBa\u000f\u0011\t\u0005U#QH\u0005\u0005\u0005\u007f\t9FA\u0003Ti\u0006<W\rC\u0004\u0002dq\u0001\r!!\u001a)\u0007q\ti(\u0001\u0005bI\u0012\u001cF/Y4f)!\u0011YD!\u0013\u0003L\t=\u0003bBA2;\u0001\u0007\u0011Q\r\u0005\b\u0005\u001bj\u0002\u0019\u0001B\u001e\u0003\u0015\u0019H/Y4f\u0011%\u0011\t&\bI\u0001\u0002\u0004\u0011\u0019&\u0001\u0005q_NLG/[8o!\u0019\u0011\tB!\u0016\u0003Z%!!q\u000bB\n\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003\u0002B.\u0005Cj!A!\u0018\u000b\t\t}#qC\u0001\u0005Y\u0006tw-\u0003\u0003\u0003d\tu#aB%oi\u0016<WM\u001d\u0015\u0004;\u0005u\u0014AE1eIN#\u0018mZ3%I\u00164\u0017-\u001e7uIM*\"Aa\u001b+\t\tM#QN\u0016\u0003\u0005_\u0002BA!\u001d\u0003z5\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011H\"\n\t\tm$1\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003\u0003B\u001e\u0005\u007f\u0012\tIa!\t\u000f\u0005uv\u00041\u0001\u0002T!9!QJ\u0010A\u0002\tm\u0002b\u0002B)?\u0001\u0007!1\u000b\u0015\u0004?\u0005u\u0014aC;qI\u0006$Xm\u0015;bO\u0016$bAa\u000f\u0003\f\n5\u0005bBA2A\u0001\u0007\u0011Q\r\u0005\b\u0003\u000f\u0004\u0003\u0019\u0001B\u001eQ\r\u0001\u0013QP\u0001\fI\u0016dW\r^3Ti\u0006<W\r\u0006\u0004\u0002P\nU%q\u0013\u0005\b\u0003G\n\u0003\u0019AA3\u0011\u001d\u0011I*\ta\u0001\u0003K\nqa\u001d;bO\u0016LE\rK\u0002\"\u0003{\nQ\"\u00193e)J\fgn]5uS>tG\u0003\u0003BQ\u0005O\u0013IK!,\u0011\t\u0005U#1U\u0005\u0005\u0005K\u000b9F\u0001\u0006Ue\u0006t7/\u001b;j_:Dq!a\u0019#\u0001\u0004\t)\u0007C\u0004\u0003,\n\u0002\r!!\u001a\u0002\u001dM$\u0018mZ3JI>\u0013H+\u001b;mK\"9!q\u0016\u0012A\u0002\t\u0005\u0016A\u0003;sC:\u001c\u0018\u000e^5p]\"\u001a!%! \u0015\u0011\t\u0005&Q\u0017B\\\u0005sCq!!0$\u0001\u0004\t\u0019\u0006C\u0004\u0003,\u000e\u0002\r!!\u001a\t\u000f\t=6\u00051\u0001\u0003\"\"\u001a1%! \u0002!U\u0004H-\u0019;f)J\fgn]5uS>tGC\u0002BQ\u0005\u0003\u0014\u0019\rC\u0004\u0002d\u0011\u0002\r!!\u001a\t\u000f\u0005\u001dG\u00051\u0001\u0003\"\"\u001aA%! \u0015\r\t\u0005&\u0011\u001aBf\u0011\u001d\ti,\na\u0001\u0003'Bq!a2&\u0001\u0004\u0011\t\u000bK\u0002&\u0003{\n\u0001\u0003Z3mKR,GK]1og&$\u0018n\u001c8\u0015\r\u0005='1\u001bBk\u0011\u001d\t\u0019G\na\u0001\u0003KBqAa6'\u0001\u0004\t)'\u0001\u0007ue\u0006t7/\u001b;j_:LE\rK\u0002'\u0003{\n\u0001dZ3oKJ\fG/\u001a+ji2,\u0017J\u001a(fG\u0016\u001c8/\u0019:z)\u0019\tyMa8\u0003b\"9!QJ\u0014A\u0002\tm\u0002b\u0002BrO\u0001\u0007!Q]\u0001\u0007gR\fw-Z:\u0011\r\t\u001d(\u0011\u001fB\u001e\u001d\u0011\u0011IO!<\u000f\t\u0005-$1^\u0005\u0002\t&\u0019!q^\"\u0002\u000fA\f7m[1hK&!!1\u001fB{\u0005\r\u0019V-\u001d\u0006\u0004\u0005_\u001c\u0015AD2iK\u000e\\\u0017j\u001d)biR,'O\u001c\u000b\u0005\u0003\u001f\u0014Y\u0010\u0003\u00049Q\u0001\u0007\u00111K\u0001\u0010m\u0006d\u0017\u000eZ1uKB\u000bG\u000f^3s]R!\u0011qZB\u0001\u0011\u0019A\u0014\u00061\u0001\u0002T\u0005!c/\u00197jI\u0006$Xm\u0015;bO\u0016\u001c\u0018I\u001c3Ue\u0006t7/\u001b;j_:\u001c\u0018I\u001c3Ji\u0016l7\u000f\u0006\u0003\u0002P\u000e\u001d\u0001bBA_U\u0001\u0007\u00111K\u0001\u0011m\u0006d\u0017\u000eZ1uK:+wo\u0015;bO\u0016$\u0002\"a4\u0004\u000e\r=1\u0011\u0003\u0005\b\u0005G\\\u0003\u0019\u0001Bs\u0011\u001d\u0011ie\u000ba\u0001\u0005wAqA!\u0015,\u0001\u0004\u0019\u0019\u0002E\u0002C\u0007+I1aa\u0006D\u0005\rIe\u000e^\u0001\u0018m\u0006d\u0017\u000eZ1uKN#\u0018mZ3Qe>\u0004XM\u001d;jKN$B!a4\u0004\u001e!9!Q\n\u0017A\u0002\tm\u0012\u0001\u0004:fg\u0016$\b+\u0019;uKJtGCBAh\u0007G\u0019)\u0003C\u0004\u0002>6\u0002\r!a\u0015\t\u0013\r\u001dR\u0006%AA\u0002\u0005u\u0015a\u00034pe\u000e,g*Z<JIN\faC]3tKR\u0004\u0016\r\u001e;fe:$C-\u001a4bk2$HEM\u000b\u0003\u0007[QC!!(\u0003n\u0005q!/Z:fi\u000e{g\u000eZ5uS>tGCBAh\u0007g\u0019)\u0004C\u0004\u00030>\u0002\rA!)\t\u000f\r]r\u00061\u0001\u0004:\u0005I1m\u001c8eSRLwN\u001c\t\u0005\u0003+\u001aY$\u0003\u0003\u0004>\u0005]#!C\"p]\u0012LG/[8o\u0003I9WM\\3sCR,wJ]+qI\u0006$X-\u00133\u0016\t\r\r31\f\u000b\u000b\u0007\u000b\u001aig!\u001d\u0004v\reD\u0003BA3\u0007\u000fB\u0011b!\u00131\u0003\u0003\u0005\u001daa\u0013\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0004N\rM3qK\u0007\u0003\u0007\u001fR1a!\u0015D\u0003\u001d\u0011XM\u001a7fGRLAa!\u0016\u0004P\tA1\t\\1tgR\u000bw\r\u0005\u0003\u0004Z\rmC\u0002\u0001\u0003\b\u0007;\u0002$\u0019AB0\u0005\u0005!\u0016\u0003BB1\u0007O\u00022AQB2\u0013\r\u0019)g\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u00115\u0011N\u0005\u0004\u0007W\u001a%aA!os\"91q\u000e\u0019A\u0002\u0005\u0015\u0014AC3ySN$\u0018N\\4JI\"911\u000f\u0019A\u0002\u0005\u0015\u0014aC8mIB\u000b'/\u001a8u\u0013\u0012Dqaa\u001e1\u0001\u0004\t)'A\u0006oK^\u0004\u0016M]3oi&#\u0007bBB\u0014a\u0001\u0007\u0011QT\u0001\u0015C2\u0014X-\u00193z\u000bbL7\u000f^:CsRKG\u000f\\3\u0015\r\u0005u5qPBB\u0011\u001d\u0019\t)\ra\u0001\u0003K\nA\u0002]1ui\u0016\u0014h\u000eV5uY\u0016D\u0011\"a\u00192!\u0003\u0005\r!!\u001a\u0002=\u0005d'/Z1es\u0016C\u0018n\u001d;t\u0005f$\u0016\u000e\u001e7fI\u0011,g-Y;mi\u0012\u0012TCABEU\u0011\t)G!\u001c\u0002!\rDWmY6JgV\u0003H-\u0019;bE2,GCBAh\u0007\u001f\u001b\u0019\nC\u0004\u0004\u0012N\u0002\r!a\u0015\u0002!\u0015D\u0018n\u001d;j]\u001e$U\r\\5wKJL\b\"CBKgA\u0005\t\u0019AA3\u0003\u0019\t7\r^5p]\"\u001a\u0001a!'\u0011\t\rm5\u0011U\u0007\u0003\u0007;SAaa(\u0002D\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\r\r6Q\u0014\u0002\b'\u0016\u0014h/[2f\u0001")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = new StringOps(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$")).r();
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c)).head()).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = new StringOps(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1))).toInt();
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(((Object)BoxesRunTime.boxToInteger((int)(++orderNumber))).toString()).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public java.util.List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public java.util.List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        this.validateNewStage((Seq<Stage>)stages.$minus$minus((GenTraversableOnce)new .colon.colon((Object)original, (List)Nil$.MODULE$)), updated, stages.indexOf((Object)original));
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        Checks.checkArgument((stage.getTransition() == null ? 1 : 0) != 0, (String)new StringBuilder(63).append("There is already a transition named '").append(transition.getTitle()).append("' associated with stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)((Object)x$2)));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)((Object)x$3)));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)((Object)stage));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateStages = (Buffer)((SeqLike)stageTitles.diff((GenSeq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateItems = (Buffer)((SeqLike)trackedItemTitles.diff((GenSeq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    private void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

