from com.xebialabs.deployit.exception import NotFoundException
from com.xebialabs.xlrelease.api.v1.forms import DeliveryFilters, Comment, CreateDelivery, DeliveryOrderMode
from com.xebialabs.xlrelease.domain.delivery import DeliveryStatus
from delivery import make_delivery_hyperlink

global deliveryPatternApi, deliveryApi, taskApi, task, title, patternId, searchStrategy, nameFilter, selectionStrategy, fallback, startDate, endDate


def set_task_status_line(delivery_title, delivery_id):
    task.setStatusLine(make_delivery_hyperlink(delivery_title, delivery_id))


def handle_not_found(_pattern):
    if fallback:
        params = CreateDelivery()
        params.title = title
        # by default the start date and end date should be calculated from pattern duration
        params.startDate = startDate
        params.endDate = endDate
        params.folderId = _pattern.folderId

        created = deliveryPatternApi.createDeliveryFromPattern(_pattern.id, params)

        print "Created delivery : %s" % make_delivery_hyperlink(created.title, created.id)
        set_task_status_line(created.title, created.id)

        return created.id
    else:
        print "No active delivery matching the search criteria was found\n"
        sys.exit(1)


def find_latest_by_title(_pattern, title_pattern):
    escaped_title_pattern = title_pattern.replace("%", "`%").replace("_", "`_").replace("*", "%").replace("?", "_")
    delivery_filters = (
        DeliveryFilters()
            .withStatuses(DeliveryStatus.IN_PROGRESS)
            .withOriginPatternId(_pattern.id)
            .withTitle(escaped_title_pattern)
            .withStrictTitleMatch(True)
    )

    found_deliveries = deliveryApi.searchDeliveries(delivery_filters, 0, 1, DeliveryOrderMode.CREATED_DATE)
    if found_deliveries:
        delivery = found_deliveries[0]
        print "Found delivery : %s" % make_delivery_hyperlink(delivery.title, delivery.id)
        set_task_status_line(delivery.title, delivery.id)
        return delivery.id
    else:
        return handle_not_found(_pattern)


try:
    pattern = deliveryPatternApi.getPatternByIdOrTitle(patternId)
except NotFoundException as error:
    print "Pattern id or title is not provided or incorrect"
    sys.exit(1)

comment = Comment()

if searchStrategy == "Search by criteria":
    if selectionStrategy == "Use latest result":
        deliveryId = find_latest_by_title(pattern, nameFilter)
    else:
        print "Unsupported search strategy"
        sys.exit(1)
else:
    # get latest from pattern
    deliveryId = find_latest_by_title(pattern, "*")
