/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0001\rEe\u0001B\u001b7\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001d\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003X\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\u0004!Q1A\u0005\u0002\u0019D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!I\bA!A!\u0002\u00131\b\u0002\u0003>\u0001\u0005\u000b\u0007I\u0011A>\t\u0013\u0005%\u0001A!A!\u0002\u0013a\bBCA\u0006\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !I\u0011\u0011\u000b\u0001C\u0002\u0013\u0015\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0004\u0002V!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!2\u0001\t\u0003\t9\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bb\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqAa\u0015\u0001\t\u0003\u0011)\u0006C\u0004\u0003T\u0001!\tAa\u0018\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j!9!\u0011\u000f\u0001\u0005\u0002\tM\u0004b\u0002B?\u0001\u0011\u0005!q\u0010\u0005\b\u0005{\u0002A\u0011\u0001BJ\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!(\u0001\t\u0003\u00119\u000bC\u0004\u00030\u0002!\tA!-\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!q\u001b\u0001\u0005\n\te\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0003|\u0002!IA!@\t\u0013\r\u0015\u0001!%A\u0005\n\r\u001d\u0001bBB\u000e\u0001\u0011%1Q\u0004\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u00199\u0007\u0001C\u0005\u0007SB\u0011b!\u001d\u0001#\u0003%Iaa\u001d\t\u000f\r]\u0004\u0001\"\u0015\u0004z\t1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hnU3sm&\u001cWM\u0003\u00028q\u000591/\u001a:wS\u000e,'BA\u001d;\u0003!!W\r\\5wKJL(BA\u001e=\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002>}\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\tI%*D\u00017\u0013\tYeG\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn]\u0001\u0013I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180F\u0001O!\ty%+D\u0001Q\u0015\t\t\u0006(\u0001\u0006sKB|7/\u001b;pefL!a\u0015)\u0003%\u0011+G.\u001b<fef\u0014V\r]8tSR|'/_\u0001\u0014I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#A,\u0011\u0005aSV\"A-\u000b\u0005ES\u0014BA.Z\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b%\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003}\u0003\"\u0001\u00192\u000e\u0003\u0005T!a\u000e\u001e\n\u0005\r\f'A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0010e\u0016dW-Y:f'\u0016\u0014h/[2fA\u0005Y1-[%e'\u0016\u0014h/[2f+\u00059\u0007C\u00011i\u0013\tI\u0017MA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019;\u0003\t!'-\u0003\u0002s_\n\u0001\u0012I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\u0012CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\u0013!\u00044pY\u0012,'oU3sm&\u001cW-F\u0001w!\t\u0001w/\u0003\u0002yC\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\faBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,W#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\tg\u0016\u001cWO]5us*\u0019\u00111\u0001\u001f\u0002\u0011\u0011,\u0007\u000f\\8zSRL1!a\u0002\u007f\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0011\u00154XM\u001c;CkN,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006;\u0003\u0019)g/\u001a8ug&!\u0011\u0011DA\n\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDCEA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\u0001\"!\u0013\u0001\t\u000b1\u000b\u0002\u0019\u0001(\t\u000bU\u000b\u0002\u0019A,\t\u000bu\u000b\u0002\u0019A0\t\u000b\u0015\f\u0002\u0019A4\t\u000b-\f\u0002\u0019A7\t\u000bQ\f\u0002\u0019\u0001<\t\u000bi\f\u0002\u0019\u0001?\t\u000f\u0005-\u0011\u00031\u0001\u0002\u0010!\u001a\u0011#!\u000e\u0011\t\u0005]\u0012QJ\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005}\u0012\u0011I\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019%!\u0012\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111J\u0001\u0004_J<\u0017\u0002BA(\u0003s\u0011\u0011\"Q;u_^L'/\u001a3\u0002'\u0011+e)Q+M)~\u001bF+Q$F?RKE\u000bT#\u0016\u0005\u0005UsBAA,C\t\tI&A\u0005OK^\u00043\u000b^1hK\u0006!B)\u0012$B+2#vl\u0015+B\u000f\u0016{F+\u0013+M\u000b\u0002\n!bZ3u!\u0006$H/\u001a:o)\u0011\t\t'a\u001c\u0011\t\u0005\r\u00141N\u0007\u0003\u0003KR1!OA4\u0015\r\tIGO\u0001\u0007I>l\u0017-\u001b8\n\t\u00055\u0014Q\r\u0002\t\t\u0016d\u0017N^3ss\"9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014!\u00039biR,'O\\%e!\u0011\t)(a!\u000f\t\u0005]\u0014q\u0010\t\u0004\u0003s\"UBAA>\u0015\r\ti\bQ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005E)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u000b9I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003#\u0005f\u0001\u000b\u0002\fB!\u0011QRAM\u001b\t\tyI\u0003\u0003\u0002<\u0005E%\u0002BAJ\u0003+\u000bq!\\3ue&\u001c7OC\u0002\u0002\u0018z\n\u0001bY8eC\"\fG.Z\u0005\u0005\u00037\u000byIA\u0003US6,G-A\u000bhKR\u0004\u0016\r\u001e;fe:\u0014\u00150\u00133PeRKG\u000f\\3\u0015\t\u0005\u0005\u0014\u0011\u0015\u0005\b\u0003G+\u0002\u0019AA:\u0003A\u0001\u0018\r\u001e;fe:LEm\u0014:USRdW\rK\u0002\u0016\u0003\u0017\u000ba#\u001a=jgR\u001c\b+\u0019;uKJtw+\u001b;i)&$H.\u001a\u000b\u0007\u0003W\u000b\t,!.\u0011\u0007\r\u000bi+C\u0002\u00020\u0012\u0013qAQ8pY\u0016\fg\u000eC\u0004\u00024Z\u0001\r!a\u001d\u0002\u0005%$\u0007bBA\\-\u0001\u0007\u00111O\u0001\u0006i&$H.\u001a\u0015\u0004-\u0005-\u0015!D3ySN$8\u000fU1ui\u0016\u0014h\u000e\u0006\u0003\u0002,\u0006}\u0006bBAa/\u0001\u0007\u00111O\u0001\u000bI\u0016d\u0017N^3ss&#\u0007fA\f\u0002\f\u0006)2M]3bi\u0016$U\r\\5wKJL\b+\u0019;uKJtG\u0003BA1\u0003\u0013Dq!a3\u0019\u0001\u0004\t\t'A\u0004qCR$XM\u001d8)\u0007a\tY)A\u000bva\u0012\fG/\u001a#fY&4XM]=QCR$XM\u001d8\u0015\t\u0005\u0005\u00141\u001b\u0005\b\u0003+L\u0002\u0019AA1\u0003\u001d)\b\u000fZ1uK\u0012D3!GAF\u0003U!W\r\\3uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$B!!8\u0002dB\u00191)a8\n\u0007\u0005\u0005HI\u0001\u0003V]&$\bbBA95\u0001\u0007\u00111\u000f\u0015\u00045\u0005-\u0015\u0001\u00073va2L7-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R1\u0011\u0011MAv\u0003[Dq!!\u001d\u001c\u0001\u0004\t\u0019\bC\u0004\u0002pn\u0001\r!!=\u0002\rA\f'/Y7t!\u0011\t\u0019P!\u0001\u000e\u0005\u0005U(\u0002BA|\u0003s\fQAZ8s[NTA!a?\u0002~\u0006\u0011a/\r\u0006\u0004\u0003\u007fT\u0014aA1qS&!!1AA{\u0005a!U\u000f\u001d7jG\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u0015\u00047\u0005-\u0015!G2sK\u0006$X\rR3mSZ,'/\u001f$s_6\u0004\u0016\r\u001e;fe:$b!!\u0019\u0003\f\t5\u0001bBA99\u0001\u0007\u00111\u000f\u0005\b\u0005\u001fa\u0002\u0019\u0001B\t\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0003g\u0014\u0019\"\u0003\u0003\u0003\u0016\u0005U(AD\"sK\u0006$X\rR3mSZ,'/\u001f\u0015\u00049\u0005-\u0015AD:fCJ\u001c\u0007\u000eU1ui\u0016\u0014hn\u001d\u000b\u0007\u0005;\u0011iCa\u000e\u0011\r\t}!\u0011FA1\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012\u0001B;uS2T!Aa\n\u0002\t)\fg/Y\u0005\u0005\u0005W\u0011\tC\u0001\u0003MSN$\bb\u0002B\u0018;\u0001\u0007!\u0011G\u0001\bM&dG/\u001a:t!\u0011\t\u0019Pa\r\n\t\tU\u0012Q\u001f\u0002\u0017\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]\u001aKG\u000e^3sg\"9!\u0011H\u000fA\u0002\tm\u0012\u0001\u00029bO\u0016\u00042\u0001\u0017B\u001f\u0013\r\u0011y$\u0017\u0002\u0005!\u0006<W\rK\u0002\u001e\u0003\u0017\u000b\u0011bZ3u'R\fw-Z:\u0015\t\t\u001d#q\n\t\u0007\u0005?\u0011IC!\u0013\u0011\t\u0005\r$1J\u0005\u0005\u0005\u001b\n)GA\u0003Ti\u0006<W\rC\u0004\u0002ry\u0001\r!a\u001d)\u0007y\tY)\u0001\u0005bI\u0012\u001cF/Y4f)\u0019\u0011IEa\u0016\u0003Z!9\u0011\u0011O\u0010A\u0002\u0005M\u0004b\u0002B.?\u0001\u0007!\u0011J\u0001\u0006gR\fw-\u001a\u0015\u0004?\u0005-EC\u0002B%\u0005C\u0012\u0019\u0007C\u0004\u0002L\u0002\u0002\r!!\u0019\t\u000f\tm\u0003\u00051\u0001\u0003J!\u001a\u0001%a#\u0002\u0017U\u0004H-\u0019;f'R\fw-\u001a\u000b\u0007\u0005\u0013\u0012YG!\u001c\t\u000f\u0005E\u0014\u00051\u0001\u0002t!9\u0011Q[\u0011A\u0002\t%\u0003fA\u0011\u0002\f\u0006YA-\u001a7fi\u0016\u001cF/Y4f)\u0019\tiN!\u001e\u0003x!9\u0011\u0011\u000f\u0012A\u0002\u0005M\u0004b\u0002B=E\u0001\u0007\u00111O\u0001\bgR\fw-Z%eQ\r\u0011\u00131R\u0001\u000eC\u0012$GK]1og&$\u0018n\u001c8\u0015\u0011\t\u0005%q\u0011BE\u0005\u001b\u0003B!a\u0019\u0003\u0004&!!QQA3\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003c\u001a\u0003\u0019AA:\u0011\u001d\u0011Yi\ta\u0001\u0003g\nab\u001d;bO\u0016LEm\u0014:USRdW\rC\u0004\u0003\u0010\u000e\u0002\rA!!\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000eK\u0002$\u0003\u0017#\u0002B!!\u0003\u0016\n]%\u0011\u0014\u0005\b\u0003\u0017$\u0003\u0019AA1\u0011\u001d\u0011Y\t\na\u0001\u0003gBqAa$%\u0001\u0004\u0011\t\tK\u0002%\u0003\u0017\u000b\u0001#\u001e9eCR,GK]1og&$\u0018n\u001c8\u0015\r\t\u0005%\u0011\u0015BR\u0011\u001d\t\t(\na\u0001\u0003gBq!!6&\u0001\u0004\u0011\t\tK\u0002&\u0003\u0017#bA!!\u0003*\n-\u0006bBAfM\u0001\u0007\u0011\u0011\r\u0005\b\u0003+4\u0003\u0019\u0001BAQ\r1\u00131R\u0001\u0011I\u0016dW\r^3Ue\u0006t7/\u001b;j_:$b!!8\u00034\nU\u0006bBA9O\u0001\u0007\u00111\u000f\u0005\b\u0005o;\u0003\u0019AA:\u00031!(/\u00198tSRLwN\\%eQ\r9\u00131R\u0001\u0019O\u0016tWM]1uKRKG\u000f\\3JM:+7-Z:tCJLHCBAo\u0005\u007f\u0013\t\rC\u0004\u0003\\!\u0002\rA!\u0013\t\u000f\t\r\u0007\u00061\u0001\u0003F\u000611\u000f^1hKN\u0004bAa2\u0003R\n%c\u0002\u0002Be\u0005\u001btA!!\u001f\u0003L&\tQ)C\u0002\u0003P\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003T\nU'aA*fc*\u0019!q\u001a#\u0002\u001d\rDWmY6JgB\u000bG\u000f^3s]R!\u0011Q\u001cBn\u0011\u0019I\u0014\u00061\u0001\u0002b\u0005ya/\u00197jI\u0006$X\rU1ui\u0016\u0014h\u000e\u0006\u0003\u0002^\n\u0005\bBB\u001d+\u0001\u0004\t\t'\u0001\u0013wC2LG-\u0019;f'R\fw-Z:B]\u0012$&/\u00198tSRLwN\\:B]\u0012LE/Z7t)\u0011\tiNa:\t\u000f\u0005-7\u00061\u0001\u0002b\u0005\u0001b/\u00197jI\u0006$XMT3x'R\fw-\u001a\u000b\t\u0003;\u0014iOa<\u0003r\"9\u00111\u001a\u0017A\u0002\u0005\u0005\u0004b\u0002B.Y\u0001\u0007!\u0011\n\u0005\b\u0005\u0007d\u0003\u0019\u0001Bc\u0003]1\u0018\r\\5eCR,7\u000b^1hKB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002^\n](\u0011 \u0005\b\u0003\u0017l\u0003\u0019AA1\u0011\u001d\u0011Y&\fa\u0001\u0005\u0013\nAB]3tKR\u0004\u0016\r\u001e;fe:$b!!8\u0003\u0000\u000e\u0005\u0001bBAf]\u0001\u0007\u0011\u0011\r\u0005\n\u0007\u0007q\u0003\u0013!a\u0001\u0003W\u000b1BZ8sG\u0016tUm^%eg\u00061\"/Z:fiB\u000bG\u000f^3s]\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\n)\"\u00111VB\u0006W\t\u0019i\u0001\u0005\u0003\u0004\u0010\r]QBAB\t\u0015\u0011\u0019\u0019b!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001e\t&!1\u0011DB\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fe\u0016\u001cX\r^\"p]\u0012LG/[8o)\u0019\tina\b\u0004\"!9!q\u0012\u0019A\u0002\t\u0005\u0005bBB\u0012a\u0001\u00071QE\u0001\nG>tG-\u001b;j_:\u0004B!a\u0019\u0004(%!1\u0011FA3\u0005%\u0019uN\u001c3ji&|g.\u0001\nhK:,'/\u0019;f\u001fJ,\u0006\u000fZ1uK&#W\u0003BB\u0018\u0007\u000f\"\"b!\r\u0004Z\ru3\u0011MB3)\u0011\t\u0019ha\r\t\u0013\rU\u0012'!AA\u0004\r]\u0012AC3wS\u0012,gnY3%cA11\u0011HB \u0007\u0007j!aa\u000f\u000b\u0007\ruB)A\u0004sK\u001adWm\u0019;\n\t\r\u000531\b\u0002\t\u00072\f7o\u001d+bOB!1QIB$\u0019\u0001!qa!\u00132\u0005\u0004\u0019YEA\u0001U#\u0011\u0019iea\u0015\u0011\u0007\r\u001by%C\u0002\u0004R\u0011\u0013qAT8uQ&tw\rE\u0002D\u0007+J1aa\u0016E\u0005\r\te.\u001f\u0005\b\u00077\n\u0004\u0019AA:\u0003))\u00070[:uS:<\u0017\n\u001a\u0005\b\u0007?\n\u0004\u0019AA:\u0003-yG\u000e\u001a)be\u0016tG/\u00133\t\u000f\r\r\u0014\u00071\u0001\u0002t\u0005Ya.Z<QCJ,g\u000e^%e\u0011\u001d\u0019\u0019!\ra\u0001\u0003W\u000bA#\u00197sK\u0006$\u00170\u0012=jgR\u001c()\u001f+ji2,GCBAV\u0007W\u001ay\u0007C\u0004\u0004nI\u0002\r!a\u001d\u0002\u0019A\fG\u000f^3s]RKG\u000f\\3\t\u0013\u0005E$\u0007%AA\u0002\u0005M\u0014AH1me\u0016\fG-_#ySN$8OQ=USRdW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019)H\u000b\u0003\u0002t\r-\u0011\u0001E2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197f)\u0019\tina\u001f\u0004\u0000!91Q\u0010\u001bA\u0002\u0005\u0005\u0014\u0001E3ySN$\u0018N\\4EK2Lg/\u001a:z\u0011%\u0019\t\t\u000eI\u0001\u0002\u0004\t\u0019(\u0001\u0004bGRLwN\u001c\u0015\u0004\u0001\r\u0015\u0005\u0003BBD\u0007\u001bk!a!#\u000b\t\r-\u0015QI\u0001\u000bgR,'/Z8usB,\u0017\u0002BBH\u0007\u0013\u0013qaU3sm&\u001cW\r")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public final String DEFAULT_STAGE_TITLE() {
        return "New Stage";
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = new StringOps(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$")).r();
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c)).head()).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = new StringOps(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1))).toInt();
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(((Object)BoxesRunTime.boxToInteger((int)(++orderNumber))).toString()).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage) {
        return this.addStage(this.getPattern(patternId), stage);
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        this.validateNewStage(pattern, stage, (Seq<Stage>)stages);
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, stages.size());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateNewStage(pattern, updated, (Seq<Stage>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()));
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        Checks.checkArgument((stage.getTransition() == null ? 1 : 0) != 0, (String)new StringBuilder(63).append("There is already a transition named '").append(transition.getTitle()).append("' associated with stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)((Object)x$2)));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)((Object)x$3)));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties(pattern, (Stage)((Object)stage));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateStages = (Buffer)((SeqLike)stageTitles.diff((GenSeq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateItems = (Buffer)((SeqLike)trackedItemTitles.diff((GenSeq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(Delivery pattern, Stage stage, Seq<Stage> stages) {
        this.validateStageProperties(pattern, stage);
        Checks.checkArgument((stages.count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) == 0 ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Delivery pattern, Stage stage) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    private void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

