/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.StageTrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class Stage
extends BaseConfigurationItem {
    @Property
    private String title;
    @Property(defaultValue="OPEN")
    private StageStatus status = StageStatus.OPEN;
    @Property(asContainment=true)
    private List<StageTrackedItem> items = new ArrayList<StageTrackedItem>();
    @Property(required=false)
    private Transition transition;

    public Stage() {
    }

    public Stage(String title) {
        this.title = title;
    }

    public StageTrackedItem getItemById(String trackedItemId) {
        return this.findItemById(trackedItemId).orElseThrow(() -> new LogFriendlyNotFoundException("Tracked item '%s' does not exist in stage '%s'", new Object[]{trackedItemId, this.title}));
    }

    public Optional<StageTrackedItem> findItemById(String trackedItemId) {
        return this.items.stream().filter(stageItem -> Ids.getName((String)stageItem.getTrackedItemId()).equals(Ids.getName((String)trackedItemId))).findFirst();
    }

    public void removeTrackedItem(String itemId) {
        this.items.removeIf(item -> Ids.getName((String)item.getTrackedItemId()).equals(Ids.getName((String)itemId)));
    }

    public void addTrackedItems(List<StageTrackedItem> items) {
        this.items.addAll(items);
    }

    public boolean isOpen() {
        return this.status == StageStatus.OPEN;
    }

    public boolean isClosed() {
        return this.status == StageStatus.CLOSED;
    }

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public StageStatus getStatus() {
        return this.status;
    }

    @PublicApiMember
    public void setStatus(StageStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public List<StageTrackedItem> getItems() {
        return this.items;
    }

    public void setItems(List<StageTrackedItem> items) {
        this.items = items;
    }

    public boolean hasTransition() {
        return this.getTransition() != null;
    }

    @PublicApiMember
    public Transition getTransition() {
        return this.transition;
    }

    @PublicApiMember
    public void setTransition(Transition transition) {
        this.transition = transition;
        if (transition != null) {
            this.transition.setStage(this);
        }
    }
}

