/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.security;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\f\u0018\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015Q\u0007\u0001\"\u0001n\u0011\u00151\b\u0001\"\u0001x\u0011\u00151\b\u0001\"\u0001z\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u0019q\b\u0001\"\u0001\u0002\u0006!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0006\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011Q\u0007\u0001\u0005\n\u0005]\"!\u0007#fY&4XM]=QKJl\u0017n]:j_:\u001c\u0005.Z2lKJT!\u0001G\r\u0002\u0011M,7-\u001e:jifT!AG\u000e\u0002\u0011\u0011,G.\u001b<fefT!\u0001H\u000f\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0010 \u0003%AXMY5bY\u0006\u00147OC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\t\u00011\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0016CV$\b.\u001a8uS\u000e\fG/[8o'\u0016\u0014h/[2f!\tYs&D\u0001-\u0015\tic&\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005aY\u0012B\u0001\u0019-\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cVM\u001d<jG\u0016\fa\u0003Z3mSZ,'/\u001f)biR,'O\\*feZL7-\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ke\tqa]3sm&\u001cW-\u0003\u00028i\t1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hnU3sm&\u001cW-A\beK2Lg/\u001a:z'\u0016\u0014h/[2f!\t\u0019$(\u0003\u0002<i\tyA)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\bC\u0001 @\u001b\u0005q\u0013B\u0001!/\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\r+ei\u0012%\u0011\u0005\u0011\u0003Q\"A\f\t\u000b%*\u0001\u0019\u0001\u0016\t\u000bE*\u0001\u0019\u0001\u001a\t\u000ba*\u0001\u0019A\u001d\t\u000bq*\u0001\u0019A\u001f)\u0005\u0015Q\u0005CA&W\u001b\u0005a%BA'O\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001fB\u000bqAZ1di>\u0014\u0018P\u0003\u0002R%\u0006)!-Z1og*\u00111\u000bV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ+A\u0002pe\u001eL!a\u0016'\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!C2iK\u000e\\g+[3x)\tQV\f\u0005\u0002%7&\u0011A,\n\u0002\u0005+:LG\u000fC\u0003_\r\u0001\u0007q,\u0001\u0006eK2Lg/\u001a:z\u0013\u0012\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012&\u001b\u0005\u0019'B\u00013\"\u0003\u0019a$o\\8u}%\u0011a-J\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gK\u0005\t2\r[3dWZKWm\u001e#fY&4XM]=\u0015\u0005ic\u0007\"\u00020\b\u0001\u0004yFC\u0001.o\u0011\u0015Q\u0002\u00021\u0001p!\t\u0001H/D\u0001r\u0015\tQ\"O\u0003\u0002t7\u00051Am\\7bS:L!!^9\u0003\u0011\u0011+G.\u001b<fef\f\u0011c\u00195fG.,E-\u001b;EK2Lg/\u001a:z)\tQ\u0006\u0010C\u0003_\u0013\u0001\u0007q\f\u0006\u0002[u\")!D\u0003a\u0001_\u0006q2\r[3dW\u0016#\u0017\u000e\u001e+sC\u000e\\W\rZ%uK6|e\u000eR3mSZ,'/\u001f\u000b\u00035vDQAX\u0006A\u0002}\u000b\u0001d\u00195fG.4\u0016.Z<EK2Lg/\u001a:z!\u0006$H/\u001a:o)\rQ\u0016\u0011\u0001\u0005\u0007\u0003\u0007a\u0001\u0019A0\u0002\u0013A\fG\u000f^3s]&#Gc\u0001.\u0002\b!1\u0011\u0011B\u0007A\u0002=\fq\u0001]1ui\u0016\u0014h.\u0001\rdQ\u0016\u001c7.\u00123ji\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$2AWA\b\u0011\u0019\t\u0019A\u0004a\u0001?R\u0019!,a\u0005\t\r\u0005%q\u00021\u0001p\u0003e\u0019\u0007.Z2l-&,w\u000fR3mSZ,'/_(o\r>dG-\u001a:\u0015\u0007i\u000bI\u0002\u0003\u0004\u0002\u001cA\u0001\raX\u0001\tM>dG-\u001a:JI\u0006I2\r[3dW\u0016#\u0017\u000e\u001e#fY&4XM]=P]\u001a{G\u000eZ3s)\rQ\u0016\u0011\u0005\u0005\u0007\u00037\t\u0002\u0019A0\u00029\rDWmY6FI&$HK]1dW\u0016$\u0017\n^3n\u001f:4u\u000e\u001c3feR\u0019!,a\n\t\r\u0005m!\u00031\u0001`\u0003\u0001\u001a\u0007.Z2l-&,w\u000fR3mSZ,'/\u001f)biR,'O\\(o\r>dG-\u001a:\u0015\u0007i\u000bi\u0003\u0003\u0004\u0002\u001cM\u0001\raX\u0001!G\",7m[#eSR$U\r\\5wKJL\b+\u0019;uKJtwJ\u001c$pY\u0012,'\u000fF\u0002[\u0003gAa!a\u0007\u0015\u0001\u0004y\u0016aF2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8P]\u001a{G\u000eZ3s)\u0015Q\u0016\u0011HA\u001e\u0011\u0019\tY\"\u0006a\u0001?\"9\u0011QH\u000bA\u0002\u0005}\u0012a\u00059fe6L7o]5p]N$vNV3sS\u001aL\b#\u0002\u0013\u0002B\u0005\u0015\u0013bAA\"K\tQAH]3qK\u0006$X\r\u001a \u0011\t\u0005\u001d\u00131K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u000b\u0007a\tyEC\u0002\u0002Ru\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003+\nIE\u0001\u0006QKJl\u0017n]:j_:D3\u0001AA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0%\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\r\u0014Q\f\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DeliveryPermissionChecker {
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryService deliveryService;
    private final PermissionChecker permissions;

    public void checkView(String deliveryId) {
        Delivery delivery = this.deliveryService.getDeliveryOrPattern(deliveryId);
        if (delivery.isTemplate()) {
            this.checkViewDeliveryPattern(delivery);
        } else {
            this.checkViewDelivery(delivery);
        }
    }

    public void checkViewDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkViewDelivery(Delivery delivery) {
        String folderId = delivery.getFolderId();
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(Delivery delivery) {
        this.checkEditDeliveryOnFolder(delivery.getFolderId());
    }

    public void checkEditTrackedItemOnDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditTrackedItemOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    private void checkViewDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET());
    }

    private void checkEditDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PERMISSION_SET());
    }

    private void checkEditTrackedItemOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_TRACKED_ITEM_PERMISSION_SET());
    }

    private void checkViewDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkEditDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkPermissionOnFolder(String folderId, Seq<Permission> permissionsToVerify) {
        this.permissions.checkAny(folderId, permissionsToVerify);
    }

    @Autowired
    public DeliveryPermissionChecker(AuthenticationService authenticationService, DeliveryPatternService deliveryPatternService, DeliveryService deliveryService, PermissionChecker permissions) {
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryService = deliveryService;
        this.permissions = permissions;
    }
}

