/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\t\re\u0001\u0002\u000f\u001e\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!Y\u0005A!b\u0001\n\u0007a\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011Y\u0003!Q1A\u0005\u0004]C\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\ta\u0002\u0011)\u0019!C\u0001c\"A!\u0010\u0001B\u0001B\u0003%!\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\ty\t\u0001C!\u0003#Cq!!&\u0001\t\u0003\n9\nC\u0004\u0002x\u0002!\t%!?\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0014\u0001\t\u0003\u0012y\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tu\u0003\u0001\"\u0003\u0003`\t)2+\u001d7EK2Lg/\u001a:z%\u0016\u0004xn]5u_JL(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\n!B]3q_NLGo\u001c:z\u0015\t\u00113%\u0001\u0005eK2Lg/\u001a:z\u0015\t!S%A\u0005yYJ,G.Z1tK*\u0011aeJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001K\u0001\u0004G>l7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\tq$\u0003\u00025?\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003M!W\r\\5wKJL\b+\u001a:tSN$XM\\2f!\t9$(D\u00019\u0015\tIT$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA\u001e9\u0005M!U\r\\5wKJL\b+\u001a:tSN$XM\\2f\u0003e!W\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0011\u0005]r\u0014BA 9\u0005e!U\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0002-Q\u0014\u0018mY6fI&#X-\u001c)feNL7\u000f^3oG\u0016\u0004\"a\u000e\"\n\u0005\rC$A\u0006+sC\u000e\\W\rZ%uK6\u0004VM]:jgR,gnY3\u0002)M\fHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s!\t1\u0015*D\u0001H\u0015\tq\u0002J\u0003\u0002!G%\u0011!j\u0012\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\tg\u0016\u001cWO]5us*\u0011!+J\u0001\tI\u0016\u0004Hn\\=ji&\u0011Ak\u0014\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\b%A\u0004eS\u0006dWm\u0019;\u0016\u0003a\u0003\"!\u00177\u000f\u0005iKgBA.h\u001d\taVM\u0004\u0002^I:\u0011al\u0019\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003C&\na\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\t17%\u0001\u0002eE&\u0011a\u0004\u001b\u0006\u0003M\u000eJ!A[6\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u001fQ&\u0011QN\u001c\u0002\b\t&\fG.Z2u\u0015\tQ7.\u0001\u0005eS\u0006dWm\u0019;!\u0003A!WmY8sCR|'oU3sm&\u001cW-F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0005j]R,'O\\1m\u0015\t98%A\u0002ba&L!!\u001f;\u0003A%sG/\u001a:oC2lU\r^1eCR\fG)Z2pe\u0006$xN]*feZL7-Z\u0001\u0012I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b~\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\f\u0011\u0005y\u0004Q\"A\u000f\t\u000bUZ\u0001\u0019\u0001\u001c\t\u000bqZ\u0001\u0019A\u001f\t\u000b\u0001[\u0001\u0019A!\t\u000b\u0011[\u0001\u0019A#\t\u000b-[\u00019A'\t\u000bY[\u00019\u0001-)\u0011\u0005%\u0011QBA\u0015\u0003W\u0001B!a\u0004\u0002&5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0006b]:|G/\u0019;j_:TA!a\u0006\u0002\u001a\u00059a-Y2u_JL(\u0002BA\u000e\u0003;\tQAY3b]NTA!a\b\u0002\"\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002$\u0005\u0019qN]4\n\t\u0005\u001d\u0012\u0011\u0003\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f#!!\f\u0002/ad'OU3q_NLGo\u001c:z'FdG)[1mK\u000e$\b\"\u00029\f\u0001\u0004\u0011\u0018\u0001\u0002:fC\u0012$B!!\u000e\u0002DA!\u0011qGA \u001b\t\tIDC\u0002#\u0003wQ1!!\u0010$\u0003\u0019!w.\\1j]&!\u0011\u0011IA\u001d\u0005!!U\r\\5wKJL\bbBA#\u0019\u0001\u0007\u0011qI\u0001\u000bI\u0016d\u0017N^3ss&#\u0007\u0003BA%\u0003#rA!a\u0013\u0002NA\u0011q,L\u0005\u0004\u0003\u001fj\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#AB*ue&twMC\u0002\u0002P5B3\u0001DA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0W\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\u0019'!\u0018\u0003\u0015%\u001b(+Z1e\u001f:d\u00170\u0001\bhKR\u0014\u00150\u00133PeRKG\u000f\\3\u0015\t\u0005U\u0012\u0011\u000e\u0005\b\u0003Wj\u0001\u0019AA$\u0003E!W\r\\5wKJL\u0018\nZ(s)&$H.\u001a\u0015\u0004\u001b\u0005e\u0013AB2sK\u0006$X\r\u0006\u0003\u0002t\u0005e\u0004c\u0001\u0017\u0002v%\u0019\u0011qO\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0007E9\u0001\r!!\u000e\u0002\rU\u0004H-\u0019;f)\u0011\t\u0019(a \t\r\tz\u0001\u0019AA\u001b\u0003\u0019)\u00070[:ugR!\u0011QQAF!\ra\u0013qQ\u0005\u0004\u0003\u0013k#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000b\u0002\u0002\u0019AA$Q\r\u0001\u0012\u0011L\u0001\u0007I\u0016dW\r^3\u0015\t\u0005M\u00141\u0013\u0005\b\u0003\u000b\n\u0002\u0019AA$\u0003\u0019\u0019X-\u0019:dQRq\u0011\u0011TAV\u0003\u007f\u000bY-!6\u0002`\u0006\r\bCBAN\u0003K\u000b)D\u0004\u0003\u0002\u001e\u0006\u0005fbA0\u0002 &\ta&C\u0002\u0002$6\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\u0006%&aA*fc*\u0019\u00111U\u0017\t\u000f\u00055&\u00031\u0001\u00020\u00069a-\u001b7uKJ\u001c\b\u0003BAY\u0003wk!!a-\u000b\t\u0005U\u0016qW\u0001\u0006M>\u0014Xn\u001d\u0006\u0004\u0003s3\u0018A\u0001<2\u0013\u0011\ti,a-\u0003/\u0005\u00137\u000f\u001e:bGR$U\r\\5wKJLh)\u001b7uKJ\u001c\bbBAa%\u0001\u0007\u00111Y\u0001\u0005a\u0006<W\r\u0005\u0003\u0002F\u0006\u001dW\"\u0001%\n\u0007\u0005%\u0007J\u0001\u0003QC\u001e,\u0007bBAg%\u0001\u0007\u0011qZ\u0001\b_J$WM\u001d\"z!\u0011\t\t,!5\n\t\u0005M\u00171\u0017\u0002\u0012\t\u0016d\u0017N^3ss>\u0013H-\u001a:N_\u0012,\u0007bBAl%\u0001\u0007\u0011\u0011\\\u0001\u000baJLgnY5qC2\u001c\bCBAN\u00037\f9%\u0003\u0003\u0002^\u0006%&\u0001C%uKJ\f'\r\\3\t\u000f\u0005\u0005(\u00031\u0001\u0002Z\u00069!o\u001c7f\u0013\u0012\u001c\bbBAs%\u0001\u0007\u0011q]\u0001\u0011C:LxJ\u001a)fe6L7o]5p]N\u0004b!a'\u0002&\u0006%\b\u0003BAv\u0003cl!!!<\u000b\u0007\u0005=x*\u0001\u0006qKJl\u0017n]:j_:LA!a=\u0002n\nQ\u0001+\u001a:nSN\u001c\u0018n\u001c8)\u0007I\tI&A\u0005tK\u0006\u00148\r[%egR!\u00111`A\u007f!\u0019\tY*!*\u0002H!9\u0011QV\nA\u0002\u0005=\u0006fA\n\u0002Z\u0005\u0011c-\u001b8e\t\u0016d\u0017N^3sS\u0016\u001c(+\u001a4fe\u0016t7-\u001b8h%\u0016dW-Y:f\u0013\u0012$B!a?\u0003\u0006!9!q\u0001\u000bA\u0002\u0005\u001d\u0013!\u0003:fY\u0016\f7/Z%e\u0003\u001d2\u0017N\u001c3BGRLg/\u001a#fY&4XM]5fgJ+g-\u001a:f]\u000eLgn\u001a$pY\u0012,'/\u00133\u0015\t\t5!Q\u0003\t\u0007\u00037\u000b)Ka\u0004\u0011\u0007]\u0012\t\"C\u0002\u0003\u0014a\u0012QbQ5JI^KG\u000f\u001b+ji2,\u0007b\u0002B\f+\u0001\u0007\u0011qI\u0001\tM>dG-\u001a:JI\"\u001aQ#!\u0017\u00021\u0019Lg\u000e\u001a*fY\u0016\f7/Z:Cs\u0012+G.\u001b<fefLE\r\u0006\u0003\u0003 \t5\u0002CBAN\u0003K\u0013\t\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\u0011\u00119#a.\u0002\u000bYLWm^:\n\t\t-\"Q\u0005\u0002\u0018\t\u0016d\u0017N^3ss\u001acwn\u001e*fY\u0016\f7/Z%oM>Dq!!\u0012\u0017\u0001\u0004\t9\u0005K\u0002\u0017\u00033\nA\u0002^8EK2Lg/\u001a:jKN$B!!'\u00036!9!qG\fA\u0002\te\u0012\u0001\u0002:poN\u0004b!a'\u0002&\nm\u0002cA\u001c\u0003>%\u0019!q\b\u001d\u0003\u0017\u0011+G.\u001b<fef\u0014vn^\u0001\u000bi>$U\r\\5wKJLHCBA\u001b\u0005\u000b\u0012I\u0005C\u0004\u0003Ha\u0001\rAa\u000f\u0002\u0007I|w\u000fC\u0004\u0003La\u0001\r!a?\u0002\u001b9,wOU3mK\u0006\u001cX-\u00133t\u000311\u0017N\u001c3G_2$WM]%e)\u0011\t9E!\u0015\t\u000f\u0005\u0015\u0013\u00041\u0001\u0002H!\u001a\u0011$!\u0017\u0002]\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5FM\u001a,7\r^5wKN+7-\u001e:jif\fe\u000e\u001a)biR,'O\u001c#fi\u0006LGn\u001d\u000b\u0005\u00033\u0013I\u0006C\u0004\u0003\\i\u0001\r!!'\u0002\u0015\u0011,G.\u001b<fe&,7/A\u0007nCB$v\u000eR3mSZ,'/\u001f\u000b\u0005\u0005C\u00129\u0007E\u0003-\u0005G\n)$C\u0002\u0003f5\u0012aa\u00149uS>t\u0007b\u0002B57\u0001\u0007!1N\u0001\u000fI\u0016d\u0017N^3ssJ{wo\u00149u!\u0015a#1\rB\u001eQ\r\u0001!q\u000e\t\u0005\u0005c\u00129(\u0004\u0002\u0003t)!!QOA\u000f\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005s\u0012\u0019H\u0001\u0006SKB|7/\u001b;pefD3\u0001\u0001B?!\u0011\tYFa \n\t\t\u0005\u0015Q\f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)((Object)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable & scala.Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMapping((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(originalDelivery.getTrackedItems()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        itemDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaSetConverter(originalDelivery.getReleaseIds()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, Seq<Permission> anyOfPermissions) {
        Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            String string;
            DeliverySqlBuilder deliverySqlBuilder = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))).withFolder(filters.getFolderId()).withPermissions((Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (Seq)Nil$.MODULE$ : anyOfPermissions), principals, roleIds);
            AbstractDeliveryFilters abstractDeliveryFilters = filters;
            if (abstractDeliveryFilters instanceof DeliveryFilters) {
                DeliveryFilters deliveryFilters = (DeliveryFilters)abstractDeliveryFilters;
                string = deliveryFilters.getOriginPatternId();
            } else {
                string = null;
            }
            Tuple2 sqlWithParams = deliverySqlBuilder.withOriginPatternId(string).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<DeliveryRow>)Nil$.MODULE$;
        }
        Seq<DeliveryRow> deliveryRows = seq;
        Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))).withFolder(filters.getFolderId()).build();
        return (Seq)this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.domainId(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable & scala.Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Delivery> toDeliveries(Seq<DeliveryRow> rows) {
        Map<Object, Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, (Seq<String>)((Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
    }

    private Delivery toDelivery(DeliveryRow row, Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)((Object)some.value());
        delivery.setFolderId(row.folderId().absolute());
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), Set$.MODULE$.canBuildFrom());
        delivery.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    private Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(Seq<Delivery> deliveries) {
        return (Seq)deliveries.map((Function1 & Serializable & scala.Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS(), (List)Nil$.MODULE$))).asJava());
            return delivery;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)delivery -> (Delivery)((Object)((Object)this.decorateWithEffectiveSecurityAndPatternDetails((Seq<Delivery>)((Seq)new .colon.colon((Object)delivery, (List)Nil$.MODULE$))).head())));
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

