/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.api.v1.forms.ValidatePattern;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryExecutionService;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.util.DeliveryUtils;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.repository.Page;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/delivery-patterns")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class DeliveryPatternApi
implements ApiService {
    private final DeliveryActorService deliveryActorService;
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryExecutionService deliveryExecutionService;
    private final DeliveryPermissionChecker permissions;

    @Autowired
    public DeliveryPatternApi(DeliveryActorService deliveryActorService, DeliveryPatternService deliveryPatternService, DeliveryExecutionService deliveryExecutionService, DeliveryPermissionChecker permissions) {
        this.deliveryActorService = deliveryActorService;
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryExecutionService = deliveryExecutionService;
        this.permissions = permissions;
    }

    public String serviceName() {
        return "deliveryPatternApi";
    }

    @POST
    @PublicApiMember
    @Timed
    public Delivery createPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"pattern");
        Checks.checkNotNull((Object)pattern.getFolderId(), (String)"pattern.folderId");
        this.permissions.checkEditDeliveryPattern(pattern);
        pattern.getTransitions().forEach(Transition::checkRestrictions);
        return this.deliveryPatternService.createDeliveryPattern(pattern);
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    @Timed
    public Delivery getPattern(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getPattern(patternId);
    }

    @GET
    @Path(value="/{patternIdOrTitle}")
    @PublicApiMember
    @Timed
    public Delivery getPatternByIdOrTitle(@PathParam(value="patternIdOrTitle") String patternIdOrTitle) {
        Delivery pattern = this.deliveryPatternService.getPatternByIdOrTitle(patternIdOrTitle);
        this.permissions.checkViewDeliveryPattern(pattern.getId());
        return pattern;
    }

    @POST
    @Path(value="/checkTitle")
    @Timed
    public boolean checkTitleUnique(ValidatePattern validation) {
        return !this.deliveryPatternService.existsPatternWithTitle(validation.getId(), validation.getTitle());
    }

    @PUT
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    @Timed
    public Delivery updatePattern(@PathParam(value="patternId") String patternId, Delivery pattern) {
        this.permissions.checkEditDeliveryPattern(patternId);
        this.permissions.checkEditDeliveryPattern(pattern);
        pattern.setId(patternId);
        return this.deliveryActorService.updatePattern(pattern);
    }

    @PublicApiMember
    @Timed
    public Delivery updatePattern(Delivery pattern) {
        return this.updatePattern(pattern.getId(), pattern);
    }

    @DELETE
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    @Timed
    public void deletePattern(@PathParam(value="patternId") String patternId) {
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deletePattern(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/duplicate")
    @Timed
    public Delivery duplicatePattern(@PathParam(value="patternId") String patternId, DuplicateDeliveryPattern duplicateDeliveryPattern) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.duplicatePattern(patternId, Objects.isNull(duplicateDeliveryPattern) ? new DuplicateDeliveryPattern() : duplicateDeliveryPattern);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/create")
    @PublicApiMember
    @Timed
    public Delivery createDeliveryFromPattern(@PathParam(value="patternId") String patternId, CreateDelivery createDelivery) {
        Checks.checkNotNull((Object)createDelivery, (String)"createDelivery");
        Checks.checkNotNull((Object)createDelivery.getFolderId(), (String)"createDelivery.folderId");
        this.permissions.checkEditDelivery(patternId);
        return this.deliveryActorService.createDeliveryFromPattern(patternId, createDelivery);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == filters) {
            filters = new DeliveryPatternFilters();
        }
        return this.deliveryPatternService.searchPatterns(filters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()));
    }

    @PublicApiMember
    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters) {
        return this.searchPatterns(filters, 0L, 100L);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    @Timed
    public Stage createStage(@PathParam(value="patternId") String patternId, Stage stage) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.addStage(patternId, stage);
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    @Timed
    public List<Stage> getStages(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getStages(patternId);
    }

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    @Timed
    public Stage updateStage(@PathParam(value="stageId") String stageId, Stage stage) {
        stage.setId(stageId);
        String patternId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updateStage(patternId, stage);
    }

    @PublicApiMember
    @Timed
    public Stage updateStage(Stage stage) {
        return this.updateStage(stage.getId(), stage);
    }

    @DELETE
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteStage(@PathParam(value="stageId") String stageId) {
        String patternId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteStage(patternId, stageId);
    }

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/transitions")
    @PublicApiMember
    @Timed
    public Transition createTransition(@PathParam(value="stageId") String stageId, Transition transition) {
        String patternId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        transition.checkRestrictions();
        return this.deliveryActorService.addTransition(patternId, stageId, transition);
    }

    @PUT
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    @Timed
    public Transition updateTransition(@PathParam(value="transitionId") String transitionId, Transition transition) {
        transition.setId(transitionId);
        String patternId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        transition.checkRestrictions();
        return this.deliveryActorService.updateTransition(patternId, transition);
    }

    @PublicApiMember
    @Timed
    public Transition updateTransition(Transition transition) {
        return this.updateTransition(transition.getId(), transition);
    }

    @DELETE
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTransition(@PathParam(value="transitionId") String transitionId) {
        String patternId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteTransition(patternId, transitionId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public TrackedItem createTrackedItem(@PathParam(value="patternId") String patternId, TrackedItem item) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.createTrackedItem(patternId, item);
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public List<TrackedItem> getTrackedItems(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryExecutionService.getTrackedItems(patternId);
    }

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public TrackedItem updateTrackedItem(@PathParam(value="itemId") String itemId, TrackedItem item) {
        item.setId(itemId);
        String patternId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updateTrackedItem(patternId, item);
    }

    @PublicApiMember
    @Timed
    public TrackedItem updateTrackedItem(TrackedItem item) {
        return this.updateTrackedItem(item.getId(), item);
    }

    @DELETE
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTrackedItem(@PathParam(value="itemId") String itemId) {
        String patternId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteTrackedItem(patternId, itemId);
    }
}

