from com.xebialabs.deployit.exception import NotFoundException
from com.xebialabs.xlrelease.api.v1.forms import CreateDelivery
from delivery import make_delivery_hyperlink

global deliveryPatternApi, task, title, patternId, startDate, endDate

try:
    pattern = deliveryPatternApi.getPatternByIdOrTitle(patternId)
except NotFoundException as error:
    print "Pattern id or title is not provided or incorrect"
    sys.exit(1)

params = CreateDelivery()
params.title = title
params.startDate = startDate
params.endDate = endDate
params.folderId = pattern.folderId

created = deliveryPatternApi.createDeliveryFromPattern(pattern.id, params)

print "Created delivery : %s" % make_delivery_hyperlink(created.title, created.id)
task.setStatusLine(make_delivery_hyperlink(created.title, created.id))

deliveryId = created.id
