/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.events.handler;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatusChangeSubscriber;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)q\u0006\u0001C\u0001a!)A\t\u0001C\u0001\u000b\")Q\u000b\u0001C\u0001-\")A\f\u0001C\u0001;\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\")\u0011\u000f\u0001C\u0005e\"I\u00111\t\u0001\u0012\u0002\u0013%\u0011Q\t\u0005\n\u00033\u0002\u0011\u0013!C\u0005\u00037\u0012!\u0005\u0016:bG.,G-\u0013;f[N#\u0018\r^;t'V\u00147o\u0019:jE\u0016\u0014\b*\u00198eY\u0016\u0014(B\u0001\b\u0010\u0003\u001dA\u0017M\u001c3mKJT!\u0001E\t\u0002\r\u00154XM\u001c;t\u0015\t\u00112#\u0001\u0005eK2Lg/\u001a:z\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0014\u0003\u0019\t7\r^8sg&\u0011q\u0005\n\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\tQS&D\u0001,\u0015\ta3#\u0001\u0006sKB|7/\u001b;pefL!AL\u0016\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"2!M\u001a5!\t\u0011\u0004!D\u0001\u000e\u0011\u0015\t3\u00011\u0001#\u0011\u0015A3\u00011\u0001*Q\t\u0019a\u0007\u0005\u00028\u00056\t\u0001H\u0003\u0002:u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005mb\u0014a\u00024bGR|'/\u001f\u0006\u0003{y\nQAY3b]NT!a\u0010!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Q\u0001\u0004_J<\u0017BA\"9\u0005%\tU\u000f^8xSJ,G-A\bp]&#X-\\\"p[BdW\r^3e)\t1\u0015\n\u0005\u0002\u001d\u000f&\u0011\u0001*\b\u0002\u0005+:LG\u000fC\u0003K\t\u0001\u00071*A\u0003fm\u0016tG\u000f\u0005\u0002M\u001b6\tq\"\u0003\u0002O\u001f\t\u0011\u0012\n^3n\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8uQ\t!\u0001\u000b\u0005\u0002R'6\t!K\u0003\u0002\u0011'%\u0011AK\u0015\u0002\n'V\u00147o\u0019:jE\u0016\fqb\u001c8Ji\u0016l\u0017I^1jY\u0006\u0014G.\u001a\u000b\u0003\r^CQAS\u0003A\u0002a\u0003\"\u0001T-\n\u0005i{!AE%uK6\fe/Y5mC\ndW-\u0012<f]RD#!\u0002)\u0002\u001b=t\u0017\n^3n'.L\u0007\u000f]3e)\t1e\fC\u0003K\r\u0001\u0007q\f\u0005\u0002MA&\u0011\u0011m\u0004\u0002\u0011\u0013R,WnU6jaB,G-\u0012<f]RD#A\u0002)\u0002\u001d=t\u0017\n^3n\t\u0016\u001c8m\u001c9fIR\u0011a)\u001a\u0005\u0006\u0015\u001e\u0001\rA\u001a\t\u0003\u0019\u001eL!\u0001[\b\u0003#%#X-\u001c#fg\u000e|\u0007/\u001a3Fm\u0016tG\u000f\u000b\u0002\b!\u0006iqN\\%uK6\u0014V-\\8wK\u0012$\"A\u00127\t\u000b)C\u0001\u0019A7\u0011\u00051s\u0017BA8\u0010\u0005AIE/Z7SK6|g/\u001a3Fm\u0016tG\u000f\u000b\u0002\t!\u0006Ar-\u001a;BGRLg/Z%uK6\u001cVOY:de&\u0014WM]:\u0015\u0013M\fY!!\u0007\u0002.\u0005]\u0002c\u0001;}\u007f:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003qf\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005ml\u0012a\u00029bG.\fw-Z\u0005\u0003{z\u00141aU3r\u0015\tYX\u0004\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aK\u0001\u0006cV,'/_\u0005\u0005\u0003\u0013\t\u0019AA\u0007UCN\\')Y:jG\u0012\u000bG/\u0019\u0005\u0007%%\u0001\r!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\u0012\u0003\u0019!w.\\1j]&!\u0011qCA\t\u0005!!U\r\\5wKJL\bbBA\u000e\u0013\u0001\u0007\u0011QD\u0001\u0007SR,W.\u00133\u0011\t\u0005}\u0011q\u0005\b\u0005\u0003C\t\u0019\u0003\u0005\u0002w;%\u0019\u0011QE\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)#\b\u0005\n\u0003_I\u0001\u0013!a\u0001\u0003c\tqa\u001d;bO\u0016LE\rE\u0003\u001d\u0003g\ti\"C\u0002\u00026u\u0011aa\u00149uS>t\u0007\"CA\u001d\u0013A\u0005\t\u0019AA\u001e\u0003\u0019\u0019H/\u0019;vgB)A$a\r\u0002>A!\u0011qBA \u0013\u0011\t\t%!\u0005\u0003#Q\u0013\u0018mY6fI&#X-\\*uCR,8/\u0001\u0012hKR\f5\r^5wK&#X-\\*vEN\u001c'/\u001b2feN$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fRC!!\r\u0002J-\u0012\u00111\n\t\u0005\u0003\u001b\n)&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003%)hn\u00195fG.,GM\u0003\u0002:;%!\u0011qKA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001#O\u0016$\u0018i\u0019;jm\u0016LE/Z7Tk\n\u001c8M]5cKJ\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005u#\u0006BA\u001e\u0003\u0013B3\u0001AA1!\r\t\u00161M\u0005\u0004\u0003K\u0012&!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_r\u0014AC:uKJ,w\u000e^=qK&!\u00111OA7\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class TrackedItemStatusSubscriberHandler {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;

    @Subscribe
    public void onItemCompleted(ItemCompletedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.READY)).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), new StringBuilder(43).append("All tracked items are completed in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemAvailable(ItemAvailableEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.NOT_READY)).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), new StringBuilder(43).append("All tracked items are available in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemSkipped(ItemSkippedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(64).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was skipped in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemDescoped(ItemDescopedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(53).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was descoped").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemRemoved(ItemRemovedEvent event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(52).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was removed").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<TaskBasicData> getActiveItemSubscribers(Delivery delivery, String itemId, Option<String> stageId, Option<TrackedItemStatus> status) {
        Buffer taskIds = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getSubscribersOfType(TrackedItemStatusChangeSubscriber.class)).asScala()).collect((PartialFunction)new scala.Serializable(null, delivery, itemId, stageId, status){
            public static final long serialVersionUID = 0L;
            private final Delivery delivery$1;
            private final String itemId$1;
            private final Option stageId$1;
            private final Option status$1;

            public final <A1 extends TrackedItemStatusChangeSubscriber, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.matches(this.delivery$1, this.itemId$1, (Option<String>)this.stageId$1, (Option<TrackedItemStatus>)this.status$1) ? A1.sourceId() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(TrackedItemStatusChangeSubscriber x1) {
                TrackedItemStatusChangeSubscriber trackedItemStatusChangeSubscriber = x1;
                boolean bl = trackedItemStatusChangeSubscriber.matches(this.delivery$1, this.itemId$1, (Option<String>)this.stageId$1, (Option<TrackedItemStatus>)this.status$1);
                return bl;
            }
            {
                this.delivery$1 = delivery$1;
                this.itemId$1 = itemId$1;
                this.stageId$1 = stageId$1;
                this.status$1 = status$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct();
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository.findTasksBasicData((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(taskIds).asJava())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TrackedItemStatusSubscriberHandler.$anonfun$getActiveItemSubscribers$1(x$2)));
    }

    private Option<String> getActiveItemSubscribers$default$3() {
        return None$.MODULE$;
    }

    private Option<TrackedItemStatus> getActiveItemSubscribers$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getActiveItemSubscribers$1(TaskBasicData x$2) {
        TaskStatus taskStatus = x$2.status();
        TaskStatus taskStatus2 = TaskStatus.IN_PROGRESS;
        return !(taskStatus != null ? !taskStatus.equals(taskStatus2) : taskStatus2 != null);
    }

    @Autowired
    public TrackedItemStatusSubscriberHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
    }
}

