/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u0010 \u00011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!b\u0001\n\u0007q\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011a\u0003!Q1A\u0005\u0004eC\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\te\u0002\u0011)\u0019!C\u0001g\"AA\u0010\u0001B\u0001B\u0003%A\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\t\n\u0001C!\u0003'Cq!a&\u0001\t\u0003\nI\nC\u0004\u0002z\u0002!\t%a?\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u000f\u0001\u0011\u0005#q\u0004\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003X\u0001!IA!\u0017\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002BA\u0001\u0011\u0005#1\u0011\u0002\u0016'FdG)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002%K\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002'O\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003Q%\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'N\u0007\u0002C%\u0011a'\t\u0002\u0013\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180A\neK2Lg/\u001a:z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002:y5\t!H\u0003\u0002<?\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ti$HA\nEK2Lg/\u001a:z!\u0016\u00148/[:uK:\u001cW-A\reK2Lg/\u001a:z\u001b\u0016l'-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u001dA\u0013\t\t%HA\rEK2Lg/\u001a:z\u001b\u0016l'-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0006;sC\u000e\\W\rZ%uK6\u0004VM]:jgR,gnY3\u0011\u0005e\"\u0015BA#;\u0005Y!&/Y2lK\u0012LE/Z7QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001F:rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002!\u0015*\u0011!%J\u0005\u0003\u0019&\u0013AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ,\u0012a\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b\u0001b]3dkJLG/\u001f\u0006\u0003)\u001e\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003-F\u0013!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA\u00059A-[1mK\u000e$X#\u0001.\u0011\u0005msgB\u0001/l\u001d\ti\u0016N\u0004\u0002_O:\u0011qL\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002iK\u0005\u0011AMY\u0005\u0003A)T!\u0001[\u0013\n\u00051l\u0017AC*rY\n+\u0018\u000e\u001c3fe*\u0011\u0001E[\u0005\u0003_B\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002m[\u0006AA-[1mK\u000e$\b%\u0001\teK\u000e|'/\u0019;peN+'O^5dKV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002zK\u0005\u0019\u0011\r]5\n\u0005m4(\u0001I%oi\u0016\u0014h.\u00197NKR\fG-\u0019;b\t\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Qyq0a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\t\u0019\u0004E\u0002\u0002\u0002\u0001i\u0011a\b\u0005\u0006o-\u0001\r\u0001\u000f\u0005\u0006}-\u0001\ra\u0010\u0005\u0006\u0005.\u0001\ra\u0011\u0005\u0006\r.\u0001\ra\u0012\u0005\u0006\u001b.\u0001\u001da\u0014\u0005\u00061.\u0001\u001dA\u0017\u0015\t\u0003\u001b\t\t\"!\f\u00020A!\u00111CA\u0015\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AC1o]>$\u0018\r^5p]*!\u00111DA\u000f\u0003\u001d1\u0017m\u0019;pefTA!a\b\u0002\"\u0005)!-Z1og*!\u00111EA\u0013\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\t)BA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011\u0011G\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRDQA]\u0006A\u0002Q\fAA]3bIR!\u0011\u0011HA#!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA G\u00051Am\\7bS:LA!a\u0011\u0002>\tAA)\u001a7jm\u0016\u0014\u0018\u0010C\u0004\u0002H1\u0001\r!!\u0013\u0002\u0015\u0011,G.\u001b<fefLE\r\u0005\u0003\u0002L\u0005Mc\u0002BA'\u0003\u001f\u0002\"!Y\u0018\n\u0007\u0005Es&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\n9F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#z\u0003f\u0001\u0007\u0002\\A!\u0011QLA2\u001b\t\tyFC\u0002\u0002b5\f1\u0002\u001e:b]N\f7\r^5p]&!\u0011QMA0\u0005)I5OU3bI>sG._\u0001\u000fO\u0016$()_%e\u001fJ$\u0016\u000e\u001e7f)\u0011\tI$a\u001b\t\u000f\u00055T\u00021\u0001\u0002J\u0005\tB-\u001a7jm\u0016\u0014\u00180\u00133PeRKG\u000f\\3)\u00075\tY&\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003k\nY\bE\u0002/\u0003oJ1!!\u001f0\u0005\u0011)f.\u001b;\t\r\u0011r\u0001\u0019AA\u001d\u0003\u0019)\b\u000fZ1uKR!\u0011QOAA\u0011\u0019!s\u00021\u0001\u0002:\u00051Q\r_5tiN$B!a\"\u0002\u000eB\u0019a&!#\n\u0007\u0005-uFA\u0004C_>dW-\u00198\t\u000f\u0005\u001d\u0003\u00031\u0001\u0002J!\u001a\u0001#a\u0017\u0002\r\u0011,G.\u001a;f)\u0011\t)(!&\t\u000f\u0005\u001d\u0013\u00031\u0001\u0002J\u000511/Z1sG\"$b\"a'\u0002.\u0006\u0005\u0017QZAl\u0003C\f)\u000f\u0005\u0004\u0002\u001e\u0006\u001d\u0016\u0011\b\b\u0005\u0003?\u000b\u0019KD\u0002b\u0003CK\u0011\u0001M\u0005\u0004\u0003K{\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003S\u000bYKA\u0002TKFT1!!*0\u0011\u001d\tyK\u0005a\u0001\u0003c\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0003\u00024\u0006uVBAA[\u0015\u0011\t9,!/\u0002\u000b\u0019|'/\\:\u000b\u0007\u0005m\u00060\u0001\u0002wc%!\u0011qXA[\u0005]\t%m\u001d;sC\u000e$H)\u001a7jm\u0016\u0014\u0018PR5mi\u0016\u00148\u000fC\u0004\u0002DJ\u0001\r!!2\u0002\tA\fw-\u001a\t\u0005\u0003\u000f\fI-D\u0001K\u0013\r\tYM\u0013\u0002\u0005!\u0006<W\rC\u0004\u0002PJ\u0001\r!!5\u0002\u000f=\u0014H-\u001a:CsB!\u00111WAj\u0013\u0011\t).!.\u0003#\u0011+G.\u001b<fef|%\u000fZ3s\u001b>$W\rC\u0004\u0002ZJ\u0001\r!a7\u0002\u0015A\u0014\u0018N\\2ja\u0006d7\u000f\u0005\u0004\u0002\u001e\u0006u\u0017\u0011J\u0005\u0005\u0003?\fYK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t\u0019O\u0005a\u0001\u00037\fqA]8mK&#7\u000fC\u0004\u0002hJ\u0001\r!!;\u0002!\u0005t\u0017p\u00144QKJl\u0017n]:j_:\u001c\bCBAO\u0003O\u000bY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\t0U\u0001\u000ba\u0016\u0014X.[:tS>t\u0017\u0002BA{\u0003_\u0014!\u0002U3s[&\u001c8/[8oQ\r\u0011\u00121L\u0001\ng\u0016\f'o\u00195JIN$B!!@\u0002\u0000B1\u0011QTAT\u0003\u0013Bq!a,\u0014\u0001\u0004\t\t\fK\u0002\u0014\u00037\n!EZ5oI\u0012+G.\u001b<fe&,7OU3gKJ,gnY5oOJ+G.Z1tK&#G\u0003BA\u007f\u0005\u000fAqA!\u0003\u0015\u0001\u0004\tI%A\u0005sK2,\u0017m]3JI\u00069c-\u001b8e\u0003\u000e$\u0018N^3EK2Lg/\u001a:jKN\u0014VMZ3sK:\u001c\u0017N\\4G_2$WM]%e)\u0011\u0011yAa\u0006\u0011\r\u0005u\u0015q\u0015B\t!\rI$1C\u0005\u0004\u0005+Q$!D\"j\u0013\u0012<\u0016\u000e\u001e5USRdW\rC\u0004\u0003\u001aU\u0001\r!!\u0013\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012D3!FA.\u0003a1\u0017N\u001c3SK2,\u0017m]3t\u0005f$U\r\\5wKJL\u0018\n\u001a\u000b\u0005\u0005C\u0011y\u0003\u0005\u0004\u0002\u001e\u0006\u001d&1\u0005\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()!!\u0011FA]\u0003\u00151\u0018.Z<t\u0013\u0011\u0011iCa\n\u0003/\u0011+G.\u001b<fef4En\\<SK2,\u0017m]3J]\u001a|\u0007bBA$-\u0001\u0007\u0011\u0011\n\u0015\u0004-\u0005m\u0013\u0001\u0004;p\t\u0016d\u0017N^3sS\u0016\u001cH\u0003BAN\u0005oAqA!\u000f\u0018\u0001\u0004\u0011Y$\u0001\u0003s_^\u001c\bCBAO\u0003O\u0013i\u0004E\u0002:\u0005\u007fI1A!\u0011;\u0005-!U\r\\5wKJL(k\\<\u0002\u0015Q|G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0004\u0002:\t\u001d#1\n\u0005\b\u0005\u0013B\u0002\u0019\u0001B\u001f\u0003\r\u0011xn\u001e\u0005\b\u0005\u001bB\u0002\u0019AA\u007f\u00035qWm\u001e*fY\u0016\f7/Z%eg\u0006aa-\u001b8e\r>dG-\u001a:JIR!\u0011\u0011\nB*\u0011\u001d\t9%\u0007a\u0001\u0003\u0013B3!GA.\u00039\"WmY8sCR,w+\u001b;i\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRL\u0018I\u001c3QCR$XM\u001d8EKR\f\u0017\u000e\\:\u0015\t\u0005m%1\f\u0005\b\u0005;R\u0002\u0019AAN\u0003)!W\r\\5wKJLWm]\u0001\u000e[\u0006\u0004Hk\u001c#fY&4XM]=\u0015\t\t\r$\u0011\u000e\t\u0006]\t\u0015\u0014\u0011H\u0005\u0004\u0005Oz#AB(qi&|g\u000eC\u0004\u0003lm\u0001\rA!\u001c\u0002\u001d\u0011,G.\u001b<fef\u0014vn^(qiB)aF!\u001a\u0003>\u0005!\u0012M]3Ji\u0016l7/\u00138UC\ndW-R9vC2$b!a\"\u0003t\tu\u0004b\u0002B;9\u0001\u0007!qO\u0001\b_2$\u0017\n^3n!\u0011\tYD!\u001f\n\t\tm\u0014Q\b\u0002\f)J\f7m[3e\u0013R,W\u000eC\u0004\u0003\u0000q\u0001\rAa\u001e\u0002\u000f9,w/\u0013;f[\u0006\u0011b-\u001b8e!\u0006$H/\u001a:o\u0005f$\u0016\u000e\u001e7f)\u0011\tID!\"\t\u000f\t\u001dU\u00041\u0001\u0002J\u0005)A/\u001b;mK\"\u001aQ$a\u0017)\u0007\u0001\u0011i\t\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\u0011\u0011\u0019*!\t\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003\u0018\nE%A\u0003*fa>\u001c\u0018\u000e^8ss\"\u001a\u0001Aa'\u0011\t\u0005u#QT\u0005\u0005\u0005?\u000byFA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)((Object)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable & scala.Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(originalDelivery.getTrackedItems()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), (Function2 & Serializable & scala.Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaSetConverter(originalDelivery.getReleaseIds()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, Seq<Permission> anyOfPermissions) {
        Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).withPermissions((Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (Seq)Seq$.MODULE$.empty() : anyOfPermissions), principals, roleIds).withOriginPatternId(filters.getOriginPatternId()).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<DeliveryRow>)Seq$.MODULE$.empty();
        }
        Seq<DeliveryRow> deliveryRows = seq;
        Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).build();
        return (Seq)this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.domainId(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable & scala.Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Delivery> toDeliveries(Seq<DeliveryRow> rows) {
        Map<Object, Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, (Seq<String>)((Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))), Seq$.MODULE$.canBuildFrom());
    }

    private Delivery toDelivery(DeliveryRow row, Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)((Object)some.value());
        delivery.setFolderId(row.folderId().absolute());
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), Set$.MODULE$.canBuildFrom());
        delivery.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    private Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(Seq<Delivery> deliveries) {
        return (Seq)deliveries.map((Function1 & Serializable & scala.Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS()}))).asJava(), DecoratorsCache$.MODULE$.NO_CACHE());
            return delivery;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)delivery -> (Delivery)((Object)((Object)this.decorateWithEffectiveSecurityAndPatternDetails((Seq<Delivery>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Delivery[]{delivery})))).head())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    @Override
    @IsReadOnly
    public Delivery findPatternByTitle(String title) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findPatternByTitle(title)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(title).append(" not found").toString(), new Object[0]);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

