/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Condition;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.ConditionTrigger;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.UserTrigger;
import com.xebialabs.xlrelease.delivery.util.DeliveryUtils$;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\tmg\u0001\u0002\u0011\"\u00011B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000b\u0001\u0004A\u0011A1\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a.\u0001\t\u0003\tI\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#A\u0011Ba\r\u0001#\u0003%\tA!\u000e\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013CqAa$\u0001\t\u0013\u0011\t\nC\u0004\u0003.\u0002!IAa,\t\u0013\tm\u0006!%A\u0005\n\tU\u0002b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0005a!U\r\\5wKJLX\t_3dkRLwN\\*feZL7-\u001a\u0006\u0003E\r\nqa]3sm&\u001cWM\u0003\u0002%K\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002'O\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003Q%\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006g24GG\u001b\u0006\u0002q\u0005AqM]5{u2,G-\u0003\u0002;k\t9Aj\\4hS:<\u0017A\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\"!\u0010!\u000e\u0003yR!aP\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002B}\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003\u007f\u0015J!aR#\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\buCN\\'+\u001a9pg&$xN]=\u0011\u0005\u0011S\u0015BA&F\u00059!\u0016m]6SKB|7/\u001b;pef\f1bY5JIN+'O^5dKB\u0011a\nU\u0007\u0002\u001f*\u0011!%J\u0005\u0003#>\u00131bQ5JIN+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002U/6\tQK\u0003\u0002WK\u00051QM^3oiNL!\u0001W+\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002\\=6\tAL\u0003\u0002^K\u00051\u0011m\u0019;peNL!a\u0018/\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u001d\u0011G-\u001a4hQ&\u0004\"a\u0019\u0001\u000e\u0003\u0005BQaO\u0004A\u0002qBQAQ\u0004A\u0002\rCQ\u0001S\u0004A\u0002%CQ\u0001T\u0004A\u00025CQAU\u0004A\u0002MCQ!W\u0004A\u0002iC#aB6\u0011\u00051<X\"A7\u000b\u00059|\u0017AC1o]>$\u0018\r^5p]*\u0011\u0001/]\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u00118/A\u0003cK\u0006t7O\u0003\u0002uk\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001w\u0003\ry'oZ\u0005\u0003q6\u0014\u0011\"Q;u_^L'/\u001a3\u000215\f'o[\"p]\u0012LG/[8o\u0003N\u001c\u0016\r^5tM&,G\r\u0006\u0003|}\u0006]\u0001C\u0001\u0018}\u0013\tixF\u0001\u0003V]&$\bBB@\t\u0001\u0004\t\t!\u0001\u0006eK2Lg/\u001a:z\u0013\u0012\u0004B!a\u0001\u0002\u00129!\u0011QAA\u0007!\r\t9aL\u0007\u0003\u0003\u0013Q1!a\u0003,\u0003\u0019a$o\\8u}%\u0019\u0011qB\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"!\u0006\u0003\rM#(/\u001b8h\u0015\r\tya\f\u0005\b\u00033A\u0001\u0019AA\u0001\u0003-\u0019wN\u001c3ji&|g.\u00133)\u0007!\ti\u0002\u0005\u0003\u0002 \u0005-RBAA\u0011\u0015\rq\u00171\u0005\u0006\u0005\u0003K\t9#A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005%\u0012&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ti#!\t\u0003\u000bQKW.\u001a3\u000215\fg.^1m\u0007>l\u0007\u000f\\3uKR\u0013\u0018M\\:ji&|g\u000eF\u0004|\u0003g\t)$!\u000f\t\r}L\u0001\u0019AA\u0001\u0011\u001d\t9$\u0003a\u0001\u0003\u0003\tA\u0002\u001e:b]NLG/[8o\u0013\u0012Dq!a\u000f\n\u0001\u0004\ti$\u0001\u0006qCJ\fW.\u001a;feN\u0004B!a\u0010\u0002N5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0003g_Jl7O\u0003\u0003\u0002H\u0005%\u0013A\u0001<2\u0015\r\tY%J\u0001\u0004CBL\u0017\u0002BA(\u0003\u0003\u0012!cQ8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011\"!\b\u0002#\u0015DXmY;uKR\u0013\u0018M\\:ji&|g\u000eF\u0003|\u0003/\n9\u0007C\u0004\u0002Z)\u0001\r!a\u0017\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tgI\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0015\u0014q\f\u0002\u000b)J\fgn]5uS>t\u0007bBA5\u0015\u0001\u0007\u00111N\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u00055\u0014\u0011O\u0007\u0003\u0003_R1!!\u0017$\u0013\u0011\t\u0019(a\u001c\u0003!Q\u0013\u0018M\\:ji&|g\u000eU1sC6\u001c\u0018A\u0005:fO&\u001cH/\u001a:Tk\n\u001c8M]5cKJ$b!!\u001f\u0002\u0000\u0005\u0005\u0005\u0003BA/\u0003wJA!! \u0002`\t\u00112+\u001e2tGJL\u0007\u000f^5p]J+7/\u001e7u\u0011\u0019y8\u00021\u0001\u0002\u0002!9\u00111Q\u0006A\u0002\u0005\u0015\u0015AC:vEN\u001c'/\u001b2feB!\u0011QLAD\u0013\u0011\tI)a\u0018\u0003\u0015M+(m]2sS\n,'\u000fK\u0002\f\u0003;\tQcZ3u)J\f7m[3e\u0013R,WNQ=USRdW\r\u0006\u0004\u0002\u0012\u0006]\u0015\u0011\u0014\t\u0005\u0003;\n\u0019*\u0003\u0003\u0002\u0016\u0006}#a\u0003+sC\u000e\\W\rZ%uK6Daa \u0007A\u0002\u0005\u0005\u0001bBAN\u0019\u0001\u0007\u0011\u0011A\u0001\nSR,W\u000eV5uY\u0016D3\u0001DA\u000f\u0003=9W\r\u001e+sC\u000e\\W\rZ%uK6\u001cH\u0003BAR\u0003g\u0003b!!*\u00020\u0006EUBAAT\u0015\u0011\tI+a+\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003[\u000bAA[1wC&!\u0011\u0011WAT\u0005\u0011a\u0015n\u001d;\t\r}l\u0001\u0019AA\u0001Q\ri\u0011QD\u0001\u0012GJ,\u0017\r^3Ue\u0006\u001c7.\u001a3Ji\u0016lGCBAI\u0003w\u000bi\f\u0003\u0004\u0000\u001d\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u007fs\u0001\u0019AAI\u0003\u0011IG/Z7)\u00079\ti\"A\tva\u0012\fG/\u001a+sC\u000e\\W\rZ%uK6$b!!%\u0002H\u0006%\u0007BB@\u0010\u0001\u0004\t\t\u0001C\u0004\u0002@>\u0001\r!!%)\u0007=\ti\"A\teK2,G/\u001a+sC\u000e\\W\rZ%uK6$Ra_Ai\u0003'Daa \tA\u0002\u0005\u0005\u0001bBAk!\u0001\u0007\u0011\u0011A\u0001\u0007SR,W.\u00133)\u0007A\ti\"\u0001\neKN\u001cw\u000e]3Ue\u0006\u001c7.\u001a3Ji\u0016lG#B>\u0002^\u0006}\u0007BB@\u0012\u0001\u0004\t\t\u0001C\u0004\u0002VF\u0001\r!!\u0001)\u0007E\ti\"\u0001\nsKN\u001cw\u000e]3Ue\u0006\u001c7.\u001a3Ji\u0016lG#B>\u0002h\u0006%\bBB@\u0013\u0001\u0004\t\t\u0001C\u0004\u0002VJ\u0001\r!!\u0001)\u0007I\ti\"\u0001\u000bsK\u001eL7\u000f^3s)J\f7m[3e\u0013R,Wn\u001d\u000b\bw\u0006E\u00181\u001fB\u0005\u0011\u0019y8\u00031\u0001\u0002\u0002!9\u0011Q_\nA\u0002\u0005]\u0018!B5uK6\u001c\bCBA}\u0005\u0007\t\tA\u0004\u0003\u0002|\u0006}h\u0002BA\u0004\u0003{L\u0011\u0001M\u0005\u0004\u0005\u0003y\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005\u000b\u00119AA\u0002TKFT1A!\u00010\u0011\u001d\u0011Ya\u0005a\u0001\u0003\u0003\tQB\u001a:p[J+G.Z1tK&#\u0007fA\n\u0002\u001e\u00059R.\u0019:l)J\f7m[3e\u0013R,Wn]%o'R\fw-\u001a\u000b\u000f\u0003G\u0013\u0019B!\u0006\u0003\u001a\tm!Q\u0005B\u0014\u0011\u0019yH\u00031\u0001\u0002\u0002!9!q\u0003\u000bA\u0002\u0005\u0005\u0011aB:uC\u001e,\u0017\n\u001a\u0005\b\u0003k$\u0002\u0019AA|\u0011\u001d\u0011i\u0002\u0006a\u0001\u0005?\taa\u001d;biV\u001c\b\u0003BA/\u0005CIAAa\t\u0002`\t\tBK]1dW\u0016$\u0017\n^3n'R\fG/^:\t\u000f\t-A\u00031\u0001\u0002\u0002!I!\u0011\u0006\u000b\u0011\u0002\u0003\u0007!1F\u0001\u0010aJ,7-\u001a3j]\u001e\u001cF/Y4fgB\u0019aF!\f\n\u0007\t=rFA\u0004C_>dW-\u00198)\u0007Q\ti\"A\u0011nCJ\\GK]1dW\u0016$\u0017\n^3ng&s7\u000b^1hK\u0012\"WMZ1vYR$c'\u0006\u0002\u00038)\"!1\u0006B\u001dW\t\u0011Y\u0004\u0005\u0003\u0003>\t\u0015SB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\u0013Ut7\r[3dW\u0016$'B\u000180\u0013\u0011\u00119Ea\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ftW&\u0004HK]1dW\u0016$\u0017\n^3n\u0013:\u001cF/Y4f)\u001dY(Q\nB(\u0005#Baa \fA\u0002\u0005\u0005\u0001b\u0002B\f-\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003+4\u0002\u0019AA\u0001Q\r1\u0012QD\u0001\u000eG>l\u0007\u000f\\3uKN#\u0018mZ3\u0015\u000bm\u0014IFa\u0017\t\r}<\u0002\u0019AA\u0001\u0011\u001d\u00119b\u0006a\u0001\u0003\u0003A3aFA\u000f\u0003-\u0011Xm\u001c9f]N#\u0018mZ3\u0015\u000bm\u0014\u0019G!\u001a\t\r}D\u0002\u0019AA\u0001\u0011\u001d\u00119\u0002\u0007a\u0001\u0003\u0003A3\u0001GA\u000f\u0003-!wnV5uQN#\u0018mZ3\u0015\u000fm\u0014iGa\u001c\u0003r!1q0\u0007a\u0001\u0003\u0003AqAa\u0006\u001a\u0001\u0004\t\t\u0001C\u0004\u0003te\u0001\rA!\u001e\u0002\u0005\u0019t\u0007\u0003\u0003\u0018\u0003x\tm$\u0011Q>\n\u0007\tetFA\u0005Gk:\u001cG/[8oeA\u00191M! \n\u0007\t}\u0014E\u0001\u000bEK2Lg/\u001a:z'R\fG/Z'b]\u0006<WM\u001d\t\u0005\u0003;\u0012\u0019)\u0003\u0003\u0003\u0006\u0006}#!B*uC\u001e,\u0017A\u00049s_\u000e,7o]\"iC:<Wm\u001d\u000b\u0004w\n-\u0005b\u0002BG5\u0001\u0007!1P\u0001\b[\u0006t\u0017mZ3s\u0003y\u0001\u0018M\u001d;ji&|g.\u0013;f[N\u0014\u00150\u0012=jgRLgnZ!oI:+w\u000f\u0006\u0004\u0003\u0014\nm%1\u0015\t\b]\tU%\u0011\u0014BM\u0013\r\u00119j\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005e(1AAI\u0011\u0019!3\u00041\u0001\u0003\u001eB!\u0011Q\fBP\u0013\u0011\u0011\t+a\u0018\u0003\u0011\u0011+G.\u001b<fefDqA!*\u001c\u0001\u0004\u00119+\u0001\bji\u0016l\u0017\nZ(s)&$H.Z:\u0011\r\u0005\r!\u0011VA\u0001\u0013\u0011\u0011Y+!\u0006\u0003\u0007M+G/\u0001\u0007wC2LG-\u0019;f\u0013R,W\u000eF\u0004|\u0005c\u0013\u0019La.\t\r\u0011b\u0002\u0019\u0001BO\u0011\u001d\u0011)\f\ba\u0001\u0003#\u000b1\u0002\u001e:bG.,G-\u0013;f[\"I!\u0011\u0018\u000f\u0011\u0002\u0003\u0007!1F\u0001\u0010m\u0006d\u0017\u000eZ1uK6+WNY3sg\u00061b/\u00197jI\u0006$X-\u0013;f[\u0012\"WMZ1vYR$3'\u0001\bwC2LG-\u0019;f\u001b\u0016l'-\u001a:\u0015\u0007m\u0014\t\rC\u0004\u0003Dz\u0001\r!!\u0001\u0002\u0013I,G.Z1tK&#\u0017\u0001\u0004<bY&$\u0017\r^3UCN\\GcA>\u0003J\"9!1Z\u0010A\u0002\u0005\u0005\u0011A\u0002;bg.LE\rK\u0002\u0001\u0005\u001f\u0004BA!5\u0003X6\u0011!1\u001b\u0006\u0004\u0005+\u001c\u0018AC:uKJ,w\u000e^=qK&!!\u0011\u001cBj\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DeliveryExecutionService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryExecutionService deliveryExecutionService = this;
        synchronized (deliveryExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void markConditionAsSatisfied(String deliveryId, String conditionId) {
        block1: {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Marking condition '").append(conditionId).append("' as satisfied").toString());
            Delivery delivery = this.deliveryRepository.read(deliveryId);
            Transition transition = delivery.getTransitionByIdOrTitle(DeliveryUtils$.MODULE$.transitionIdFrom(conditionId));
            Condition condition = transition.getConditionById(conditionId);
            Stage stage = transition.getStage();
            Condition root = transition.getRootCondition();
            Buffer changes = ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(root.markAsSatisfied(conditionId, new Date())).asScala()).$minus$eq((Object)root);
            if (!changes.nonEmpty()) break block1;
            this.deliveryRepository.update(delivery);
            ((IterableLike)changes.map((Function1 & Serializable & scala.Serializable)x$1 -> new ConditionSatisfiedEvent((Condition)((Object)x$1), transition, delivery), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.eventBus.publish(x$1);
                return BoxedUnit.UNIT;
            });
            if (root.isSatisfied() && stage.isOpen()) {
                Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getStageGroupOfStage(stage)).asScala();
                Set completedItems = ((TraversableOnce)DeliveryUtils$.MODULE$.getItemsCompletedInAllStages((Seq<TrackedItem>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()))), (Seq<Stage>)stages).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).toSet();
                Seq transitionedItems = (Seq)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delivery.findNextStage(stage))).map((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$4.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTrackedItemId(), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
                Set toTransition = (Set)completedItems.$minus$minus((GenTraversableOnce)transitionedItems);
                this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)toTransition, true, new ConditionTrigger(conditionId, condition.toString())));
            }
        }
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByTransitionId(transitionId);
        Transition transition = stage.getTransition();
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull(parameters.getTransitionItems(), (String)"Transition items");
        Set transitionItems = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(parameters.getTransitionItems()).asScala()).toSet();
        transitionItems.foreach((Function1 & Serializable & scala.Serializable)itemId -> {
            DeliveryExecutionService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)transitionItems, parameters.isCloseStages(), new UserTrigger(Permissions.getAuthenticatedUserName())));
    }

    private void executeTransition(Transition transition, TransitionParams params) {
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(params.delivery(), this.ciIdService);
        manager.handleTransition(transition, params);
        this.processChanges(manager);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append((Object)subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq existingItems = (Seq)tuple2._1();
        Seq newItems = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        Seq existingItems2 = (Seq)tuple23._1();
        Seq newItems2 = (Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        delivery.addReleaseId(fromReleaseId);
        existingItems2.foreach((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.addReleaseId(fromReleaseId)));
        newItems2.foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
            this.validateItem(delivery, (TrackedItem)((Object)item), false);
            return manager.addTrackedItem((TrackedItem)((Object)item));
        });
        this.processChanges(manager);
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        Seq existingItems = (Seq)((TraversableLike)items.distinct()).map((Function1 & Serializable & scala.Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)((Object)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).find((Function1 & Serializable & scala.Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            })));
        }, Seq$.MODULE$.canBuildFrom());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                manager.addReleaseToItem(x$10, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            DeliveryExecutionService.$anonfun$processChanges$1(this, x$11);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())), Buffer$.MODULE$.canBuildFrom()));
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), (Object)i), Buffer$.MODULE$.canBuildFrom()));
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Seq$.MODULE$.empty()), (Object)Seq$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Seq existingAcc = (Seq)tuple2._1();
            Seq newAcc = (Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable & scala.Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable & scala.Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable & scala.Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom()));
            }, (Function1 & Serializable & scala.Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom())), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem, boolean validateMembers) {
        block1: {
            LazyRef lowerCaseTitle$lzy = new LazyRef();
            Checks.checkNotNull((Object)((Object)trackedItem), (String)"Tracked item");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
            Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((!((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).exists((Function1 & Serializable & scala.Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
            if (trackedItem.getReleaseIds() == null) {
                trackedItem.setReleaseIds(new HashSet<String>());
            }
            if (!validateMembers) break block1;
            trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        }
    }

    private boolean validateItem$default$3() {
        return true;
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$6) {
        return x$6.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$2, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$2.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((TraversableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery$2.getStagesBefore(stage$1)).asScala()).$colon$plus((Object)stage$1, Buffer$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$manualCompleteTransition$3(itemId, x$6)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").append(new StringBuilder(53).append(" in stage '").append(((TraversableOnce)notDoneInStages.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTitle(), Buffer$.MODULE$.canBuildFrom())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryExecutionService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryExecutionService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryExecutionService $this, String x$11) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> x$11);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryExecutionService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryExecutionService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryExecutionService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

