/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryExecutionService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.delivery.util.DeliveryUtils;
import com.xebialabs.xlrelease.repository.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/deliveries")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ShowOnlyPublicApiMembers
public class DeliveryApi
implements ApiService {
    private final DeliveryActorService deliveryActorService;
    private final DeliveryService deliveryService;
    private final DeliveryExecutionService deliveryExecutionService;
    private final DeliveryPermissionChecker permissions;

    @Autowired
    public DeliveryApi(DeliveryActorService deliveryActorService, DeliveryService deliveryService, DeliveryExecutionService deliveryExecutionService, DeliveryPermissionChecker permissions) {
        this.deliveryActorService = deliveryActorService;
        this.deliveryService = deliveryService;
        this.deliveryExecutionService = deliveryExecutionService;
        this.permissions = permissions;
    }

    public String serviceName() {
        return "deliveryApi";
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @Timed
    public Delivery getDelivery(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getDelivery(deliveryId);
    }

    @DELETE
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @Timed
    public void deleteDelivery(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.deleteDelivery(deliveryId);
    }

    @PUT
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @Timed
    public Delivery updateDelivery(@PathParam(value="deliveryId") String deliveryId, Delivery delivery) {
        this.permissions.checkEditDelivery(deliveryId);
        this.permissions.checkEditDelivery(delivery);
        delivery.setId(deliveryId);
        Delivery existingDelivery = this.deliveryService.getDelivery(deliveryId);
        delivery.setStatus(existingDelivery.getStatus());
        return this.deliveryActorService.updateDelivery(delivery);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/releases")
    @Timed
    public List<String> getReleases(@PathParam(value="deliveryId") String deliveryId) {
        Checks.checkNotNull((Object)deliveryId, (String)"deliveryId");
        this.permissions.checkViewDelivery(deliveryId);
        return new ArrayList<String>(this.deliveryService.getDelivery(deliveryId).getReleaseIds());
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Delivery> searchDeliveries(DeliveryFilters deliveryFilters, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage, @DefaultValue(value="START_DATE") @QueryParam(value="orderBy") DeliveryOrderMode orderBy) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == deliveryFilters) {
            deliveryFilters = new DeliveryFilters();
        }
        return this.deliveryService.search(deliveryFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()), orderBy);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/timeline")
    @Timed
    public DeliveryTimeline getDeliveryTimeline(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getTimeline(deliveryId, DateTime.now());
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/releasesInfo")
    @Timed
    public List<DeliveryFlowReleaseInfo> getContributingReleases(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getReleases(deliveryId);
    }

    @PublicApiMember
    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryActorService.registerSubscriber(deliveryId, subscriber);
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public List<TrackedItem> getTrackedItems(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryExecutionService.getTrackedItems(deliveryId);
    }

    @POST
    @Path(value="/{deliveryId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public TrackedItem createTrackedItem(@PathParam(value="deliveryId") String deliveryId, TrackedItem item) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        return this.deliveryActorService.createTrackedItem(deliveryId, item);
    }

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public TrackedItem updateTrackedItem(@PathParam(value="itemId") String itemId, TrackedItem item) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        Checks.checkArgument((boolean)itemId.equals(item.getId()), (String)"Request to update tracked item [%s] contains an object with different ID: [%s]", (Object[])new Object[]{itemId, item.getId()});
        return this.deliveryActorService.updateTrackedItem(deliveryId, item);
    }

    @DELETE
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTrackedItem(@PathParam(value="itemId") String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.deleteTrackedItem(deliveryId, itemId);
    }

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}/descope")
    @PublicApiMember
    @Timed
    public void descopeTrackedItem(@PathParam(value="itemId") String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.descopeTrackedItem(deliveryId, itemId);
    }

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}/rescope")
    @PublicApiMember
    @Timed
    public void rescopeTrackedItem(@PathParam(value="itemId") String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.rescopeTrackedItem(deliveryId, itemId);
    }

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}/{itemId:.*TrackedItem[^/]*}/skip")
    @PublicApiMember
    @Timed
    public void skipTrackedItem(@PathParam(value="stageId") String stageId, @PathParam(value="itemId") String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.skipTrackedItem(deliveryId, stageId, itemId);
    }

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}/{itemId:.*TrackedItem[^/]*}/complete")
    @PublicApiMember
    @Timed
    public void completeTrackedItem(@PathParam(value="stageId") String stageId, @PathParam(value="itemId") String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(stageId);
        this.markTrackedItemsInStage(deliveryId, stageId, Collections.singletonList(itemId), TrackedItemStatus.READY, false, null);
    }

    @PublicApiMember
    @Timed
    public void registerTrackedItems(String deliveryId, List<String> itemIdOrTitles, String fromReleaseId) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.registerTrackedItems(deliveryId, itemIdOrTitles, fromReleaseId);
    }

    @PublicApiMember
    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageIdOrTitle, List<String> itemIdOrTitles, TrackedItemStatus status, boolean precedingStages, String releaseId) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        return this.deliveryActorService.markTrackedItemsInStage(deliveryId, stageIdOrTitle, itemIdOrTitles, status, precedingStages, releaseId);
    }

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/complete")
    @PublicApiMember
    @Timed
    public void completeStage(@PathParam(value="stageId") String stageId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.completeStage(deliveryId, stageId);
    }

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/reopen")
    @PublicApiMember
    @Timed
    public void reopenStage(@PathParam(value="stageId") String stageId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.reopenStage(deliveryId, stageId);
    }

    @POST
    @Path(value="/{transitionId:.*Transition[^/]*}/complete")
    @PublicApiMember
    @Timed
    public void completeTransition(@PathParam(value="transitionId") String transitionId, CompleteTransition completeTransition) {
        String deliveryId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.completeTransition(deliveryId, transitionId, completeTransition);
    }

    @PUT
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    @Timed
    public Transition updateTransition(@PathParam(value="transitionId") String transitionId, Transition transition) {
        transition.setId(transitionId);
        String deliveryId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDelivery(deliveryId);
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        transition.checkRestrictions();
        return this.deliveryActorService.updateTransition(deliveryId, transition);
    }
}

