/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.delivery.domain.Condition;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.domain.condition.ConditionGroup;
import com.xebialabs.xlrelease.delivery.events.ConditionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTimelineCalculator;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\r5a\u0001B\u0014)\u0001MB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011)\u0019!C\u0001S\"AQ\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0001p\u0011!\u0019\bA!A!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011A;\t\u0011q\u0004!\u0011!Q\u0001\nYD\u0001\" \u0001\u0003\u0006\u0004%\tA \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n}D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\tY\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005}\u0001BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u0002\"!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!a-\u0001\t\u0003\t\t\u000eC\u0004\u0002\\\u0002!\t!!8\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bbBAz\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0004\u0003\u001a\u0002!\tAa'\t\u000f\t%\u0006\u0001\"\u0001\u0003,\"9!Q\u0017\u0001\u0005\u0002\t]\u0006b\u0002Bi\u0001\u0011E#1\u001b\u0005\n\u0005;\u0004\u0011\u0013!C\t\u0005?DqA!5\u0001\t#\u0011\u0019PA\bEK2Lg/\u001a:z'\u0016\u0014h/[2f\u0015\tI#&A\u0004tKJ4\u0018nY3\u000b\u0005-b\u0013\u0001\u00033fY&4XM]=\u000b\u00055r\u0013!\u0003=me\u0016dW-Y:f\u0015\ty\u0003'A\u0005yK\nL\u0017\r\\1cg*\t\u0011'A\u0002d_6\u001c\u0001aE\u0003\u0001ii\u0012e\t\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nQa\u001d7gi)T\u0011aP\u0001\tOJL'P\u001f7fI&\u0011\u0011\t\u0010\u0002\b\u0019><w-\u001b8h!\t\u0019E)D\u0001)\u0013\t)\u0005F\u0001\u000eEK2Lg/\u001a:z)&lW\r\\5oK\u000e\u000bGnY;mCR|'\u000f\u0005\u0002D\u000f&\u0011\u0001\n\u000b\u0002\u0015\t\u0016d\u0017N^3ssN+'O^5dKV#\u0018\u000e\\:\u0002%\u0011,G.\u001b<fef\u0014V\r]8tSR|'/_\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJK\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001)N\u0005I!U\r\\5wKJL(+\u001a9pg&$xN]=\u0002'\u0011,G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001U!\t)v+D\u0001W\u0015\tqE&\u0003\u0002Y-\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f+\u0005a\u0006CA/`\u001b\u0005q&BA\u0015-\u0013\t\u0001gL\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001fI,G.Z1tKN+'O^5dK\u0002\n\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0016\u0003\u0011\u0004\"!X3\n\u0005\u0019t&\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\t'o\u00195jm&twmU3sm&\u001cW\rI\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003)\u0004\"!X6\n\u00051t&\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002aB\u0011Q,]\u0005\u0003ez\u00131bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010L\u0001\u0003I\nL!a\u001f=\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u0005iam\u001c7eKJ\u001cVM\u001d<jG\u0016,\u0012a \t\u0004;\u0006\u0005\u0011bAA\u0002=\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\faBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,WCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0001b]3dkJLG/\u001f\u0006\u0004\u0003+q\u0013\u0001\u00033fa2|\u00170\u001b;\n\t\u0005e\u0011q\u0002\u0002\f%>dWmU3sm&\u001cW-\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007%\u0001\u0005fm\u0016tGOQ;t+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003L\u0001\u0007KZ,g\u000e^:\n\t\u0005-\u0012Q\u0005\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}Q1\u00121GA\u001b\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0005\u0002D\u0001!)\u0011*\u0006a\u0001\u0017\")!+\u0006a\u0001)\")!,\u0006a\u00019\")!-\u0006a\u0001I\")\u0001.\u0006a\u0001U\")a.\u0006a\u0001a\")A/\u0006a\u0001m\")Q0\u0006a\u0001\u007f\"9\u0011qA\u000bA\u0002\u0005-\u0001bBA\u000f+\u0001\u0007\u0011\u0011\u0005\u0015\u0004+\u0005-\u0003\u0003BA'\u0003Gj!!a\u0014\u000b\t\u0005E\u00131K\u0001\u000bC:tw\u000e^1uS>t'\u0002BA+\u0003/\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002Z\u0005m\u0013!\u00022fC:\u001c(\u0002BA/\u0003?\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003C\n1a\u001c:h\u0013\u0011\t)'a\u0014\u0003\u0013\u0005+Ho\\<je\u0016$\u0017aC4fi\u0012+G.\u001b<fef$B!a\u001b\u0002xA!\u0011QNA:\u001b\t\tyGC\u0002\u0002r)\na\u0001Z8nC&t\u0017\u0002BA;\u0003_\u0012\u0001\u0002R3mSZ,'/\u001f\u0005\b\u0003s2\u0002\u0019AA>\u0003)!W\r\\5wKJL\u0018\n\u001a\t\u0005\u0003{\nYI\u0004\u0003\u0002\u0000\u0005\u001d\u0005cAAAm5\u0011\u00111\u0011\u0006\u0004\u0003\u000b\u0013\u0014A\u0002\u001fs_>$h(C\u0002\u0002\nZ\na\u0001\u0015:fI\u00164\u0017\u0002BAG\u0003\u001f\u0013aa\u0015;sS:<'bAAEm!\u001aa#a%\u0011\t\u0005U\u0015\u0011U\u0007\u0003\u0003/SA!!\u0015\u0002\u001a*!\u00111TAO\u0003\u001diW\r\u001e:jGNT1!a(1\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAR\u0003/\u0013Q\u0001V5nK\u0012\fa\"\u001a=jgR\u001cH)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0002*\u0006=\u0006cA\u001b\u0002,&\u0019\u0011Q\u0016\u001c\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011P\fA\u0002\u0005m\u0004fA\f\u0002\u0014\u0006q1M]3bi\u0016$U\r\\5wKJLH\u0003BA6\u0003oCaa\u000b\rA\u0002\u0005-\u0004f\u0001\r\u0002<B!\u0011QXAf\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017aC1o]>$\u0018\r^5p]NTA!!2\u0002H\u000611m\\7n_:T1!!31\u0003\u00199wn\\4mK&!\u0011QZA`\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0015\u00041\u0005MECBA6\u0003'\f)\u000e\u0003\u0004,3\u0001\u0007\u00111\u000e\u0005\b\u0003/L\u0002\u0019AAU\u0003%\u0011Xm\u001e:ji\u0016LE\rK\u0002\u001a\u0003'\u000ba\"\u001e9eCR,G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0002l\u0005}\u0007bBAq5\u0001\u0007\u00111N\u0001\bkB$\u0017\r^3eQ\rQ\u00121S\u0001\u000fI\u0016dW\r^3EK2Lg/\u001a:z)\u0011\tI/a<\u0011\u0007U\nY/C\u0002\u0002nZ\u0012A!\u00168ji\"9\u0011\u0011P\u000eA\u0002\u0005m\u0004fA\u000e\u0002\u0014\u0006\u0001R\u000f\u001d3bi\u0016$&/\u00198tSRLwN\u001c\u000b\u0007\u0003o\fi0a@\u0011\t\u00055\u0014\u0011`\u0005\u0005\u0003w\fyG\u0001\u0006Ue\u0006t7/\u001b;j_:Dq!!\u001f\u001d\u0001\u0004\tY\bC\u0004\u0002br\u0001\r!a>)\u0007q\t\u0019\n\u0006\u0004\u0002x\n\u0015!q\u0001\u0005\u0007Wu\u0001\r!a\u001b\t\u000f\u0005\u0005X\u00041\u0001\u0002x\"\u001aQ$a%\u0002!U\u0004H-\u0019;f\u0007>tG-\u001b;j_:\u001cHC\u0002B\b\u0005O\u0011Y\u0003\u0005\u0004\u0003\u0012\tm!\u0011\u0005\b\u0005\u0005'\u00119B\u0004\u0003\u0002\u0002\nU\u0011\"A\u001c\n\u0007\tea'A\u0004qC\u000e\\\u0017mZ3\n\t\tu!q\u0004\u0002\u0004'\u0016\f(b\u0001B\rmA!\u0011Q\u000eB\u0012\u0013\u0011\u0011)#a\u001c\u0003\u0013\r{g\u000eZ5uS>t\u0007b\u0002B\u0015=\u0001\u0007\u0011q_\u0001\u0013_JLw-\u001b8bYR\u0013\u0018M\\:ji&|g\u000eC\u0004\u0003.y\u0001\r!a>\u0002#U\u0004H-\u0019;fIR\u0013\u0018M\\:ji&|g.\u0001\u0004tK\u0006\u00148\r\u001b\u000b\t\u0005g\u0011\u0019Ea\u0017\u0003fA1!Q\u0007B \u0003Wj!Aa\u000e\u000b\t\te\"1H\u0001\u0005kRLGN\u0003\u0002\u0003>\u0005!!.\u0019<b\u0013\u0011\u0011\tEa\u000e\u0003\t1K7\u000f\u001e\u0005\b\u0005\u000bz\u0002\u0019\u0001B$\u0003\u001d1\u0017\u000e\u001c;feN\u0004BA!\u0013\u0003X5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%A\u0003g_Jl7O\u0003\u0003\u0003R\tM\u0013A\u0001<2\u0015\r\u0011)\u0006L\u0001\u0004CBL\u0017\u0002\u0002B-\u0005\u0017\u0012q#\u00112tiJ\f7\r\u001e#fY&4XM]=GS2$XM]:\t\u000f\tus\u00041\u0001\u0003`\u0005!\u0001/Y4f!\r)&\u0011M\u0005\u0004\u0005G2&\u0001\u0002)bO\u0016DqAa\u001a \u0001\u0004\u0011I'A\u0004pe\u0012,'OQ=\u0011\t\t%#1N\u0005\u0005\u0005[\u0012YEA\tEK2Lg/\u001a:z\u001fJ$WM]'pI\u0016D3aHAJ\u0003-9W\r\u001e+j[\u0016d\u0017N\\3\u0015\r\tU$\u0011\u0011BB!\u0011\u00119H! \u000e\u0005\te$\u0002\u0002B>\u0005\u001f\nQA^5foNLAAa \u0003z\t\u0001B)\u001a7jm\u0016\u0014\u0018\u0010V5nK2Lg.\u001a\u0005\b\u0003s\u0002\u0003\u0019AA>\u0011\u001d\u0011)\t\ta\u0001\u0005\u000f\u000b1A\\8x!\u0011\u0011IIa%\u000e\u0005\t-%\u0002\u0002BG\u0005\u001f\u000bA\u0001^5nK*!!\u0011SA0\u0003\u0011Qw\u000eZ1\n\t\tU%1\u0012\u0002\t\t\u0006$X\rV5nK\"\u001a\u0001%a%\u0002\u0017\u001d,GOU3mK\u0006\u001cXm\u001d\u000b\u0005\u0005;\u0013)\u000b\u0005\u0004\u00036\t}\"q\u0014\t\u0005\u0005o\u0012\t+\u0003\u0003\u0003$\ne$a\u0006#fY&4XM]=GY><(+\u001a7fCN,\u0017J\u001c4p\u0011\u001d\tI(\ta\u0001\u0003wB3!IAJ\u0003\u00012\u0017N\u001c3EK2Lg/\u001a:jKN\u0014VMZ3sK:\u001c\u0017N\\4SK2,\u0017m]3\u0015\t\t5&q\u0016\t\u0007\u0005#\u0011Y\"a\u001f\t\u000f\tE&\u00051\u0001\u0002|\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004E\u0005M\u0015!\n4j]\u0012\f5\r^5wK\u0012+G.\u001b<fe&,7OU3gKJ,gnY5oO\u001a{G\u000eZ3s)\u0011\u0011ILa3\u0011\r\tE!1\u0004B^!\u0011\u0011iLa2\u000e\u0005\t}&\u0002\u0002Ba\u0005\u0007\f1\u0002]3sg&\u001cH/\u001a8dK*\u0019!QY'\u0002\u0007M\fH.\u0003\u0003\u0003J\n}&!D\"j\u0013\u0012<\u0016\u000e\u001e5USRdW\rC\u0004\u0003N\u000e\u0002\r!a\u001f\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012D3aIAJ\u0003A\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0004\u0002j\nU'\u0011\u001c\u0005\b\u0005/$\u0003\u0019AA6\u0003A)\u00070[:uS:<G)\u001a7jm\u0016\u0014\u0018\u0010C\u0005\u0003\\\u0012\u0002\n\u00111\u0001\u0002|\u00051\u0011m\u0019;j_:\f!d\u00195fG.L5/\u00169eCR\f'\r\\3%I\u00164\u0017-\u001e7uII*\"A!9+\t\u0005m$1]\u0016\u0003\u0005K\u0004BAa:\u0003p6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000b\u001c\n\t\tE(\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003BAu\u0005kDqAa>'\u0001\u0004\u0011I0A\u0003ti\u0006<W\r\u0005\u0003\u0002n\tm\u0018\u0002\u0002B\u007f\u0003_\u0012Qa\u0015;bO\u0016D3\u0001AB\u0001!\u0011\u0019\u0019a!\u0003\u000e\u0005\r\u0015!\u0002BB\u0004\u00037\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019Ya!\u0002\u0003\u000fM+'O^5dK\u0002")
public class DeliveryService
implements DeliveryTimelineCalculator,
DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final ArchivingService archivingService;
    private final ReleaseSearchService releaseSearchService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    @Override
    public DeliveryTimeline calculateTimeline(Delivery delivery, DateTime now) {
        return DeliveryTimelineCalculator.calculateTimeline$(this, delivery, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return DeliveryTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryService deliveryService = this;
        synchronized (deliveryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getDelivery(String deliveryId) {
        void var2_2;
        Delivery delivery = this.getDeliveryOrPattern(deliveryId);
        this.checkIsDelivery(delivery);
        return var2_2;
    }

    @Timed
    public boolean existsDelivery(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    @VisibleForTesting
    public Delivery createDelivery(Delivery delivery) {
        return this.createDelivery(delivery, true);
    }

    @Timed
    public Delivery createDelivery(Delivery delivery, boolean rewriteId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new release delivery [").append((Object)delivery).append("]").toString());
        this.validateDelivery(delivery);
        String deliveryId = rewriteId || delivery.getId() == null || !Ids.isDeliveryId((String)delivery.getId()) ? this.factory().deliveryId() : delivery.getId();
        delivery.setId(deliveryId);
        CiHelper.rewriteWithNewId((ConfigurationItem)delivery, (String)deliveryId);
        delivery.getStages().forEach(stage -> Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            transition.setStage(stage);
            return BoxedUnit.UNIT;
        }));
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryService.$anonfun$createDelivery$4(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public Delivery updateDelivery(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating release delivery [").append((Object)updated).append("]").toString());
        this.validateDelivery(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Deleting release delivery [").append(deliveryId).append("]").toString());
        Delivery delivery = this.deliveryRepository().read(deliveryId);
        this.checkIsDelivery(delivery);
        this.doDelete(deliveryId);
    }

    @Timed
    public Transition updateTransition(String deliveryId, Transition updated) {
        return this.updateTransition(this.getDelivery(deliveryId), updated);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Transition updateTransition(Delivery delivery, Transition updated) {
        void var3_3;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updating transition [").append((Object)updated).append("]").toString());
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Transition original = delivery.getTransitionByIdOrTitle(updated.getId());
        Transition originalBeforeChanges = (Transition)CiCloneHelper.cloneCi((ConfigurationItem)original);
        Stage stage = original.getStage();
        this.checkIsUpdatable(stage);
        this.validateTransition(delivery, stage, updated);
        Seq<Condition> updatedConditions = this.updateConditions(original, updated);
        original.setAutomated(updated.isAutomated());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(originalBeforeChanges, updated, delivery));
        updatedConditions.foreach((Function1 & Serializable & scala.Serializable)condition -> {
            DeliveryService.$anonfun$updateTransition$2(this, original, delivery, condition);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private Seq<Condition> updateConditions(Transition originalTransition, Transition updatedTransition) {
        Buffer originalConditions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(originalTransition.getAllConditions()).asScala();
        Buffer updatedConditions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTransition.getAllConditions()).asScala();
        Checks.checkArgument((originalConditions.size() == updatedConditions.size() ? 1 : 0) != 0, (String)"Not permitted to add or remove conditions on a running delivery", (Object[])new Object[0]);
        return (Seq)((TraversableLike)originalConditions.zip((GenIterable)updatedConditions, Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Condition condition;
                Condition original = (Condition)((Object)((Object)tuple2._1()));
                Condition updated = (Condition)((Object)((Object)tuple2._2()));
                String string = original.getId();
                String string2 = updated.getId();
                Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)new StringBuilder(77).append("Updating order or structure of conditions not allowed on a running delivery. ").append(new StringBuilder(30).append("Expected condition '").append(original.getId()).append("', got '").append(updated.getId()).append("''").toString()).toString(), (Object[])new Object[0]);
                Type type = original.getType();
                Type type2 = updated.getType();
                Checks.checkArgument((!(type != null ? !type.equals(type2) : type2 != null) ? 1 : 0) != 0, (String)"Condition type cannot be changed on a running delivery", (Object[])new Object[0]);
                Condition condition2 = original;
                if (condition2 instanceof ConditionGroup) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else if (condition2 != null && (condition = condition2).isSatisfied()) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    Buffer changedProps = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(original.getInputProperties()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.areEqual((ConfigurationItem)original, (ConfigurationItem)updated)));
                    changedProps.foreach((Function1 & Serializable & scala.Serializable)pd -> {
                        pd.set((ConfigurationItem)original, pd.get((ConfigurationItem)updated));
                        return BoxedUnit.UNIT;
                    });
                    iterable = changedProps.nonEmpty() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)original)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, Buffer$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET())).asJava();
    }

    @Timed
    public DeliveryTimeline getTimeline(String deliveryId, DateTime now) {
        Delivery delivery = this.getDelivery(deliveryId);
        return this.calculateTimeline(delivery, now);
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        Seq<DeliveryFlowReleaseInfo> releases = this.deliveryRepository().findReleasesByDeliveryId(deliveryId);
        Set<String> allReleaseIds = this.deliveryRepository().getByIdOrTitle(deliveryId).getReleaseIds();
        Seq seq = ((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(allReleaseIds).asScala()).filterNot((Function1 & Serializable & scala.Serializable)fullId -> BoxesRunTime.boxToBoolean((boolean)DeliveryService.$anonfun$getReleases$1(releases, fullId)))).toSeq();
        Seq seq2 = Nil$.MODULE$.equals(seq) ? (Seq)Seq$.MODULE$.empty() : (Seq)this.archivingService().searchReleasesBasicExtByReleaseIds(seq).map((Function1 & Serializable & scala.Serializable)item -> new DeliveryFlowReleaseInfo(Ids.getName((String)item.id()), item.title(), item.status(), item.startDate(), item.endDate(), true), Seq$.MODULE$.canBuildFrom());
        Seq archivedReleases = seq2;
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releases.$plus$plus((GenTraversableOnce)archivedReleases, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public Seq<String> findDeliveriesReferencingRelease(String releaseId) {
        return this.deliveryRepository().findDeliveriesReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolder(String folderId) {
        return this.deliveryRepository().findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        Checks.checkArgument((boolean)existingDelivery.isUpdatable(), (String)new StringBuilder(42).append("Cannot ").append(action).append(" release delivery '").append(existingDelivery.getTitle()).append("' because it is ").append((Object)existingDelivery.getStatus()).toString(), (Object[])new Object[0]);
    }

    public void checkIsUpdatable(Stage stage) {
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(60).append("Cannot update transition on stage '").append(stage.getTitle()).append("' because it is COMPLETED").toString(), (Object[])new Object[0]);
    }

    @Override
    public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static final /* synthetic */ void $anonfun$createDelivery$4(DeliveryService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$updateTransition$2(DeliveryService $this, Transition original$1, Delivery delivery$2, Condition condition) {
        $this.eventBus().publish((XLReleaseEvent)new ConditionUpdatedEvent(condition, original$1, delivery$2));
    }

    public static final /* synthetic */ boolean $anonfun$getReleases$1(Seq releases$1, String fullId) {
        return ((SeqLike)releases$1.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).contains((Object)Ids.getName((String)fullId));
    }

    @Autowired
    public DeliveryService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, ArchivingService archivingService, ReleaseSearchService releaseSearchService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.archivingService = archivingService;
        this.releaseSearchService = releaseSearchService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryTimelineCalculator.$init$(this);
        DeliveryServiceUtils.$init$(this);
    }
}

