/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.ManualTransitionTrigger;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTransitionHandler;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0010!\u0001-B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011}\u0003!\u0011!Q\u0001\n\u0001DQ\u0001\u001a\u0001\u0005\u0002\u0015DQ! \u0001\u0005\u0002yDq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a1\u0001\t\u0003\t)\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"I!1\u0003\u0001\u0012\u0002\u0013\u0005!Q\u0003\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003J\u0001!IAa\u0013\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002BG\u0001\u0011%!q\u0012\u0005\n\u00057\u0003\u0011\u0013!C\u0005\u0005+AqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003&\u0002!IAa*\u0003/\u0011+G.\u001b<fef$&/Y2lS:<7+\u001a:wS\u000e,'BA\u0011#\u0003\u001d\u0019XM\u001d<jG\u0016T!a\t\u0013\u0002\u0011\u0011,G.\u001b<fefT!!\n\u0014\u0002\u0013ad'/\u001a7fCN,'BA\u0014)\u0003%AXMY5bY\u0006\u00147OC\u0001*\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000f\u001b\u0003\u000f1{wmZ5oO\u0006\u0011B-\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z!\tat(D\u0001>\u0015\tq$%\u0001\u0006sKB|7/\u001b;pefL!\u0001Q\u001f\u0003%\u0011+G.\u001b<fef\u0014V\r]8tSR|'/_\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA\"F\u001b\u0005!%B\u0001 %\u0013\t1EIA\tSK2,\u0017m]3SKB|7/\u001b;pef\fa\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002D\u0013&\u0011!\n\u0012\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u00055{U\"\u0001(\u000b\u0005\u0005\"\u0013B\u0001)O\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0011\u00154XM\u001c;CkN\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u0013\u0002\r\u00154XM\u001c;t\u0013\t9FKA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0013\u0002\r\u0005\u001cGo\u001c:t\u0013\tq6LA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\reK2Lg/\u001a:z)J\fgn]5uS>t\u0007*\u00198eY\u0016\u0014\bCA1c\u001b\u0005\u0001\u0013BA2!\u0005e!U\r\\5wKJLHK]1og&$\u0018n\u001c8IC:$G.\u001a:\u0002\rqJg.\u001b;?)!1w\r[5kW2l\u0007CA1\u0001\u0011\u0015Q\u0004\u00021\u0001<\u0011\u0015\t\u0005\u00021\u0001C\u0011\u00159\u0005\u00021\u0001I\u0011\u0015Y\u0005\u00021\u0001M\u0011\u0015\t\u0006\u00021\u0001S\u0011\u0015A\u0006\u00021\u0001Z\u0011\u0015y\u0006\u00021\u0001aQ\tAq\u000e\u0005\u0002qw6\t\u0011O\u0003\u0002sg\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Q,\u0018a\u00024bGR|'/\u001f\u0006\u0003m^\fQAY3b]NT!\u0001_=\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011A_\u0001\u0004_J<\u0017B\u0001?r\u0005%\tU\u000f^8xSJ,G-\u0001\rnC:,\u0018\r\\\"p[BdW\r^3Ue\u0006t7/\u001b;j_:$ra`A\u0003\u0003?\t\u0019\u0003E\u0002.\u0003\u0003I1!a\u0001/\u0005\u0011)f.\u001b;\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005QA-\u001a7jm\u0016\u0014\u00180\u00133\u0011\t\u0005-\u0011\u0011\u0004\b\u0005\u0003\u001b\t)\u0002E\u0002\u0002\u00109j!!!\u0005\u000b\u0007\u0005M!&\u0001\u0004=e>|GOP\u0005\u0004\u0003/q\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u00189Bq!!\t\n\u0001\u0004\tI!\u0001\u0007ue\u0006t7/\u001b;j_:LE\rC\u0004\u0002&%\u0001\r!a\n\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002*\u0005]RBAA\u0016\u0015\u0011\ti#a\f\u0002\u000b\u0019|'/\\:\u000b\t\u0005E\u00121G\u0001\u0003mFR1!!\u000e%\u0003\r\t\u0007/[\u0005\u0005\u0003s\tYC\u0001\nD_6\u0004H.\u001a;f)J\fgn]5uS>t\u0007fA\u0005\u0002>A!\u0011qHA&\u001b\t\t\tEC\u0002s\u0003\u0007RA!!\u0012\u0002H\u00059Q.\u001a;sS\u000e\u001c(bAA%Q\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002N\u0005\u0005#!\u0002+j[\u0016$\u0017A\u0005:fO&\u001cH/\u001a:Tk\n\u001c8M]5cKJ$b!a\u0015\u0002`\u0005\u0005\u0004\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005e#%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003;\n9F\u0001\nTk\n\u001c8M]5qi&|gNU3tk2$\bbBA\u0004\u0015\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003GR\u0001\u0019AA3\u0003)\u0019XOY:de&\u0014WM\u001d\t\u0005\u0003+\n9'\u0003\u0003\u0002j\u0005]#AC*vEN\u001c'/\u001b2fe\"\u001a!\"!\u0010\u0002+\u001d,G\u000f\u0016:bG.,G-\u0013;f[\nKH+\u001b;mKR1\u0011\u0011OA<\u0003s\u0002B!!\u0016\u0002t%!\u0011QOA,\u0005-!&/Y2lK\u0012LE/Z7\t\u000f\u0005\u001d1\u00021\u0001\u0002\n!9\u00111P\u0006A\u0002\u0005%\u0011!C5uK6$\u0016\u000e\u001e7fQ\rY\u0011QH\u0001\u0010O\u0016$HK]1dW\u0016$\u0017\n^3ngR!\u00111QAJ!\u0019\t))a$\u0002r5\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003vi&d'BAAG\u0003\u0011Q\u0017M^1\n\t\u0005E\u0015q\u0011\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\b1\u0001\r!!\u0003)\u00071\ti$A\tde\u0016\fG/\u001a+sC\u000e\\W\rZ%uK6$b!!\u001d\u0002\u001c\u0006u\u0005bBA\u0004\u001b\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003?k\u0001\u0019AA9\u0003\u0011IG/Z7)\u00075\ti$A\tva\u0012\fG/\u001a+sC\u000e\\W\rZ%uK6$b!!\u001d\u0002(\u0006%\u0006bBA\u0004\u001d\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003?s\u0001\u0019AA9Q\rq\u0011QH\u0001\u0012I\u0016dW\r^3Ue\u0006\u001c7.\u001a3Ji\u0016lG#B@\u00022\u0006M\u0006bBA\u0004\u001f\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003k{\u0001\u0019AA\u0005\u0003\u0019IG/Z7JI\"\u001aq\"!\u0010\u0002%\u0011,7oY8qKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0006\u007f\u0006u\u0016q\u0018\u0005\b\u0003\u000f\u0001\u0002\u0019AA\u0005\u0011\u001d\t)\f\u0005a\u0001\u0003\u0013A3\u0001EA\u001f\u0003I\u0011Xm]2pa\u0016$&/Y2lK\u0012LE/Z7\u0015\u000b}\f9-!3\t\u000f\u0005\u001d\u0011\u00031\u0001\u0002\n!9\u0011QW\tA\u0002\u0005%\u0001fA\t\u0002>\u0005!\"/Z4jgR,'\u000f\u0016:bG.,G-\u0013;f[N$ra`Ai\u0003'\fI\u000fC\u0004\u0002\bI\u0001\r!!\u0003\t\u000f\u0005U'\u00031\u0001\u0002X\u0006)\u0011\u000e^3ngB1\u0011\u0011\\Ar\u0003\u0013qA!a7\u0002`:!\u0011qBAo\u0013\u0005y\u0013bAAq]\u00059\u0001/Y2lC\u001e,\u0017\u0002BAs\u0003O\u00141aU3r\u0015\r\t\tO\f\u0005\b\u0003W\u0014\u0002\u0019AA\u0005\u000351'o\\7SK2,\u0017m]3JI\"\u001a!#!\u0010\u0002/5\f'o\u001b+sC\u000e\\W\rZ%uK6\u001c\u0018J\\*uC\u001e,GCDAB\u0003g\f)0!?\u0002|\n\u0015!q\u0001\u0005\b\u0003\u000f\u0019\u0002\u0019AA\u0005\u0011\u001d\t9p\u0005a\u0001\u0003\u0013\tqa\u001d;bO\u0016LE\rC\u0004\u0002VN\u0001\r!a6\t\u000f\u0005u8\u00031\u0001\u0002\u0000\u000611\u000f^1ukN\u0004B!!\u0016\u0003\u0002%!!1AA,\u0005E!&/Y2lK\u0012LE/Z7Ti\u0006$Xo\u001d\u0005\b\u0003W\u001c\u0002\u0019AA\u0005\u0011%\u0011Ia\u0005I\u0001\u0002\u0004\u0011Y!A\bqe\u0016\u001cW\rZ5oON#\u0018mZ3t!\ri#QB\u0005\u0004\u0005\u001fq#a\u0002\"p_2,\u0017M\u001c\u0015\u0004'\u0005u\u0012!I7be.$&/Y2lK\u0012LE/Z7t\u0013:\u001cF/Y4fI\u0011,g-Y;mi\u00122TC\u0001B\fU\u0011\u0011YA!\u0007,\u0005\tm\u0001\u0003\u0002B\u000f\u0005Ki!Aa\b\u000b\t\t\u0005\"1E\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001d\u0018\n\t\t\u001d\"q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF:lSB$&/Y2lK\u0012LE/Z7J]N#\u0018mZ3\u0015\u000f}\u0014iCa\f\u00032!9\u0011qA\u000bA\u0002\u0005%\u0001bBA|+\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003k+\u0002\u0019AA\u0005Q\r)\u0012QH\u0001\u000eG>l\u0007\u000f\\3uKN#\u0018mZ3\u0015\u000b}\u0014IDa\u000f\t\u000f\u0005\u001da\u00031\u0001\u0002\n!9\u0011q\u001f\fA\u0002\u0005%\u0001f\u0001\f\u0002>\u0005Y!/Z8qK:\u001cF/Y4f)\u0015y(1\tB#\u0011\u001d\t9a\u0006a\u0001\u0003\u0013Aq!a>\u0018\u0001\u0004\tI\u0001K\u0002\u0018\u0003{\t1\u0002Z8XSRD7\u000b^1hKR9qP!\u0014\u0003P\tE\u0003bBA\u00041\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003oD\u0002\u0019AA\u0005\u0011\u001d\u0011\u0019\u0006\u0007a\u0001\u0005+\n!A\u001a8\u0011\u00115\u00129Fa\u0017\u0003b}L1A!\u0017/\u0005%1UO\\2uS>t'\u0007E\u0002b\u0005;J1Aa\u0018!\u0005Q!U\r\\5wKJL8\u000b^1uK6\u000bg.Y4feB!\u0011Q\u000bB2\u0013\u0011\u0011)'a\u0016\u0003\u000bM#\u0018mZ3\u0002\u001dA\u0014xnY3tg\u000eC\u0017M\\4fgR\u0019qPa\u001b\t\u000f\t5\u0014\u00041\u0001\u0003\\\u00059Q.\u00198bO\u0016\u0014\u0018A\b9beRLG/[8o\u0013R,Wn\u001d\"z\u000bbL7\u000f^5oO\u0006sGMT3x)\u0019\u0011\u0019Ha\u001f\u0003\u0004B9QF!\u001e\u0003z\te\u0014b\u0001B<]\t1A+\u001e9mKJ\u0002b!!7\u0002d\u0006E\u0004BB\u0012\u001b\u0001\u0004\u0011i\b\u0005\u0003\u0002V\t}\u0014\u0002\u0002BA\u0003/\u0012\u0001\u0002R3mSZ,'/\u001f\u0005\b\u0005\u000bS\u0002\u0019\u0001BD\u00039IG/Z7JI>\u0013H+\u001b;mKN\u0004b!a\u0003\u0003\n\u0006%\u0011\u0002\u0002BF\u0003;\u00111aU3u\u000311\u0018\r\\5eCR,\u0017\n^3n)\u001dy(\u0011\u0013BJ\u0005/CaaI\u000eA\u0002\tu\u0004b\u0002BK7\u0001\u0007\u0011\u0011O\u0001\fiJ\f7m[3e\u0013R,W\u000eC\u0005\u0003\u001an\u0001\n\u00111\u0001\u0003\f\u0005ya/\u00197jI\u0006$X-T3nE\u0016\u00148/\u0001\fwC2LG-\u0019;f\u0013R,W\u000e\n3fM\u0006,H\u000e\u001e\u00134\u000391\u0018\r\\5eCR,W*Z7cKJ$2a BQ\u0011\u001d\u0011\u0019+\ba\u0001\u0003\u0013\t\u0011B]3mK\u0006\u001cX-\u00133\u0002\u0019Y\fG.\u001b3bi\u0016$\u0016m]6\u0015\u0007}\u0014I\u000bC\u0004\u0003,z\u0001\r!!\u0003\u0002\rQ\f7o[%eQ\r\u0001!q\u0016\t\u0005\u0005c\u00139,\u0004\u0002\u00034*\u0019!QW<\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003:\nM&aB*feZL7-\u001a")
public class DeliveryTrackingService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryTransitionHandler deliveryTransitionHandler;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryTrackingService deliveryTrackingService = this;
        synchronized (deliveryTrackingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Transition transition = delivery.getTransitionByIdOrTitle(transitionId);
        Stage stage = delivery.getStageByIdOrTitle(transition.getFromStageId());
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull(parameters.getTransitionItems(), (String)"Transition items");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parameters.getTransitionItems()).asScala()).foreach((Function1 & Serializable & scala.Serializable)itemId -> {
            DeliveryTrackingService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        ManualTransitionTrigger trigger = new ManualTransitionTrigger(delivery, stage, (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(parameters.getTransitionItems()).asScala()).toSet(), parameters.isCloseStages());
        this.deliveryTransitionHandler.handle(transition, trigger).foreach((Function1 & Serializable & scala.Serializable)manager -> {
            this.processChanges(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append((Object)subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq existingItems = (Seq)tuple2._1();
        Seq newItems = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        Seq existingItems2 = (Seq)tuple23._1();
        Seq newItems2 = (Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        delivery.addReleaseId(fromReleaseId);
        existingItems2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.addReleaseId(fromReleaseId)));
        newItems2.foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
            this.validateItem(delivery, (TrackedItem)((Object)item), false);
            return manager.addTrackedItem((TrackedItem)((Object)item));
        });
        this.processChanges(manager);
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        Seq existingItems = (Seq)((TraversableLike)items.distinct()).map((Function1 & Serializable & scala.Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)((Object)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).find((Function1 & Serializable & scala.Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            })));
        }, Seq$.MODULE$.canBuildFrom());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                manager.addReleaseToItem(x$5, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            DeliveryTrackingService.$anonfun$processChanges$1(this, x$6);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())), Buffer$.MODULE$.canBuildFrom()));
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), (Object)i), Buffer$.MODULE$.canBuildFrom()));
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Seq$.MODULE$.empty()), (Object)Seq$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Seq existingAcc = (Seq)tuple2._1();
            Seq newAcc = (Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable & scala.Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable & scala.Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable & scala.Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom()));
            }, (Function1 & Serializable & scala.Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom())), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem, boolean validateMembers) {
        block1: {
            LazyRef lowerCaseTitle$lzy = new LazyRef();
            Checks.checkNotNull((Object)((Object)trackedItem), (String)"Tracked item");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
            Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((!((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).exists((Function1 & Serializable & scala.Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
            if (trackedItem.getReleaseIds() == null) {
                trackedItem.setReleaseIds(new HashSet<String>());
            }
            if (!validateMembers) break block1;
            trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        }
    }

    private boolean validateItem$default$3() {
        return true;
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$1) {
        return x$1.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$1, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$1.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((TraversableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery$1.getStagesBefore(stage$1)).asScala()).$colon$plus((Object)stage$1, Buffer$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$manualCompleteTransition$3(itemId, x$1)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").append(new StringBuilder(53).append(" in stage '").append(((TraversableOnce)notDoneInStages.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTitle(), Buffer$.MODULE$.canBuildFrom())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryTrackingService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryTrackingService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryTrackingService $this, String x$6) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> x$6);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryTrackingService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryTrackingService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryTrackingService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService, DeliveryTransitionHandler deliveryTransitionHandler) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.deliveryTransitionHandler = deliveryTransitionHandler;
        Logging.$init$((Logging)this);
    }
}

