/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001\u0002\u000f\u001e\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!Y\u0005A!b\u0001\n\u0007a\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011Y\u0003!Q1A\u0005\u0004]C\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\ta\u0002\u0011)\u0019!C\u0001c\"A!\u0010\u0001B\u0001B\u0003%!\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!a%\u0001\t\u0003\n)\nC\u0004\u0002v\u0002!\t%a>\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\r\u0001\u0011\u0005#1\u0004\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqAa\u0013\u0001\t\u0003\u0012i\u0005C\u0004\u0003T\u0001!IA!\u0016\t\u000f\tm\u0003\u0001\"\u0003\u0003^\t)2+\u001d7EK2Lg/\u001a:z%\u0016\u0004xn]5u_JL(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\n!B]3q_NLGo\u001c:z\u0015\t\u00113%\u0001\u0005eK2Lg/\u001a:z\u0015\t!S%A\u0005yYJ,G.Z1tK*\u0011aeJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001K\u0001\u0004G>l7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\tq$\u0003\u00025?\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003M!W\r\\5wKJL\b+\u001a:tSN$XM\\2f!\t9$(D\u00019\u0015\tIT$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA\u001e9\u0005M!U\r\\5wKJL\b+\u001a:tSN$XM\\2f\u0003e!W\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0011\u0005]r\u0014BA 9\u0005e!U\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0002-Q\u0014\u0018mY6fI&#X-\u001c)feNL7\u000f^3oG\u0016\u0004\"a\u000e\"\n\u0005\rC$A\u0006+sC\u000e\\W\rZ%uK6\u0004VM]:jgR,gnY3\u0002)M\fHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s!\t1\u0015*D\u0001H\u0015\tq\u0002J\u0003\u0002!G%\u0011!j\u0012\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\tg\u0016\u001cWO]5us*\u0011!+J\u0001\tI\u0016\u0004Hn\\=ji&\u0011Ak\u0014\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\b%A\u0004eS\u0006dWm\u0019;\u0016\u0003a\u0003\"!\u00177\u000f\u0005iKgBA.h\u001d\taVM\u0004\u0002^I:\u0011al\u0019\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003C&\na\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\t17%\u0001\u0002eE&\u0011a\u0004\u001b\u0006\u0003M\u000eJ!A[6\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u001fQ&\u0011QN\u001c\u0002\b\t&\fG.Z2u\u0015\tQ7.\u0001\u0005eS\u0006dWm\u0019;!\u0003A!WmY8sCR|'oU3sm&\u001cW-F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0005j]R,'O\\1m\u0015\t98%A\u0002ba&L!!\u001f;\u0003A%sG/\u001a:oC2lU\r^1eCR\fG)Z2pe\u0006$xN]*feZL7-Z\u0001\u0012I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b~\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\f\u0011\u0005y\u0004Q\"A\u000f\t\u000bUZ\u0001\u0019\u0001\u001c\t\u000bqZ\u0001\u0019A\u001f\t\u000b\u0001[\u0001\u0019A!\t\u000b\u0011[\u0001\u0019A#\t\u000b-[\u00019A'\t\u000bY[\u00019\u0001-)\u0011\u0005%\u0011QBA\u0015\u0003W\u0001B!a\u0004\u0002&5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0006b]:|G/\u0019;j_:TA!a\u0006\u0002\u001a\u00059a-Y2u_JL(\u0002BA\u000e\u0003;\tQAY3b]NTA!a\b\u0002\"\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002$\u0005\u0019qN]4\n\t\u0005\u001d\u0012\u0011\u0003\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f#!!\f\u0002/ad'OU3q_NLGo\u001c:z'FdG)[1mK\u000e$\b\"\u00029\f\u0001\u0004\u0011\u0018\u0001\u0002:fC\u0012$B!!\u000e\u0002BA!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<\u0005\na\u0001Z8nC&t\u0017\u0002BA \u0003s\u0011\u0001\u0002R3mSZ,'/\u001f\u0005\b\u0003\u0007b\u0001\u0019AA#\u0003)!W\r\\5wKJL\u0018\n\u001a\t\u0005\u0003\u000f\nyE\u0004\u0003\u0002J\u0005-\u0003CA0.\u0013\r\ti%L\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055S\u0006K\u0002\r\u0003/\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;Z\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!\u0019\u0002\\\tQ\u0011j\u001d*fC\u0012|e\u000e\\=\u0002\u001d\u001d,GOQ=JI>\u0013H+\u001b;mKR!\u0011QGA4\u0011\u001d\tI'\u0004a\u0001\u0003\u000b\n\u0011\u0003Z3mSZ,'/_%e\u001fJ$\u0016\u000e\u001e7fQ\ri\u0011qK\u0001\u0007GJ,\u0017\r^3\u0015\t\u0005E\u0014q\u000f\t\u0004Y\u0005M\u0014bAA;[\t!QK\\5u\u0011\u0019\u0011c\u00021\u0001\u00026\u00051Q\u000f\u001d3bi\u0016$B!!\u001d\u0002~!1!e\u0004a\u0001\u0003k\ta!\u001a=jgR\u001cH\u0003BAB\u0003\u0013\u00032\u0001LAC\u0013\r\t9)\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0005\u0005a\u0001\u0003\u000bB3\u0001EA,\u0003\u0019!W\r\\3uKR!\u0011\u0011OAI\u0011\u001d\t\u0019%\u0005a\u0001\u0003\u000b\naa]3be\u000eDGCDAL\u0003S\u000bi,!3\u0002T\u0006u\u0017\u0011\u001d\t\u0007\u00033\u000b\u0019+!\u000e\u000f\t\u0005m\u0015q\u0014\b\u0004?\u0006u\u0015\"\u0001\u0018\n\u0007\u0005\u0005V&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0016q\u0015\u0002\u0004'\u0016\f(bAAQ[!9\u00111\u0016\nA\u0002\u00055\u0016a\u00024jYR,'o\u001d\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003\u00151wN]7t\u0015\r\t9L^\u0001\u0003mFJA!a/\u00022\n9\u0012IY:ue\u0006\u001cG\u000fR3mSZ,'/\u001f$jYR,'o\u001d\u0005\b\u0003\u007f\u0013\u0002\u0019AAa\u0003\u0011\u0001\u0018mZ3\u0011\t\u0005\r\u0017QY\u0007\u0002\u0011&\u0019\u0011q\u0019%\u0003\tA\u000bw-\u001a\u0005\b\u0003\u0017\u0014\u0002\u0019AAg\u0003\u001dy'\u000fZ3s\u0005f\u0004B!a,\u0002P&!\u0011\u0011[AY\u0005E!U\r\\5wKJLxJ\u001d3fe6{G-\u001a\u0005\b\u0003+\u0014\u0002\u0019AAl\u0003)\u0001(/\u001b8dSB\fGn\u001d\t\u0007\u00033\u000bI.!\u0012\n\t\u0005m\u0017q\u0015\u0002\t\u0013R,'/\u00192mK\"9\u0011q\u001c\nA\u0002\u0005]\u0017a\u0002:pY\u0016LEm\u001d\u0005\b\u0003G\u0014\u0002\u0019AAs\u0003A\tg._(g!\u0016\u0014X.[:tS>t7\u000f\u0005\u0004\u0002\u001a\u0006\r\u0016q\u001d\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q^(\u0002\u0015A,'/\\5tg&|g.\u0003\u0003\u0002r\u0006-(A\u0003)fe6L7o]5p]\"\u001a!#a\u0016\u0002\u0013M,\u0017M]2i\u0013\u0012\u001cH\u0003BA}\u0003w\u0004b!!'\u0002$\u0006\u0015\u0003bBAV'\u0001\u0007\u0011Q\u0016\u0015\u0004'\u0005]\u0013A\t4j]\u0012$U\r\\5wKJLWm\u001d*fM\u0016\u0014XM\\2j]\u001e\u0014V\r\\3bg\u0016LE\r\u0006\u0003\u0002z\n\r\u0001b\u0002B\u0003)\u0001\u0007\u0011QI\u0001\ne\u0016dW-Y:f\u0013\u0012\fqEZ5oI\u0006\u001bG/\u001b<f\t\u0016d\u0017N^3sS\u0016\u001c(+\u001a4fe\u0016t7-\u001b8h\r>dG-\u001a:JIR!!1\u0002B\n!\u0019\tI*a)\u0003\u000eA\u0019qGa\u0004\n\u0007\tE\u0001HA\u0007DS&#w+\u001b;i)&$H.\u001a\u0005\b\u0005+)\u0002\u0019AA#\u0003!1w\u000e\u001c3fe&#\u0007fA\u000b\u0002X\u0005Ab-\u001b8e%\u0016dW-Y:fg\nKH)\u001a7jm\u0016\u0014\u00180\u00133\u0015\t\tu!1\u0006\t\u0007\u00033\u000b\u0019Ka\b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQAA!\n\u00026\u0006)a/[3xg&!!\u0011\u0006B\u0012\u0005]!U\r\\5wKJLh\t\\8x%\u0016dW-Y:f\u0013:4w\u000eC\u0004\u0002DY\u0001\r!!\u0012)\u0007Y\t9&\u0001\u0007u_\u0012+G.\u001b<fe&,7\u000f\u0006\u0003\u0002\u0018\nM\u0002b\u0002B\u001b/\u0001\u0007!qG\u0001\u0005e><8\u000f\u0005\u0004\u0002\u001a\u0006\r&\u0011\b\t\u0004o\tm\u0012b\u0001B\u001fq\tYA)\u001a7jm\u0016\u0014\u0018PU8x\u0003)!x\u000eR3mSZ,'/\u001f\u000b\u0007\u0003k\u0011\u0019Ea\u0012\t\u000f\t\u0015\u0003\u00041\u0001\u0003:\u0005\u0019!o\\<\t\u000f\t%\u0003\u00041\u0001\u0002z\u0006ia.Z<SK2,\u0017m]3JIN\fABZ5oI\u001a{G\u000eZ3s\u0013\u0012$B!!\u0012\u0003P!9\u00111I\rA\u0002\u0005\u0015\u0003fA\r\u0002X\u0005qC-Z2pe\u0006$XmV5uQ\u00163g-Z2uSZ,7+Z2ve&$\u00180\u00118e!\u0006$H/\u001a:o\t\u0016$\u0018-\u001b7t)\u0011\t9Ja\u0016\t\u000f\te#\u00041\u0001\u0002\u0018\u0006QA-\u001a7jm\u0016\u0014\u0018.Z:\u0002\u001b5\f\u0007\u000fV8EK2Lg/\u001a:z)\u0011\u0011yF!\u001a\u0011\u000b1\u0012\t'!\u000e\n\u0007\t\rTF\u0001\u0004PaRLwN\u001c\u0005\b\u0005OZ\u0002\u0019\u0001B5\u00039!W\r\\5wKJL(k\\<PaR\u0004R\u0001\fB1\u0005sA3\u0001\u0001B7!\u0011\u0011yG!\u001e\u000e\u0005\tE$\u0002\u0002B:\u0003;\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119H!\u001d\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0005w\u0002B!!\u0017\u0003~%!!qPA.\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)((Object)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable & scala.Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMapping((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(originalDelivery.getTrackedItems()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        itemDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaSetConverter(originalDelivery.getReleaseIds()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, Seq<Permission> anyOfPermissions) {
        Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).withPermissions((Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (Seq)Seq$.MODULE$.empty() : anyOfPermissions), principals, roleIds).withOriginPatternId(filters.getOriginPatternId()).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<DeliveryRow>)Seq$.MODULE$.empty();
        }
        Seq<DeliveryRow> deliveryRows = seq;
        Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).build();
        return (Seq)this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.deliveryId(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable & scala.Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Delivery> toDeliveries(Seq<DeliveryRow> rows) {
        Map<Object, Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, (Seq<String>)((Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))), Seq$.MODULE$.canBuildFrom());
    }

    private Delivery toDelivery(DeliveryRow row, Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)((Object)some.value());
        delivery.setFolderId(FolderId$.MODULE$.absolute$extension(row.folderId()));
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), Set$.MODULE$.canBuildFrom());
        delivery.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return FolderId$.MODULE$.absolute$extension(this.deliveryPersistence.findFolderId(deliveryId));
    }

    private Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(Seq<Delivery> deliveries) {
        return (Seq)deliveries.map((Function1 & Serializable & scala.Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS()}))).asJava(), DecoratorsCache$.MODULE$.NO_CACHE());
            return delivery;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)delivery -> (Delivery)((Object)((Object)this.decorateWithEffectiveSecurityAndPatternDetails((Seq<Delivery>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Delivery[]{delivery})))).head())));
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

