/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.activity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum DeliveryActivity implements ActivityOps
{
    PATTERN_CREATED("Created Pattern '%s'", ActivityCategory.LIFECYCLE),
    PATTERN_UPDATED("Updated Pattern '%s'", ActivityCategory.DELIVERY_EDIT),
    PATTERN_DELETED("Deleted Pattern '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_CREATED("Created Delivery '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_UPDATED("Updated Delivery '%s'", ActivityCategory.DELIVERY_EDIT),
    DELIVERY_DELETED("Deleted Delivery '%s'", ActivityCategory.LIFECYCLE),
    DELIVERY_COMPLETED("Completed Delivery '%s'", ActivityCategory.LIFECYCLE),
    STAGE_CREATED("Created Stage '%s'", ActivityCategory.DELIVERY_EDIT),
    STAGE_UPDATED("Updated Stage '%s'", ActivityCategory.DELIVERY_EDIT),
    STAGE_REMOVED("Removed Stage '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    STAGE_REOPENED("Reopened Stage '%s'", ActivityCategory.LIFECYCLE),
    STAGE_STARTED("Started Stage '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    STAGE_COMPLETED("Completed Stage '%s'", ActivityCategory.LIFECYCLE),
    ITEM_CREATED("Created Tracked Item '%s'", ActivityCategory.DELIVERY_EDIT),
    ITEM_RENAMED("Renamed Tracked Item '%s' to '%s'", ActivityCategory.DELIVERY_EDIT),
    ITEM_REMOVED("Removed Tracked Item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_DESCOPED("Descoped Tracked Item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_RESCOPED("Rescoped Tracked Item '%s'", ActivityCategory.DELIVERY_EDIT, ActivityCategory.IMPORTANT),
    ITEM_AVAILABLE("Added Tracked Item '%s' to Stage '%s'", ActivityCategory.LIFECYCLE),
    ITEM_COMPLETED("Completed Tracked Item '%s' in Stage '%s' from release '%s'", ActivityCategory.LIFECYCLE),
    ITEM_COMPLETED_MANUALLY("Completed Tracked Item '%s' in Stage '%s' manually", ActivityCategory.LIFECYCLE),
    ITEM_SKIPPED("Skipped Tracked Item '%s' in stage '%s'", ActivityCategory.LIFECYCLE),
    ITEM_TRANSITION_APPROVED("Approved Transition '%s' for Tracked Item '%s' in Stage '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TRANSITION_CREATED("Created Transition '%s'", ActivityCategory.DELIVERY_EDIT),
    TRANSITION_UPDATED("Updated Transition '%s'", ActivityCategory.DELIVERY_EDIT),
    TRANSITION_REMOVED("Removed Transition '%s'", ActivityCategory.DELIVERY_EDIT),
    OTHER("", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories;
    private static final Map<String, DeliveryActivity> BY_NAME;

    private DeliveryActivity(String message, ActivityCategory ... categories) {
        this.message = message;
        LinkedHashSet myCategories = Sets.newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Date eventTime, String username, Type targetType, String targetId, Object ... parameters) {
        return this.create(eventTime, this.name(), username, targetType, targetId, this.message, parameters);
    }

    public ActivityLogEntry create(DeliveryEvent ev, BaseConfigurationItem target, Object ... parameters) {
        return this.create(ev.timestamp(), ev.username(), target.getType(), target.getId(), parameters);
    }

    public Set<ActivityCategory> getCategories() {
        return this.categories;
    }

    public static DeliveryActivity safeValueOf(String name) {
        DeliveryActivity activity = BY_NAME.get(name);
        return activity == null ? OTHER : activity;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeliveryActivity value : DeliveryActivity.values()) {
            builder.put((Object)value.name(), (Object)value);
        }
        BY_NAME = builder.build();
    }
}

