/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.events.handler;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatusChangeSubscriber;
import com.xebialabs.xlrelease.delivery.events.ItemAvailable;
import com.xebialabs.xlrelease.delivery.events.ItemCompleted;
import com.xebialabs.xlrelease.delivery.events.ItemDescoped;
import com.xebialabs.xlrelease.delivery.events.ItemRemoved;
import com.xebialabs.xlrelease.delivery.events.ItemSkipped;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)q\u0006\u0001C\u0001a!)A\t\u0001C\u0001\u000b\")Q\u000b\u0001C\u0001-\")A\f\u0001C\u0001;\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\")\u0011\u000f\u0001C\u0005e\"I\u00111\t\u0001\u0012\u0002\u0013%\u0011Q\t\u0005\n\u00033\u0002\u0011\u0013!C\u0005\u00037\u0012!\u0005\u0016:bG.,G-\u0013;f[N#\u0018\r^;t'V\u00147o\u0019:jE\u0016\u0014\b*\u00198eY\u0016\u0014(B\u0001\b\u0010\u0003\u001dA\u0017M\u001c3mKJT!\u0001E\t\u0002\r\u00154XM\u001c;t\u0015\t\u00112#\u0001\u0005eK2Lg/\u001a:z\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0014\u0003\u0019\t7\r^8sg&\u0011q\u0005\n\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\tQS&D\u0001,\u0015\ta3#\u0001\u0006sKB|7/\u001b;pefL!AL\u0016\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"2!M\u001a5!\t\u0011\u0004!D\u0001\u000e\u0011\u0015\t3\u00011\u0001#\u0011\u0015A3\u00011\u0001*Q\t\u0019a\u0007\u0005\u00028\u00056\t\u0001H\u0003\u0002:u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005mb\u0014a\u00024bGR|'/\u001f\u0006\u0003{y\nQAY3b]NT!a\u0010!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Q\u0001\u0004_J<\u0017BA\"9\u0005%\tU\u000f^8xSJ,G-A\bp]&#X-\\\"p[BdW\r^3e)\t1\u0015\n\u0005\u0002\u001d\u000f&\u0011\u0001*\b\u0002\u0005+:LG\u000fC\u0003K\t\u0001\u00071*A\u0003fm\u0016tG\u000f\u0005\u0002M\u001b6\tq\"\u0003\u0002O\u001f\ti\u0011\n^3n\u0007>l\u0007\u000f\\3uK\u0012D#\u0001\u0002)\u0011\u0005E\u001bV\"\u0001*\u000b\u0005A\u0019\u0012B\u0001+S\u0005%\u0019VOY:de&\u0014W-A\bp]&#X-\\!wC&d\u0017M\u00197f)\t1u\u000bC\u0003K\u000b\u0001\u0007\u0001\f\u0005\u0002M3&\u0011!l\u0004\u0002\u000e\u0013R,W.\u0011<bS2\f'\r\\3)\u0005\u0015\u0001\u0016!D8o\u0013R,WnU6jaB,G\r\u0006\u0002G=\")!J\u0002a\u0001?B\u0011A\nY\u0005\u0003C>\u00111\"\u0013;f[N[\u0017\u000e\u001d9fI\"\u0012a\u0001U\u0001\u000f_:LE/Z7EKN\u001cw\u000e]3e)\t1U\rC\u0003K\u000f\u0001\u0007a\r\u0005\u0002MO&\u0011\u0001n\u0004\u0002\r\u0013R,W\u000eR3tG>\u0004X\r\u001a\u0015\u0003\u000fA\u000bQb\u001c8Ji\u0016l'+Z7pm\u0016$GC\u0001$m\u0011\u0015Q\u0005\u00021\u0001n!\tae.\u0003\u0002p\u001f\tY\u0011\n^3n%\u0016lwN^3eQ\tA\u0001+\u0001\rhKR\f5\r^5wK&#X-\\*vEN\u001c'/\u001b2feN$\u0012b]A\u0006\u00033\ti#a\u000e\u0011\u0007QdxP\u0004\u0002vu:\u0011a/_\u0007\u0002o*\u0011\u00010G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!a_\u000f\u0002\u000fA\f7m[1hK&\u0011QP \u0002\u0004'\u0016\f(BA>\u001e!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003W\u0005)\u0011/^3ss&!\u0011\u0011BA\u0002\u00055!\u0016m]6CCNL7\rR1uC\"1!#\u0003a\u0001\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\t\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002\u0018\u0005E!\u0001\u0003#fY&4XM]=\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u00051\u0011\u000e^3n\u0013\u0012\u0004B!a\b\u0002(9!\u0011\u0011EA\u0012!\t1X$C\u0002\u0002&u\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013;!I\u0011qF\u0005\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\bgR\fw-Z%e!\u0015a\u00121GA\u000f\u0013\r\t)$\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005e\u0012\u0002%AA\u0002\u0005m\u0012AB:uCR,8\u000fE\u0003\u001d\u0003g\ti\u0004\u0005\u0003\u0002\u0010\u0005}\u0012\u0002BA!\u0003#\u0011\u0011\u0003\u0016:bG.,G-\u0013;f[N#\u0018\r^;t\u0003\t:W\r^!di&4X-\u0013;f[N+(m]2sS\n,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\t\u0016\u0005\u0003c\tIe\u000b\u0002\u0002LA!\u0011QJA+\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!C;oG\",7m[3e\u0015\tIT$\u0003\u0003\u0002X\u0005=#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011s-\u001a;BGRLg/Z%uK6\u001cVOY:de&\u0014WM]:%I\u00164\u0017-\u001e7uIQ*\"!!\u0018+\t\u0005m\u0012\u0011\n\u0015\u0004\u0001\u0005\u0005\u0004cA)\u0002d%\u0019\u0011Q\r*\u0003\u001b\u00153XM\u001c;MSN$XM\\3sQ\r\u0001\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e \u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002t\u00055$!C\"p[B|g.\u001a8u\u0001")
public class TrackedItemStatusSubscriberHandler {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;

    @Subscribe
    public void onItemCompleted(ItemCompleted event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.READY)).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), new StringBuilder(43).append("All tracked items are completed in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemAvailable(ItemAvailable event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), (Option<TrackedItemStatus>)new Some((Object)TrackedItemStatus.NOT_READY)).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.taskId(), new StringBuilder(43).append("All tracked items are available in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemSkipped(ItemSkipped event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), (Option<String>)new Some((Object)event.stage().getId()), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(64).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was skipped in stage '").append(event.stage().getTitle()).append("'").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemDescoped(ItemDescoped event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(53).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was descoped").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onItemRemoved(ItemRemoved event) {
        this.getActiveItemSubscribers(event.delivery(), event.item().getId(), this.getActiveItemSubscribers$default$3(), this.getActiveItemSubscribers$default$4()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.releaseActorService.failTask(task.taskId(), new StringBuilder(52).append("Unable to complete task, tracked item '").append(event.item().getTitle()).append("' was removed").toString(), User.SYSTEM);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<TaskBasicData> getActiveItemSubscribers(Delivery delivery, String itemId, Option<String> stageId, Option<TrackedItemStatus> status) {
        Buffer taskIds = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getSubscribersOfType(TrackedItemStatusChangeSubscriber.class)).asScala()).collect((PartialFunction)new scala.Serializable(null, delivery, itemId, stageId, status){
            public static final long serialVersionUID = 0L;
            private final Delivery delivery$1;
            private final String itemId$1;
            private final Option stageId$1;
            private final Option status$1;

            public final <A1 extends TrackedItemStatusChangeSubscriber, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.matches(this.delivery$1, this.itemId$1, (Option<String>)this.stageId$1, (Option<TrackedItemStatus>)this.status$1) ? A1.sourceId() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(TrackedItemStatusChangeSubscriber x1) {
                TrackedItemStatusChangeSubscriber trackedItemStatusChangeSubscriber = x1;
                boolean bl = trackedItemStatusChangeSubscriber.matches(this.delivery$1, this.itemId$1, (Option<String>)this.stageId$1, (Option<TrackedItemStatus>)this.status$1);
                return bl;
            }
            {
                this.delivery$1 = delivery$1;
                this.itemId$1 = itemId$1;
                this.stageId$1 = stageId$1;
                this.status$1 = status$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct();
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.taskRepository.findTasksBasicData((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(taskIds).asJava())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TrackedItemStatusSubscriberHandler.$anonfun$getActiveItemSubscribers$1(x$2)));
    }

    private Option<String> getActiveItemSubscribers$default$3() {
        return None$.MODULE$;
    }

    private Option<TrackedItemStatus> getActiveItemSubscribers$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getActiveItemSubscribers$1(TaskBasicData x$2) {
        TaskStatus taskStatus = x$2.status();
        TaskStatus taskStatus2 = TaskStatus.IN_PROGRESS;
        return !(taskStatus != null ? !taskStatus.equals(taskStatus2) : taskStatus2 != null);
    }

    @Autowired
    public TrackedItemStatusSubscriberHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
    }
}

