/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreated;
import com.xebialabs.xlrelease.delivery.events.StageRemoved;
import com.xebialabs.xlrelease.delivery.events.StageUpdated;
import com.xebialabs.xlrelease.delivery.events.TransitionCreated;
import com.xebialabs.xlrelease.delivery.events.TransitionRemoved;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdated;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\r%c\u0001\u0002\u00180\u0001iB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005n\u0001\t\u0015\r\u0011\"\u0001o\u0011!\u0011\bA!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011u\u0004!\u0011!Q\u0001\nUD\u0001B \u0001\u0003\u0006\u0004%\ta \u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!a#\u0001\t\u0003\ti\tC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!!@\u0001\t\u0003\ty\u0010C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!1\u000b\u0001\u0005\u0002\tU\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005S\u0002A\u0011\u0001B6\u0011\u001d\u0011I\b\u0001C\u0001\u0005wBqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\u0010\u0002!\tA!%\t\u000f\tm\u0005\u0001\"\u0003\u0003\u001e\"9!\u0011\u0015\u0001\u0005\n\t\r\u0006b\u0002BT\u0001\u0011%!\u0011\u0016\u0005\n\u0005\u000b\u0004\u0011\u0013!C\u0005\u0005\u000fDqAa7\u0001\t\u0013\u0011i\u000eC\u0004\u0003d\u0002!IA!:\t\u000f\t%\b\u0001\"\u0003\u0003l\"I!1\u001f\u0001\u0012\u0002\u0013%!Q\u001f\u0005\b\u0005s\u0004A\u0011\u0002B~\u0011\u001d\u0019y\u0003\u0001C)\u0007c\u0011a\u0003R3mSZ,'/\u001f)biR,'O\\*feZL7-\u001a\u0006\u0003aE\nqa]3sm&\u001cWM\u0003\u00023g\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u00025k\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003m]\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003a\n1aY8n\u0007\u0001\u00192\u0001A\u001eB!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!iQ\u0007\u0002_%\u0011Ai\f\u0002\u0015\t\u0016d\u0017N^3ssN+'O^5dKV#\u0018\u000e\\:\u0002%\u0011,G.\u001b<fef\u0014V\r]8tSR|'/_\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*M\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001'J\u0005I!U\r\\5wKJL(+\u001a9pg&$xN]=\u0002'\u0011,G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001Q!\t\t6+D\u0001S\u0015\tQ5'\u0003\u0002U%\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f+\u0005A\u0006CA-\\\u001b\u0005Q&B\u0001\u00194\u0013\ta&L\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001fI,G.Z1tKN+'O^5dK\u0002\n1bY5JIN+'O^5dKV\t\u0001\r\u0005\u0002ZC&\u0011!M\u0017\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002jg\u0005\u0011AMY\u0005\u0003W\"\u0014\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%A\u0007g_2$WM]*feZL7-Z\u000b\u0002_B\u0011\u0011\f]\u0005\u0003cj\u0013QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017A\u00044pY\u0012,'oU3sm&\u001cW\rI\u0001\fe>dWmU3sm&\u001cW-F\u0001v!\t180D\u0001x\u0015\tA\u00180\u0001\u0005tK\u000e,(/\u001b;z\u0015\tQX'\u0001\u0005eKBdw._5u\u0013\taxOA\u0006S_2,7+\u001a:wS\u000e,\u0017\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d1'\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003\u0017\t)AA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)I\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005\t\u0003\u0001\"B#\u0012\u0001\u00049\u0005\"\u0002(\u0012\u0001\u0004\u0001\u0006\"\u0002,\u0012\u0001\u0004A\u0006\"\u00020\u0012\u0001\u0004\u0001\u0007\"\u00023\u0012\u0001\u00041\u0007\"B7\u0012\u0001\u0004y\u0007\"B:\u0012\u0001\u0004)\bB\u0002@\u0012\u0001\u0004\t\t\u0001K\u0002\u0012\u0003O\u0001B!!\u000b\u0002@5\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0006b]:|G/\u0019;j_:TA!!\r\u00024\u00059a-Y2u_JL(\u0002BA\u001b\u0003o\tQAY3b]NTA!!\u000f\u0002<\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002>\u0005\u0019qN]4\n\t\u0005\u0005\u00131\u0006\u0002\n\u0003V$xn^5sK\u0012\f!bZ3u!\u0006$H/\u001a:o)\u0011\t9%a\u0015\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u00142\u0003\u0019!w.\\1j]&!\u0011\u0011KA&\u0005!!U\r\\5wKJL\bbBA+%\u0001\u0007\u0011qK\u0001\na\u0006$H/\u001a:o\u0013\u0012\u0004B!!\u0017\u0002h9!\u00111LA2!\r\ti&P\u0007\u0003\u0003?R1!!\u0019:\u0003\u0019a$o\\8u}%\u0019\u0011QM\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'\u0010\u0015\u0004%\u0005=\u0004\u0003BA9\u0003{j!!a\u001d\u000b\t\u00055\u0012Q\u000f\u0006\u0005\u0003o\nI(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005mt'\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ty(a\u001d\u0003\u000bQKW.\u001a3\u0002+\u001d,G\u000fU1ui\u0016\u0014hNQ=JI>\u0013H+\u001b;mKR!\u0011qIAC\u0011\u001d\t9i\u0005a\u0001\u0003/\n\u0001\u0003]1ui\u0016\u0014h.\u00133PeRKG\u000f\\3)\u0007M\ty'\u0001\ffq&\u001cHo\u001d)biR,'O\\,ji\"$\u0016\u000e\u001e7f)\u0019\ty)!&\u0002\u001aB\u0019A(!%\n\u0007\u0005MUHA\u0004C_>dW-\u00198\t\u000f\u0005]E\u00031\u0001\u0002X\u0005\u0011\u0011\u000e\u001a\u0005\b\u00037#\u0002\u0019AA,\u0003\u0015!\u0018\u000e\u001e7fQ\r!\u0012qN\u0001\u000eKbL7\u000f^:QCR$XM\u001d8\u0015\t\u0005=\u00151\u0015\u0005\b\u0003K+\u0002\u0019AA,\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004+\u0005=\u0014!F2sK\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003\u000f\ni\u000bC\u0004\u00020Z\u0001\r!a\u0012\u0002\u000fA\fG\u000f^3s]\"\u001aa#a\u001c\u0002+U\u0004H-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R!\u0011qIA\\\u0011\u001d\tIl\u0006a\u0001\u0003\u000f\nq!\u001e9eCR,G\rK\u0002\u0018\u0003_\nQ\u0003Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002B\u0006\u001d\u0007c\u0001\u001f\u0002D&\u0019\u0011QY\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+B\u0002\u0019AA,Q\rA\u0012qN\u0001\u0019IV\u0004H.[2bi\u0016$U\r\\5wKJL\b+\u0019;uKJtGCBA$\u0003\u001f\f\t\u000eC\u0004\u0002Ve\u0001\r!a\u0016\t\u000f\u0005M\u0017\u00041\u0001\u0002V\u00061\u0001/\u0019:b[N\u0004B!a6\u0002f6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.A\u0003g_Jl7O\u0003\u0003\u0002`\u0006\u0005\u0018A\u0001<2\u0015\r\t\u0019oM\u0001\u0004CBL\u0017\u0002BAt\u00033\u0014\u0001\u0004R;qY&\u001c\u0017\r^3EK2Lg/\u001a:z!\u0006$H/\u001a:oQ\rI\u0012qN\u0001\u001aGJ,\u0017\r^3EK2Lg/\u001a:z\rJ|W\u000eU1ui\u0016\u0014h\u000e\u0006\u0004\u0002H\u0005=\u0018\u0011\u001f\u0005\b\u0003+R\u0002\u0019AA,\u0011\u001d\t\u0019P\u0007a\u0001\u0003k\f!\u0002]1sC6,G/\u001a:t!\u0011\t9.a>\n\t\u0005e\u0018\u0011\u001c\u0002\u000f\u0007J,\u0017\r^3EK2Lg/\u001a:zQ\rQ\u0012qN\u0001\u000fg\u0016\f'o\u00195QCR$XM\u001d8t)\u0019\u0011\tA!\u0005\u0003\u001cA1!1\u0001B\u0007\u0003\u000fj!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\u0005kRLGN\u0003\u0002\u0003\f\u0005!!.\u0019<b\u0013\u0011\u0011yA!\u0002\u0003\t1K7\u000f\u001e\u0005\b\u0005'Y\u0002\u0019\u0001B\u000b\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!a6\u0003\u0018%!!\u0011DAm\u0005Y!U\r\\5wKJL\b+\u0019;uKJtg)\u001b7uKJ\u001c\bb\u0002B\u000f7\u0001\u0007!qD\u0001\u0005a\u0006<W\rE\u0002R\u0005CI1Aa\tS\u0005\u0011\u0001\u0016mZ3)\u0007m\ty'A\u0005hKR\u001cF/Y4fgR!!1\u0006B\u001a!\u0019\u0011\u0019A!\u0004\u0003.A!\u0011\u0011\nB\u0018\u0013\u0011\u0011\t$a\u0013\u0003\u000bM#\u0018mZ3\t\u000f\u0005UC\u00041\u0001\u0002X!\u001aA$a\u001c\u0002\u0011\u0005$Gm\u0015;bO\u0016$\u0002B!\f\u0003<\tu\"\u0011\t\u0005\b\u0003+j\u0002\u0019AA,\u0011\u001d\u0011y$\ba\u0001\u0005[\tQa\u001d;bO\u0016DqAa\u0011\u001e\u0001\u0004\u0011)%\u0001\tpaRLwN\\1m!>\u001c\u0018\u000e^5p]B)AHa\u0012\u0003L%\u0019!\u0011J\u001f\u0003\r=\u0003H/[8o!\ra$QJ\u0005\u0004\u0005\u001fj$aA%oi\"\u001aQ$a\u001c\u0002\u0017U\u0004H-\u0019;f'R\fw-\u001a\u000b\u0007\u0005[\u00119F!\u0017\t\u000f\u0005Uc\u00041\u0001\u0002X!9\u0011\u0011\u0018\u0010A\u0002\t5\u0002f\u0001\u0010\u0002p\u0005YA-\u001a7fi\u0016\u001cF/Y4f)\u0019\t\tM!\u0019\u0003d!9\u0011QK\u0010A\u0002\u0005]\u0003b\u0002B3?\u0001\u0007\u0011qK\u0001\bgR\fw-Z%eQ\ry\u0012qN\u0001\u000fO\u0016$HK]1og&$\u0018n\u001c8t)\u0011\u0011iG!\u001e\u0011\r\t\r!Q\u0002B8!\u0011\tIE!\u001d\n\t\tM\u00141\n\u0002\u000b)J\fgn]5uS>t\u0007bBA+A\u0001\u0007\u0011q\u000b\u0015\u0004A\u0005=\u0014!D1eIR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0003p\tu$q\u0010\u0005\b\u0003+\n\u0003\u0019AA,\u0011\u001d\u0011\t)\ta\u0001\u0005_\n!\u0002\u001e:b]NLG/[8oQ\r\t\u0013qN\u0001\u0011kB$\u0017\r^3Ue\u0006t7/\u001b;j_:$bAa\u001c\u0003\n\n-\u0005bBA+E\u0001\u0007\u0011q\u000b\u0005\b\u0003s\u0013\u0003\u0019\u0001B8Q\r\u0011\u0013qN\u0001\u0011I\u0016dW\r^3Ue\u0006t7/\u001b;j_:$b!!1\u0003\u0014\nU\u0005bBA+G\u0001\u0007\u0011q\u000b\u0005\b\u0005/\u001b\u0003\u0019AA,\u00031!(/\u00198tSRLwN\\%eQ\r\u0019\u0013qN\u0001\u0010m\u0006d\u0017\u000eZ1uKB\u000bG\u000f^3s]R!\u0011\u0011\u0019BP\u0011\u0019\u0011D\u00051\u0001\u0002H\u0005q1\r[3dW&\u001b\b+\u0019;uKJtG\u0003BAa\u0005KCaAM\u0013A\u0002\u0005\u001d\u0013!\u0004<bY&$\u0017\r^3Ti\u0006<W\r\u0006\u0005\u0002B\n-&Q\u0016Bb\u0011\u001d\u0011yD\na\u0001\u0005[AqAa,'\u0001\u0004\u0011\t,\u0001\u0004ti\u0006<Wm\u001d\t\u0007\u0005g\u0013iL!\f\u000f\t\tU&\u0011\u0018\b\u0005\u0003;\u00129,C\u0001?\u0013\r\u0011Y,P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yL!1\u0003\u0007M+\u0017OC\u0002\u0003<vB\u0011Ba\u0011'!\u0003\u0005\rA!\u0012\u0002/Y\fG.\u001b3bi\u0016\u001cF/Y4fI\u0011,g-Y;mi\u0012\u001aTC\u0001BeU\u0011\u0011)Ea3,\u0005\t5\u0007\u0003\u0002Bh\u0005/l!A!5\u000b\t\tM'Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f>\u0013\u0011\u0011IN!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nwC2LG-\u0019;f)J\fgn]5uS>tGCBAa\u0005?\u0014\t\u000fC\u0004\u00020\"\u0002\r!a\u0012\t\u000f\t\u0005\u0005\u00061\u0001\u0003p\u0005i!/Z:fi\u0012+G.\u001b<fef$B!!1\u0003h\"1!'\u000ba\u0001\u0003\u000f\nA#\u00197sK\u0006$\u00170\u0012=jgR\u001c()\u001f+ji2,GCBAH\u0005[\u0014\t\u0010C\u0004\u0003p*\u0002\r!a\u0016\u0002\u0019A\fG\u000f^3s]RKG\u000f\\3\t\u0013\u0005U#\u0006%AA\u0002\u0005]\u0013AH1me\u0016\fG-_#ySN$8OQ=USRdW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119P\u000b\u0003\u0002X\t-\u0017AC4f]\u0016\u0014\u0018\r^3JIR1\u0011q\u000bB\u007f\u0007WAqAa@-\u0001\u0004\u0019\t!A\u0004dS\u000ec\u0017m]:1\t\r\r1Q\u0002\t\u0007\u00033\u001a)a!\u0003\n\t\r\u001d\u00111\u000e\u0002\u0006\u00072\f7o\u001d\t\u0005\u0007\u0017\u0019i\u0001\u0004\u0001\u0005\u0019\r=!Q`A\u0001\u0002\u0003\u0015\ta!\u0005\u0003\u0007}#\u0013'\u0005\u0003\u0004\u0014\re\u0001c\u0001\u001f\u0004\u0016%\u00191qC\u001f\u0003\u000f9{G\u000f[5oOB!11DB\u0014\u001b\t\u0019iB\u0003\u0003\u0004 \r\u0005\u0012aA;e[*!\u00111]B\u0012\u0015\r\u0019)#_\u0001\u0007a2,x-\u001b8\n\t\r%2Q\u0004\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007bBB\u0017Y\u0001\u0007\u0011qK\u0001\ta\u0006\u0014XM\u001c;JI\u0006\u00012\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u000b\u0007\u0003\u0003\u001c\u0019da\u000e\t\u000f\rUR\u00061\u0001\u0002H\u0005\u0001R\r_5ti&tw\rR3mSZ,'/\u001f\u0005\n\u0007si\u0003\u0013!a\u0001\u0003/\na!Y2uS>t\u0007f\u0001\u0001\u0004>A!1qHB#\u001b\t\u0019\tE\u0003\u0003\u0004D\u0005]\u0012AC:uKJ,w\u000e^=qK&!1qIB!\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetDelivery(pattern);
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.generateId(Stage.class, pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetDelivery(pattern);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            int counter = 100;
            do {
                pattern.setTitle(new StringBuilder(7).append(pattern.getTitle()).append(" (Copy)").toString());
            } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && --counter > 0);
        }
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetDelivery(delivery);
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(delivery);
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Option<Object> optionalPosition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.validateStage(stage, (Seq<Stage>)stages, optionalPosition);
        stage.setId(this.generateId(Stage.class, pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        int position = BoxesRunTime.unboxToInt((Object)optionalPosition.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> stages.size()));
        pattern.addStage(stage, position);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreated(stage, pattern));
        return stage;
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStage(updated, (Seq<Stage>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()), this.validateStage$default$3());
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdated(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Function1 & Serializable & scala.Serializable removeTransition = (Function1 & Serializable & scala.Serializable)stage -> {
            stage.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                DeliveryPatternService.$anonfun$deleteStage$3(pattern$2, x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Stage stage2 = pattern.getStageByIdOrTitle(stageId);
        removeTransition.apply((Object)new Some((Object)stage2));
        Object object = pattern.isLastStage(stage2) ? removeTransition.apply((Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern.findPreviousStage(stage2)))) : BoxedUnit.UNIT;
        pattern.removeStage(stage2);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemoved(stage2, pattern));
    }

    @Timed
    public List<Transition> getTransitions(String patternId) {
        return this.getPattern(patternId).getTransitions();
    }

    @Timed
    public Transition addTransition(String patternId, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, transition);
        transition.setId(this.generateId(Transition.class, pattern.getId()));
        pattern.addTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreated(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, updated);
        Transition original = pattern.getTransitionByIdOrTitle(updated.getId());
        pattern.removeTransition(original);
        pattern.addTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdated(updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.removeTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemoved(transition, pattern));
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validateStage(Stage stage, Seq<Stage> stages, Option<Object> optionalPosition) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        if (optionalPosition.isDefined()) {
            int position = BoxesRunTime.unboxToInt((Object)optionalPosition.get());
            Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        }
        Checks.checkArgument((stages.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateStage$1(stage, x$2))) == 0 ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private Option<Object> validateStage$default$3() {
        return None$.MODULE$;
    }

    private void validateTransition(Delivery pattern, Transition transition) {
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkNotNull((Object)transition.getFromStageId(), (String)"fromStageId");
        Optional<Stage> stage = pattern.findStageByIdOrTitle(transition.getFromStageId());
        Checks.checkArgument((boolean)stage.isPresent(), (String)"From stage '%s' not found in release delivery '%s'", (Object[])new Object[]{transition.getFromStageId(), pattern.getTitle()});
        Optional<Transition> maybeExistingTransition = pattern.findTransitionFrom(stage.get());
        maybeExistingTransition.ifPresent(existingTransition -> {
            String string = existingTransition.getId();
            String string2 = transition.getId();
            Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"There is already a transition named '%s' associated with stage '%s'", (Object[])new Object[]{existingTransition.getTitle(), ((Stage)((Object)((Object)stage.get()))).getTitle()});
        });
        Checks.checkArgument((!pattern.isLastStage(stage.get()) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        transition.validate(pattern);
    }

    private void resetDelivery(Delivery delivery) {
        Date resetDate = new Date();
        String oldDeliveryId = delivery.getId();
        String newDeliveryId = this.generateId(Delivery.class, "Deliveries");
        delivery.setId(newDeliveryId);
        delivery.getTransitions().forEach(transition -> transition.setId(transition.getId().replace(oldDeliveryId, newDeliveryId)));
        delivery.getStages().forEach(stage -> {
            String newStageId = stage.getId().replace(oldDeliveryId, newDeliveryId);
            delivery.findTransitionFrom((Stage)((Object)stage)).ifPresent(transition -> transition.setFromStageId(newStageId));
            stage.setId(newStageId);
        });
        delivery.getTrackedItems().forEach(item -> {
            item.setId(this.generateId(TrackedItem.class, newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    private String generateId(Class<? extends ConfigurationItem> ciClass, String parentId) {
        return this.ciIdService().getUniqueId(Type.valueOf(ciClass), parentId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$deleteStage$3(Delivery pattern$2, Stage x$1) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern$2.findTransitionFrom(x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Transition transition = (Transition)((Object)some.value());
            pattern$2.removeTransition(transition);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateStage$1(Stage stage$2, Stage x$2) {
        String string = x$2.getTitle();
        String string2 = stage$2.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$10, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$10);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

