export class BaseSidebarProvider {
    checkIfSelected(path: string, pathSuffix = '') {
        let urlPath = path;
        const index = urlPath.lastIndexOf('/');
        if (index > -1) {
            urlPath = urlPath.substring(index + 1, urlPath.length);
        }
        // default case
        if (urlPath.startsWith('Delivery') && !pathSuffix) {
            return true;
        }
        return urlPath === pathSuffix;
    }

    fixPath(path: string) {
        return path.endsWith('/') ? path.substring(0, path.length - 1) : path;
    }
}
