/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.DeliveryPatternApi;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.CreateDeliveryStage;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.api.v1.forms.ValidatePattern;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryExecutionService;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Page;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

@Controller
public class DeliveryPatternApiImpl
implements DeliveryPatternApi {
    private final DeliveryActorService deliveryActorService;
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryExecutionService deliveryExecutionService;
    private final DeliveryPermissionChecker permissions;

    @Autowired
    public DeliveryPatternApiImpl(DeliveryActorService deliveryActorService, DeliveryPatternService deliveryPatternService, DeliveryExecutionService deliveryExecutionService, DeliveryPermissionChecker permissions) {
        this.deliveryActorService = deliveryActorService;
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryExecutionService = deliveryExecutionService;
        this.permissions = permissions;
    }

    @Timed
    public Delivery createPattern(Delivery pattern) {
        Checks.checkNotNull((Object)pattern, (String)"pattern");
        Checks.checkNotNull((Object)pattern.getFolderId(), (String)"pattern.folderId");
        this.permissions.checkEditDeliveryPattern(pattern);
        pattern.getTransitions().forEach(Transition::checkRestrictions);
        return this.deliveryPatternService.createDeliveryPattern(pattern);
    }

    @Timed
    public Delivery getPattern(String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getPattern(patternId);
    }

    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)patternIdOrTitle), (String)"Pattern Id or title is required", (Object[])new Object[0]);
        Delivery pattern = this.deliveryPatternService.getPatternByIdOrTitle(patternIdOrTitle);
        this.permissions.checkViewDeliveryPattern(pattern.getId());
        return pattern;
    }

    @Timed
    public boolean checkTitleUnique(ValidatePattern validation) {
        return !this.deliveryPatternService.existsPatternWithTitle(validation.getId(), validation.getTitle());
    }

    @Timed
    public Delivery updatePattern(String patternId, Delivery pattern) {
        this.permissions.checkEditDeliveryPattern(patternId);
        this.permissions.checkEditDeliveryPattern(pattern);
        pattern.setId(patternId);
        return this.deliveryActorService.updatePattern(pattern);
    }

    @Timed
    public Delivery updatePattern(Delivery pattern) {
        return this.updatePattern(pattern.getId(), pattern);
    }

    @Timed
    public void deletePattern(String patternId) {
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deletePattern(patternId);
    }

    @Timed
    public Delivery duplicatePattern(String patternId, DuplicateDeliveryPattern duplicateDeliveryPattern) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.duplicatePattern(patternId, Objects.isNull(duplicateDeliveryPattern) ? new DuplicateDeliveryPattern() : duplicateDeliveryPattern);
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery createDelivery) {
        Checks.checkNotNull((Object)createDelivery, (String)"createDelivery");
        Checks.checkNotNull((Object)createDelivery.getFolderId(), (String)"createDelivery.folderId");
        this.permissions.checkEditDeliveryOnCreate(createDelivery.getFolderId());
        return this.deliveryActorService.createDeliveryFromPattern(patternId, createDelivery);
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Long page, Long resultsPerPage) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == filters) {
            filters = new DeliveryPatternFilters();
        }
        return this.deliveryPatternService.searchPatterns(filters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()), true);
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters) {
        return this.searchPatterns(filters, 0L, 100L);
    }

    @Timed
    public Stage createStage(String patternId, Stage stage) {
        return this.createStage(patternId, stage, null);
    }

    @Timed
    public Stage createStage(String patternId, Stage stage, Integer position) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.addStage(patternId, stage, Optional.ofNullable(position));
    }

    @Timed
    public Stage createStage(String patternId, CreateDeliveryStage form) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.addStageBetween(patternId, form.getStage(), Optional.ofNullable(form.getBefore()), Optional.ofNullable(form.getAfter()));
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getStages(patternId);
    }

    @Timed
    public Stage updateStage(Stage stage) {
        return this.updateStage(stage.getId(), stage);
    }

    @Timed
    public Stage updateStage(String stageId, Stage stage) {
        return this.updateStage(stageId, stage, false);
    }

    @Timed
    public Stage updateStageFromBatch(String stageId, Stage stage) {
        return this.updateStage(stageId, stage, true);
    }

    private Stage updateStage(String stageId, Stage stage, Boolean fromBatch) {
        stage.setId(stageId);
        String patternId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        try {
            return this.deliveryActorService.updateStage(patternId, stage, fromBatch);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public void deleteStage(String stageId) {
        String patternId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        try {
            this.deliveryActorService.deleteStage(patternId, stageId);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public Transition createTransition(String stageId, Transition transition) {
        Checks.checkNotNull((Object)transition, (String)"Transition");
        String patternId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        transition.checkRestrictions();
        try {
            return this.deliveryActorService.addTransition(patternId, stageId, transition);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public Transition updateTransition(String transitionId, Transition transition) {
        Checks.checkNotNull((Object)transition, (String)"Transition");
        String patternId = DeliveryUtils.deliveryIdFrom((String)transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        transition.setId(transitionId);
        transition.checkRestrictions();
        try {
            return this.deliveryActorService.updateTransition(patternId, transition);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public Transition updateTransition(Transition transition) {
        return this.updateTransition(transition.getId(), transition);
    }

    @Timed
    public void deleteTransition(String transitionId) {
        String patternId = DeliveryUtils.deliveryIdFrom((String)transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        try {
            this.deliveryActorService.deleteTransition(patternId, transitionId);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public TrackedItem createTrackedItem(String patternId, TrackedItem item) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.createTrackedItem(patternId, item);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryExecutionService.getTrackedItems(patternId);
    }

    @Timed
    public TrackedItem updateTrackedItem(String itemId, TrackedItem item) {
        item.setId(itemId);
        String patternId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        try {
            return this.deliveryActorService.updateTrackedItem(patternId, item);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }

    @Timed
    public TrackedItem updateTrackedItem(TrackedItem item) {
        return this.updateTrackedItem(item.getId(), item);
    }

    @Timed
    public void deleteTrackedItem(String itemId) {
        String patternId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        try {
            this.deliveryActorService.deleteTrackedItem(patternId, itemId);
        }
        catch (LogFriendlyNotFoundException e) {
            throw new LogFriendlyConcurrentModificationException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }
}

