package com.xebialabs.xlrelease.delivery.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository
import com.xebialabs.xlrelease.domain.delivery.{Delivery, DeliveryStatus}
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.repository.PersistenceInterceptor
import org.springframework.stereotype.Repository

@IsTransactional
@Repository
class DeliveryLimitPersistenceInterceptor(deliveryRepository: DeliveryRepository,
                                          limitEnforcer: LimitEnforcer)
  extends PersistenceInterceptor[Delivery] {

  deliveryRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Delivery): Unit = {
    val tenantId = ci.getTenantId

    ci.getStatus match {
      case DeliveryStatus.TEMPLATE =>
        limitEnforcer.enforceLimit(tenantId, LimitType.PATTERNS, 1, () => deliveryRepository.tenantPatternCount(tenantId))
      case _ =>
        limitEnforcer.enforceLimit(tenantId, LimitType.DELIVERIES, 1, () => deliveryRepository.tenantDeliveryCount(tenantId))
    }
  }

}
