package com.xebialabs.xlrelease.handler

import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker
import com.xebialabs.xlrelease.delivery.service.DeliveryActivityLogsService
import com.xebialabs.xlrelease.domain.ActivityLogEntry
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}

@Component
class DeliveryActivityLogsApiHandler @Autowired()(deliveryActivityLogsService: DeliveryActivityLogsService, permissions: DeliveryPermissionChecker)
  extends BaseActivityLogsApiHandler(deliveryActivityLogsService, "delivery") {

  override def getActivityLogs(deliveryId: String): JList[ActivityLogEntry] = {
    permissions.checkView(deliveryId)
    searchLogs(deliveryId)
  }
}
