import React, { ReactNode } from 'react';
import { addVariableCharacters } from '@xlr-ui/app/features/tasks/components/helper/variables.helper';
import { propertiesForm } from '@xlr-ui/app/features/tasks/components/rails/config/ducks/properties-form.reducer';
import { InputWithScalar } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';
import { InputWithVariables } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-variables/input-with-variables.component';
import { PropertiesEnum, TaskInputCommonProps } from '@xlr-ui/app/features/tasks/components/rails/config/components/types';
import { getTaskDrawerState } from '@xlr-ui/app/features/tasks/ducks/task-drawer.reducer';
import { useAppDispatch, useAppSelector } from '@xlr-ui/app/js/hooks';
import { Task, TaskInputPropertiesVariableOrValue, VariableType } from '@xlr-ui/app/types';
import { FolderWithVariables } from './folder.component';
const { createReleaseVariableAndUpdateTask } = propertiesForm.actions;

interface WithFallbackProps {
    children: ReactNode;
    task: Task;
}

export const OnlyOnFallback = ({ task, children }: WithFallbackProps) => {
    const isFallback = ((task.inputProperties?.fallback as TaskInputPropertiesVariableOrValue).value as boolean) || false;

    if (!isFallback) {
        return <></>;
    }
    return <>{children}</>;
};

export const FolderOnlyOnFallbackWithVariables = (props: TaskInputCommonProps) => {
    return (
        <OnlyOnFallback {...props}>
            <FolderWithVariables {...props} />
        </OnlyOnFallback>
    );
};

export const TextOnlyOnFallback = (props: TaskInputCommonProps) => {
    return (
        <OnlyOnFallback {...props}>
            <InputWithScalar {...props} type="text" />
        </OnlyOnFallback>
    );
};
export const DateOnlyOnFallbackWithVariables = (props: TaskInputCommonProps) => {
    const { allVariables } = useAppSelector(getTaskDrawerState);
    const dispatch = useAppDispatch();

    const handleAddVariable = (variableName: string, variableType: VariableType) => {
        dispatch(
            createReleaseVariableAndUpdateTask({
                propertiesEnum: PropertiesEnum.InputProperties,
                propertyName: props.property.name,
                taskValue: {
                    value: (props.task.inputProperties?.[props.property.name] as TaskInputPropertiesVariableOrValue).value,
                    variable: addVariableCharacters(variableName),
                },
                variableName,
                variableType,
            }),
        );
    };
    return (
        <OnlyOnFallback {...props}>
            <InputWithVariables {...props} onNewVariableAdd={handleAddVariable} variables={allVariables}>
                <InputWithScalar {...props} type="datetime-local" />
            </InputWithVariables>
        </OnlyOnFallback>
    );
};
