package com.xebialabs.xlrelease.delivery.repository

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.api.v1.forms.{AbstractDeliveryFilters, DeliveryOrderMode}
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle
import com.xebialabs.xlrelease.domain.delivery.Delivery
import com.xebialabs.xlrelease.repository.Ids.isNullId
import com.xebialabs.xlrelease.repository.Page
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository

trait DeliveryRepository extends InterceptedRepository[Delivery] {
  def read(deliveryId: String): Delivery

  def getByIdOrTitle(deliveryIdOrTitle: String): Delivery

  def search(filters: AbstractDeliveryFilters,
             page: Page,
             orderBy: DeliveryOrderMode,
             principals: Iterable[String], roleIds: Iterable[String],
             anyOfPermissions: Seq[Permission],
             enforcePermissions: Boolean = true): Seq[Delivery]

  def searchIds(filters: AbstractDeliveryFilters): Seq[String]

  def create(delivery: Delivery): Unit

  def update(delivery: Delivery): Unit

  def createOrUpdate(delivery: Delivery): Unit = {
    if (!isNullId(delivery.getId) && exists(delivery.getId)) {
      update(delivery)
    } else {
      create(delivery)
    }
  }

  def exists(deliveryId: String): Boolean

  def delete(deliveryId: String): Unit

  def findDeliveriesReferencingReleaseId(releaseId: String): Seq[String]

  def findActiveDeliveriesReferencingFolderId(folderId: String): Seq[CiIdWithTitle]

  def findFolderId(deliveryId: String): String

  def findReleasesByDeliveryId(deliveryId: String): Seq[DeliveryFlowReleaseInfo]

  def findPatternByTitle(title: String): Option[Delivery]

  def tenantPatternCount(tenantId: String): Integer

  def tenantDeliveryCount(tenantId: String): Integer
}
