package com.xebialabs.xlrelease.delivery.transition.condition

import com.xebialabs.xlrelease.domain.delivery.conditions.ItemsCompletionCondition
import com.xebialabs.xlrelease.domain.delivery.{Delivery, Stage, TrackedItemStatus}
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils.getItemsWithStatusInAllStages

import scala.jdk.CollectionConverters._

package object state {

  implicit class ItemsConditionExt(val condition: ItemsCompletionCondition) extends AnyVal {
    def isSatisfiedBy(stages: Seq[Stage], delivery: Delivery): Boolean = {
      val allItems = delivery.getTrackedItems.asScala.toSeq
      if (!condition.isIgnoreDescoped && allItems.exists(_.isDescoped)) {
        false
      } else {
        val notDescopedItems = allItems.filterNot(_.isDescoped)
        val allowedStatuses = condition.getStatuses.asScala.map(TrackedItemStatus.valueOf).toSeq
        val completedItems = getItemsWithStatusInAllStages(notDescopedItems, stages, allowedStatuses)
        completedItems == notDescopedItems
      }
    }
  }

}
