import { isDeliveryId, isDeliveryStageId } from './index';

describe('deliveries task helper', () => {
    describe('isDeliveryStageId', () => {
        it('should be false if value is undefined', () => {
            expect(isDeliveryStageId(undefined)).toBe(false);
        });
        it('should be false if value is null', () => {
            expect(isDeliveryStageId(null)).toBe(false);
        });
        it('should be false if value is not a stage', () => {
            expect(isDeliveryStageId('some value')).toBe(false);
        });
        it('should be true if value is a Stage', () => {
            expect(isDeliveryStageId('Deliveries/Deliverye751aaaad15a4723bb390ba8aea19e9d/Stage20e71bebfe994ef7a5a72145719a214e')).toBe(true);
            expect(isDeliveryStageId('Deliverye751aaaad15a4723bb390ba8aea19e9d/Stage20e71bebfe994ef7a5a72145719a214e')).toBe(true);
            expect(isDeliveryStageId('Stage20e71bebfe994ef7a5a72145719a214e')).toBe(true);
        });
    });

    describe('isDeliveryId', () => {
        it('should be false if value is undefined', () => {
            expect(isDeliveryId(undefined)).toBe(false);
        });
        it('should be false if value is null', () => {
            expect(isDeliveryId(null)).toBe(false);
        });
        it('should be false if value is not a delivery', () => {
            expect(isDeliveryId('Deliverye751aaaad15a4723/Stage1231212')).toBe(false);
            expect(isDeliveryId('something')).toBe(false);
        });
        it('should be true if value is a delivery', () => {
            expect(isDeliveryId('Deliveries/Deliverye751aa')).toBe(true);
            expect(isDeliveryId('Deliverye751aaaad15a4723')).toBe(true);
        });
    });
});
