package com.xebialabs.xlrelease.delivery.repository.sql.persistence

import com.xebialabs.xlrelease.repository.Ids._
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.{Table, TenantId}
import com.xebialabs.xlrelease.utils.FolderId

object DeliverySchema {

  val COLUMN_LENGTH_TITLE: Int = 255

  object RELEASE_DELIVERIES extends Table("XLR_DELIVERIES") {
    val ID = "ID"
    val CI_UID = "CI_UID"
    val FOLDER_UID = "FOLDER_UID"
    val TITLE = "TITLE"
    val STATUS = "STATUS"
    val START_DATE = "START_DATE"
    val END_DATE = "END_DATE"
    val ORIGIN_PATTERN_ID = "ORIGIN_PATTERN_ID"
    val CONTENT = "CONTENT"
    val TENANT_ID = "TENANT_ID"
  }

  object RELEASE_DELIVERY_MEMBERS extends Table("XLR_DELIVERY_MEMBERS") {
    val DELIVERY_UID = "DELIVERY_UID"
    val RELEASE_ID = "RELEASE_ID"
  }

  object TRACKED_ITEMS extends Table("XLR_TRACKED_ITEMS") {
    val CI_UID = "CI_UID"
    val ID = "ID"
    val DELIVERY_UID = "DELIVERY_UID"
    val TITLE = "TITLE"
    val IS_DESCOPED = "IS_DESCOPED"
    val CREATED_DATE = "CREATED_DATE"
    val MODIFIED_DATE = "MODIFIED_DATE"
  }

}

case class DeliveryRow(content: String, ciUid: Int, folderId: FolderId, deliveryId: String, tenantId: TenantId) {
  def domainId: String = s"$DELIVERIES_ROOT$SEPARATOR$deliveryId"
}

case class DeliveryMemberRow(deliveryUid: Int, releaseId: CiId)

case class CiIdWithTitle(deliveryId: String, title: String)
