import React, { ReactNode } from 'react';
import { InputWithScalar } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';
import { InputWithEnum } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-enum/input-with-enum.component';
import { TaskInputCommonProps } from '@xlr-ui/app/features/tasks/components/rails/config/components/types';
import { Task, TaskInputPropertiesVariableOrValue } from '@xlr-ui/app/types';

interface WithSearchProps {
    children: ReactNode;
    task: Task;
}

export const OnlyOnSearch = ({ task, children }: WithSearchProps) => {
    const searchStrategy = ((task.inputProperties?.searchStrategy as TaskInputPropertiesVariableOrValue).value as string) || '';

    if (searchStrategy === 'Latest delivery from pattern') {
        return <></>;
    }
    return <>{children}</>;
};

export const TextOnlyOnSearch = (props: TaskInputCommonProps) => {
    return (
        <OnlyOnSearch {...props}>
            <InputWithScalar {...props} type="text" />
        </OnlyOnSearch>
    );
};

export const EnumOnlyOnSearch = (props: TaskInputCommonProps) => {
    return (
        <OnlyOnSearch {...props}>
            <InputWithEnum {...props} />
        </OnlyOnSearch>
    );
};
