package com.xebialabs.xlrelease.delivery.transition.condition.state

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService
import com.xebialabs.xlrelease.delivery.transition.condition.{ConditionChange, DeliveryConditionReaction}
import com.xebialabs.xlrelease.domain.delivery.conditions.ItemsCompletionCondition
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ItemsConditionReaction @Autowired()(val deliveryActorService: DeliveryActorService) extends DeliveryConditionReaction {
  override def forType: Type = Type.valueOf(classOf[ItemsCompletionCondition])

  override def onCreate(change: ConditionChange): Unit = ()

  override def onUpdate(change: ConditionChange): Unit = {
    val delivery = change.delivery
    val condition = change.condition.asInstanceOf[ItemsCompletionCondition]
    if (condition.isActive && condition.isSatisfiedBy(delivery.getStageGroupOfStage(change.stage).asScala.toSeq, delivery)) {
      deliveryActorService.markConditionAsSatisfied(delivery.getId, condition.getId)
    }
  }

  override def onDelete(change: ConditionChange): Unit = ()

}
