package com.xebialabs.xlrelease.delivery.transition.condition

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.delivery.{Condition, Delivery, Stage, Transition}

// do we need this
case class ConditionChange(delivery: Delivery, stage: Stage, transition: Transition, condition: Condition)

trait DeliveryConditionReaction {
  def forType: Type

  def onCreate(change: ConditionChange): Unit

  def onUpdate(change: ConditionChange): Unit

  def onDelete(change: ConditionChange): Unit
}

