package com.xebialabs.xlrelease.delivery.repository.sql.persistence

import com.xebialabs.xlrelease.db.sql.SqlBuilder
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema.{TRACKED_ITEMS => TIS}

object TrackedItemSqlBuilder {
  val alias = "tis"

  val STMT_TRACKED_ITEM_SELECT: String =
    s"""|SELECT
        |$alias.${TIS.CI_UID}
        |, $alias.${TIS.ID}
        |, $alias.${TIS.DELIVERY_UID}
        |, $alias.${TIS.TITLE}
        | FROM ${TIS.TABLE} $alias
      """.stripMargin

}

class TrackedItemSqlBuilder(implicit dialect: Dialect) extends SqlBuilder[TrackedItemSqlBuilder] {
  import TrackedItemSqlBuilder._

  def select(): TrackedItemSqlBuilder = {
    super.select(STMT_TRACKED_ITEM_SELECT)
  }

  def withTitleLike(title: String): TrackedItemSqlBuilder = {
    like(s"$alias.${TIS.TITLE}", title)
  }

  override def newInstance: TrackedItemSqlBuilder = new TrackedItemSqlBuilder()

}
