package com.xebialabs.xlrelease.delivery.repository

import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, ReleaseRepository}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class DeliveryPersistenceInterceptor @Autowired()(releaseRepository: ReleaseRepository,
                                                      deliveryMemberPersistence: DeliveryMemberPersistence)
  extends PersistenceInterceptor[Release] {

  releaseRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Release): Unit = {}

  override def onDelete(ciId: String): Unit = deliveryMemberPersistence.deleteMembersByReleaseId(ciId)
}
