/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.MetadataIncludingCiConverter;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$RELEASE_DELIVERIES$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$RELEASE_DELIVERY_MEMBERS$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.id.IdCreator$;
import com.xebialabs.xlrelease.domain.id.package;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.FolderId$;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tUd\u0001B\u0015+\u0001eB\u0001b\u0012\u0001\u0003\u0006\u0004%\u0019\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\rq\u000b\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003Y\u0011!\u0001\bA!A!\u0002\u0017\t\b\"\u0002;\u0001\t\u0003)\b\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\t9\u0004\u0001Q\u0001\n\u0005\u001d\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\n\u0003\u007f\u0002!\u0019!C\u0001\u0003\u0003C\u0001\"!%\u0001A\u0003%\u00111\u0011\u0005\b\u0003'\u0003A\u0011AAK\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAB\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0011\"a-\u0001\u0005\u0004%I!!!\t\u0011\u0005U\u0006\u0001)A\u0005\u0003\u0007Cq!a.\u0001\t\u0003\tI\fC\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011q\u0018\u0001!\u0002\u0013\t\u0019\tC\u0004\u0002B\u0002!\t!a1\t\u0013\u00055\u0007A1A\u0005\n\u0005\u0005\u0005\u0002CAh\u0001\u0001\u0006I!a!\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"I\u0011q\u001c\u0001C\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003C\u0004\u0001\u0015!\u0003\u0002\u0004\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\n\u0005\u001f\u0001!\u0019!C\u0005\u0003\u0003C\u0001B!\u0005\u0001A\u0003%\u00111\u0011\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011%\u0011)\u0003\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0003(\u0001\u0001\u000b\u0011BAB\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WA\u0011B!\u0010\u0001\u0005\u0004%I!!!\t\u0011\t}\u0002\u0001)A\u0005\u0003\u0007CqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0005\u0003H\u0001\u0011\r\u0011\"\u0003\u0003J!A!\u0011\u000b\u0001!\u0002\u0013\u0011Y\u0005C\u0004\u0003T\u0001!IA!\u0016\u0003'\u0011+G.\u001b<fef\u0004VM]:jgR,gnY3\u000b\u0005-b\u0013a\u00039feNL7\u000f^3oG\u0016T!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005Q!/\u001a9pg&$xN]=\u000b\u0005E\u0012\u0014\u0001\u00033fY&4XM]=\u000b\u0005M\"\u0014!\u0003=me\u0016dW-Y:f\u0015\t)d'A\u0005yK\nL\u0017\r\\1cg*\tq'A\u0002d_6\u001c\u0001aE\u0002\u0001u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!F\u001b\u0005\u0011%BA\u0016D\u0015\tiCI\u0003\u00020e%\u0011aI\u0011\u0002\u0013!\u0016\u00148/[:uK:\u001cWmU;qa>\u0014H/\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001J!\tQ5+D\u0001L\u0015\taU*\u0001\u0003d_J,'B\u0001(P\u0003\u0011QGMY2\u000b\u0005A\u000b\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003I\u000b1a\u001c:h\u0013\t!6J\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005A\u0006CA-m\u001d\tQ\u0016N\u0004\u0002\\O:\u0011A,\u001a\b\u0003;\u0012t!AX2\u000f\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0014A\u0002\u001fs_>$h(C\u00018\u0013\t)d'\u0003\u00024i%\u0011aMM\u0001\u0003I\nL!!\f5\u000b\u0005\u0019\u0014\u0014B\u00016l\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003[!L!!\u001c8\u0003\u000f\u0011K\u0017\r\\3di*\u0011!n[\u0001\tI&\fG.Z2uA\u0005\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005\u0005\u0013\u0018BA:C\u0005E1u\u000e\u001c3feB+'o]5ti\u0016t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y$ba^=\u0002\u0012\u0005e\u0001C\u0001=\u0001\u001b\u0005Q\u0003\"B$\u0007\u0001\bI\u0005FB=|\u0003\u0017\ti\u0001E\u0002}\u0003\u000fi\u0011! \u0006\u0003}~\f!\"\u00198o_R\fG/[8o\u0015\u0011\t\t!a\u0001\u0002\u000f\u0019\f7\r^8ss*\u0019\u0011QA(\u0002\u000b\t,\u0017M\\:\n\u0007\u0005%QPA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011qB\u0001\u001aq2\u0014(+\u001a9pg&$xN]=KI\n\u001cG+Z7qY\u0006$X\rC\u0003W\r\u0001\u000f\u0001\fK\u0004\u0002\u0012m\fY!!\u0006\"\u0005\u0005]\u0011a\u0006=meJ+\u0007o\\:ji>\u0014\u0018pU9m\t&\fG.Z2u\u0011\u0015\u0001h\u0001q\u0001rQ\r1\u0011Q\u0004\t\u0004y\u0006}\u0011bAA\u0011{\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0013'RkEkX$F)~+\u0016\nR0C3~KE)\u0006\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027b]\u001eT!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\tYC\u0001\u0004TiJLgnZ\u0001\u0014'RkEkX$F)~+\u0016\nR0C3~KE\tI\u0001\u0007O\u0016$X+\u001b3\u0015\t\u0005u\u0012\u0011\r\t\u0006w\u0005}\u00121I\u0005\u0004\u0003\u0003b$AB(qi&|g\u000e\u0005\u0003\u0002F\u0005mc\u0002BA$\u0003+rA!!\u0013\u0002P9\u0019A,a\u0013\n\u0007\u00055#'\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003#\n\u0019&\u0001\u0002jI*\u0019\u0011Q\n\u001a\n\t\u0005]\u0013\u0011L\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\t\t&a\u0015\n\t\u0005u\u0013q\f\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0005\u0003/\nI\u0006C\u0004\u0002d%\u0001\r!!\u001a\u0002\u0015\u0011,G.\u001b<fefLE\r\u0005\u0003\u0002h\u0005ed\u0002BA5\u0003krA!a\u001b\u0002t9!\u0011QNA9\u001d\ra\u0016qN\u0005\u0003_IJ!!\f#\n\u0005-\u001a\u0015bAA<\u0005\u0006!1)[%e\u0013\u0011\tY(! \u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003o\u0012\u0015\u0001H*U\u001bR{\u0016JT*F%R{&+\u0012'F\u0003N+u\fR#M\u0013Z+%+W\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\u000e:!\u0011qQAE!\tyF(C\u0002\u0002\fr\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003\u001fS1!a#=\u0003u\u0019F+\u0014+`\u0013:\u001bVI\u0015+`%\u0016cU)Q*F?\u0012+E*\u0013,F%f\u0003\u0013AB5og\u0016\u0014H\u000f\u0006\u0003\u0002D\u0005]\u0005BB\u0019\r\u0001\u0004\tI\n\u0005\u0003\u0002\u001c\u0006}UBAAO\u0015\r\t\u00141K\u0005\u0005\u0003C\u000biJ\u0001\u0005EK2Lg/\u001a:z\u0003q\u0019F+\u0014+`+B#\u0015\tV#`%\u0016cU)Q*F?\u0012+E*\u0013,F%f\u000bQd\u0015+N)~+\u0006\u000bR!U\u000b~\u0013V\tT#B'\u0016{F)\u0012'J-\u0016\u0013\u0016\fI\u0001\u0007kB$\u0017\r^3\u0015\t\u0005-\u0016\u0011\u0017\t\u0004w\u00055\u0016bAAXy\t!QK\\5u\u0011\u0019\tt\u00021\u0001\u0002\u001a\u0006\u00113\u000bV'U?\u0012+E*\u0012+F?J+E*R!T\u000b~#U\tT%W\u000bJKvLQ-`\u0013\u0012\u000b1e\u0015+N)~#U\tT#U\u000b~\u0013V\tT#B'\u0016{F)\u0012'J-\u0016\u0013\u0016l\u0018\"Z?&#\u0005%\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003W\u000bY\fC\u0004\u0002dI\u0001\r!!\u001a\u0002EM#V\nV0F1&\u001bFkU0S\u000b2+\u0015iU#`\t\u0016c\u0015JV#S3~\u0013\u0015lX%E\u0003\r\u001aF+\u0014+`\u000bbK5\u000bV*`%\u0016cU)Q*F?\u0012+E*\u0013,F%f{&)W0J\t\u0002\na!\u001a=jgR\u001cH\u0003BAc\u0003\u0017\u00042aOAd\u0013\r\tI\r\u0010\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019'\u0006a\u0001\u0003K\n\u0001e\u0015+N)~3\u0015J\u0014#`%\u0016cU)Q*F?\u0012+E*\u0013,F%f{&)W0J\t\u0006\t3\u000bV'U?\u001aKe\nR0S\u000b2+\u0015iU#`\t\u0016c\u0015JV#S3~\u0013\u0015lX%EA\u0005Aa-\u001b8e\u0005fLE\r\u0006\u0003\u0002V\u0006u\u0007#B\u001e\u0002@\u0005]\u0007c\u0001=\u0002Z&\u0019\u00111\u001c\u0016\u0003\u0017\u0011+G.\u001b<fef\u0014vn\u001e\u0005\b\u0003#B\u0002\u0019AA3\u0003\r\u001aF+\u0014+`\r&sEi\u0018*F\u0019\u0016\u000b5+R0E\u000b2Ke+\u0012*Z?\nKv\fV%U\u0019\u0016\u000bAe\u0015+N)~3\u0015J\u0014#`%\u0016cU)Q*F?\u0012+E*\u0013,F%f{&)W0U\u0013RcU\tI\u0001\fM&tGMQ=USRdW\r\u0006\u0003\u0002V\u0006\u001d\bbBAu7\u0001\u0007\u00111Q\u0001\u0006i&$H.Z\u0001\fM&tGMQ=Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002p\u0006}\bCBAy\u0003s\f9N\u0004\u0003\u0002t\u0006]hbA0\u0002v&\tQ(C\u0002\u0002XqJA!a?\u0002~\n\u00191+Z9\u000b\u0007\u0005]C\bC\u0004\u0003\u0002q\u0001\rAa\u0001\u0002#M\fHnV5uQB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0003\u0006\t%ab\u0001.\u0003\b%\u0019\u0011qK6\n\t\t-!Q\u0002\u0002\u0012'Fdw+\u001b;i!\u0006\u0014\u0018-\\3uKJ\u001c(bAA,W\u0006\t3\u000bV'U?\u001e+Ek\u0018$P\u0019\u0012+%kX%E?\nKv\fR#M\u0013Z+%+W0J\t\u0006\u00113\u000bV'U?\u001e+Ek\u0018$P\u0019\u0012+%kX%E?\nKv\fR#M\u0013Z+%+W0J\t\u0002\nABZ5oI\u001a{G\u000eZ3s\u0013\u0012$BAa\u0006\u0003$A!!\u0011\u0004B\u0010\u001b\t\u0011YBC\u0002\u0003\u001eI\nQ!\u001e;jYNLAA!\t\u0003\u001c\tAai\u001c7eKJLE\rC\u0004\u0002d}\u0001\r!a!\u0002AM#V\nV0H\u000bR{&+\u0012'F\u0003N+5k\u0018\"Z?\u0012+E*\u0013,F%f{\u0016\nR\u0001\"'RkEkX$F)~\u0013V\tT#B'\u0016\u001bvLQ-`\t\u0016c\u0015JV#S3~KE\tI\u0001\u0019M&tGMU3mK\u0006\u001cXm\u001d\"z\t\u0016d\u0017N^3ss&#G\u0003\u0002B\u0017\u0005w\u0001b!!=\u0002z\n=\u0002\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tUB)A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0003:\tM\"a\u0005*fY\u0016\f7/\u001a\"bg&\u001cG)\u0019;b\u000bb$\bbBA2E\u0001\u0007\u00111Q\u0001\u001b'RkEk\u0018$J\u001d\u0012{\u0006+\u0011+U\u000bJsuLQ-`)&#F*R\u0001\u001c'RkEk\u0018$J\u001d\u0012{\u0006+\u0011+U\u000bJsuLQ-`)&#F*\u0012\u0011\u0002%\u0019Lg\u000e\u001a)biR,'O\u001c\"z)&$H.\u001a\u000b\u0005\u0003+\u0014)\u0005C\u0004\u0002j\u0016\u0002\r!a!\u0002#\u0011,G.\u001b<fef\u0014vn^'baB,'/\u0006\u0002\u0003LA)!J!\u0014\u0002X&\u0019!qJ&\u0003\u0013I{w/T1qa\u0016\u0014\u0018A\u00053fY&4XM]=S_^l\u0015\r\u001d9fe\u0002\n\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005\r%q\u000b\u0005\u0007c!\u0002\r!!')\u0007\u0001\u0011Y\u0006\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\tgT\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B3\u0005?\u0012!BU3q_NLGo\u001c:zQ\r\u0001!\u0011\u000e\t\u0005\u0005W\u0012\t(\u0004\u0002\u0003n)\u0019!qN6\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005g\u0012iGA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class DeliveryPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final FolderPersistence folderPersistence;
    private final String STMT_GET_UID_BY_ID;
    private final String STMT_INSERT_RELEASE_DELIVERY;
    private final String STMT_UPDATE_RELEASE_DELIVERY;
    private final String STMT_DELETE_RELEASE_DELIVERY_BY_ID;
    private final String STMT_EXISTS_RELEASE_DELIVERY_BY_ID;
    private final String STMT_FIND_RELEASE_DELIVERY_BY_ID;
    private final String STMT_FIND_RELEASE_DELIVERY_BY_TITLE;
    private final String STMT_GET_FOLDER_ID_BY_DELIVERY_ID;
    private final String STMT_GET_RELEASES_BY_DELIVERY_ID;
    private final String STMT_FIND_PATTERN_BY_TITLE;
    private final RowMapper<DeliveryRow> deliveryRowMapper;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public void sqlInsertTask(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public void sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam) {
        PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Long uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Long)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Long uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Long)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        DeliveryPersistence deliveryPersistence = this;
        synchronized (deliveryPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private String STMT_GET_UID_BY_ID() {
        return this.STMT_GET_UID_BY_ID;
    }

    public Option<Long> getUid(String deliveryId) {
        return this.sqlQuery(this.STMT_GET_UID_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getLong(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()))).headOption();
    }

    public String STMT_INSERT_RELEASE_DELIVERY() {
        return this.STMT_INSERT_RELEASE_DELIVERY;
    }

    public Long insert(Delivery delivery) {
        Long l;
        Long folderUid = this.folderPersistence.getUid(delivery.getFolderId());
        String content = this.serialize(delivery);
        Long id = IdCreator$.MODULE$.generateId();
        try {
            this.sqlExecWithContent(this.STMT_INSERT_RELEASE_DELIVERY(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID())), (Object)id), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID())), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getId())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID())), (Object)folderUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE())), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(delivery.getTitle()), DeliverySchema$.MODULE$.COLUMN_LENGTH_TITLE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS())), (Object)delivery.getStatus().value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE())), (Object)delivery.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE())), (Object)delivery.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID())), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getOriginPatternId()))))})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT())), (Object)content));
            l = id;
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException("Release delivery with ID '" + delivery.getId() + "' already exists", ex);
        }
        return l;
    }

    private String STMT_UPDATE_RELEASE_DELIVERY() {
        return this.STMT_UPDATE_RELEASE_DELIVERY;
    }

    public void update(Delivery delivery) {
        Long folderUid = this.folderPersistence.getUid(delivery.getFolderId());
        String content = this.serialize(delivery);
        this.sqlExecWithContent(this.STMT_UPDATE_RELEASE_DELIVERY(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getId())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folderUid"), (Object)folderUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newTitle"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(delivery.getTitle()), DeliverySchema$.MODULE$.COLUMN_LENGTH_TITLE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newStatus"), (Object)delivery.getStatus().value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newStartDate"), (Object)delivery.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newEndDate"), (Object)delivery.getEndDate())})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)content), this.checkCiUpdated(delivery.getId()));
    }

    private String STMT_DELETE_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_DELETE_RELEASE_DELIVERY_BY_ID;
    }

    public void delete(String deliveryId) {
        this.sqlExec(this.STMT_DELETE_RELEASE_DELIVERY_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    private String STMT_EXISTS_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID;
    }

    public boolean exists(String deliveryId) {
        return BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPersistence.$anonfun$exists$1(x$1))).head());
    }

    private String STMT_FIND_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_FIND_RELEASE_DELIVERY_BY_ID;
    }

    public Option<DeliveryRow> findById(String id) {
        return this.findOptional((Function1 & Serializable)x$2 -> (DeliveryRow)x$2.queryForObject(this.STMT_FIND_RELEASE_DELIVERY_BY_ID(), this.deliveryRowMapper(), new Object[]{Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)))}), this.jdbcTemplate());
    }

    private String STMT_FIND_RELEASE_DELIVERY_BY_TITLE() {
        return this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE;
    }

    public Option<DeliveryRow> findByTitle(String title) {
        return this.findOptional((Function1 & Serializable)x$3 -> (DeliveryRow)x$3.queryForObject(this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE(), this.deliveryRowMapper(), new Object[]{title.toLowerCase()}), this.jdbcTemplate());
    }

    public Seq<DeliveryRow> findByQuery(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(sql2, this.deliveryRowMapper(), (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()))).asScala().toSeq();
    }

    private String STMT_GET_FOLDER_ID_BY_DELIVERY_ID() {
        return this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID;
    }

    public FolderId findFolderId(String deliveryId) {
        return (FolderId)this.sqlQuery(this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> (FolderId)Option$.MODULE$.apply((Object)rs.getString(1)).map((Function1 & Serializable)x$5 -> new FolderId(x$5)).getOrElse((Function0 & Serializable)() -> FolderId$.MODULE$.Root())).headOption().getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Cannot find folderId for non existing delivery " + deliveryId, new Object[0]);
        });
    }

    private String STMT_GET_RELEASES_BY_DELIVERY_ID() {
        return this.STMT_GET_RELEASES_BY_DELIVERY_ID;
    }

    public Seq<ReleaseBasicDataExt> findReleasesByDeliveryId(String deliveryId) {
        return this.sqlQuery(this.STMT_GET_RELEASES_BY_DELIVERY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> new ReleaseBasicDataExt(rs.getString(Schema.RELEASES$.MODULE$.RELEASE_ID()), rs.getString(Schema.RELEASES$.MODULE$.RELEASE_TITLE()), rs.getString(Schema.RELEASES$.MODULE$.STATUS()), (Date)rs.getTimestamp(Schema.RELEASES$.MODULE$.START_DATE()), (Date)rs.getTimestamp(Schema.RELEASES$.MODULE$.END_DATE()))).toSeq();
    }

    private String STMT_FIND_PATTERN_BY_TITLE() {
        return this.STMT_FIND_PATTERN_BY_TITLE;
    }

    public Option<DeliveryRow> findPatternByTitle(String title) {
        return this.findOptional((Function1 & Serializable)x$6 -> (DeliveryRow)x$6.queryForObject(this.STMT_FIND_PATTERN_BY_TITLE(), this.deliveryRowMapper(), new Object[]{title.toLowerCase()}), this.jdbcTemplate());
    }

    private RowMapper<DeliveryRow> deliveryRowMapper() {
        return this.deliveryRowMapper;
    }

    private String serialize(Delivery delivery) {
        MetadataIncludingCiConverter ciConverter = new MetadataIncludingCiConverter(null, null);
        Delivery deliveryCopy = (Delivery)CiCloneHelper.cloneCi((ConfigurationItem)delivery);
        deliveryCopy.setFolderId(null);
        String content = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)deliveryCopy, (ConfigurationItemConverter)ciConverter);
        return content;
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    @Autowired
    public DeliveryPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, FolderPersistence folderPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.folderPersistence = folderPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_GET_UID_BY_ID = "SELECT " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID() + " FROM " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + " WHERE " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :id";
        this.STMT_INSERT_RELEASE_DELIVERY = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|INSERT INTO " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + "\n        |   ( " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID() + "\n        |   , " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT() + "\n        |   )\n        | VALUES\n        |   ( :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID() + "\n        |   , :" + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT() + "\n        |   )\n        "));
        this.STMT_UPDATE_RELEASE_DELIVERY = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|UPDATE " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + "\n        | SET\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE() + " = :newTitle,\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID() + " = :folderUid,\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS() + " = :newStatus,\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE() + " = :newStartDate,\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE() + " = :newEndDate,\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT() + " = :content\n        | WHERE\n        |  " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :id\n        "));
        this.STMT_DELETE_RELEASE_DELIVERY_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|DELETE FROM " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + "\n        | WHERE " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :id"));
        this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID = "SELECT COUNT(*) FROM " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + " WHERE " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :id";
        this.STMT_FIND_RELEASE_DELIVERY_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + DeliverySqlBuilder$.MODULE$.STMT_RELEASE_DELIVERY_SELECT() + "\n        | WHERE del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = ?"));
        this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + DeliverySqlBuilder$.MODULE$.STMT_RELEASE_DELIVERY_SELECT() + "\n        | WHERE LOWER(del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE() + ") = ?"));
        this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("| SELECT f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + "\n        | FROM " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + " del\n        | INNER JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " f ON f." + Schema.FOLDERS$.MODULE$.CI_UID() + " = del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID() + "\n        | WHERE del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :deliveryId"));
        this.STMT_GET_RELEASES_BY_DELIVERY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT rel." + Schema.RELEASES$.MODULE$.RELEASE_ID() + ", rel." + Schema.RELEASES$.MODULE$.RELEASE_TITLE() + ", rel." + Schema.RELEASES$.MODULE$.STATUS() + ", rel." + Schema.RELEASES$.MODULE$.START_DATE() + ",\n        | rel." + Schema.RELEASES$.MODULE$.END_DATE() + "\n        | FROM " + Schema.RELEASES$.MODULE$.TABLE() + " rel\n        | LEFT JOIN " + DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.TABLE() + " m ON m." + DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.RELEASE_ID() + " = rel." + Schema.RELEASES$.MODULE$.RELEASE_ID() + "\n        | INNER JOIN " + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE() + " d ON d." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID() + " = m." + DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.DELIVERY_UID() + "\n        | WHERE d." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID() + " = :deliveryId"));
        this.STMT_FIND_PATTERN_BY_TITLE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + DeliverySqlBuilder$.MODULE$.STMT_RELEASE_DELIVERY_SELECT() + "\n        | WHERE LOWER(del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE() + ") = ?\n        | AND LOWER(del." + DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS() + ") = '" + DeliveryStatus.TEMPLATE.value() + "'"));
        this.deliveryRowMapper = (rs, x$7) -> {
            DeliveryRow deliveryRow;
            try (InputStream contentStream = rs.getBinaryStream(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT());){
                String content = this.decompress(contentStream);
                deliveryRow = new DeliveryRow(content, rs.getLong(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()), new FolderId(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_ID())), rs.getString(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()));
            }
            return deliveryRow;
        };
    }
}

