import { call, put } from 'redux-saga/effects';
import getAngularService from '../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';

import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import {
    BreadcrumbItem,
    FolderPathService,
    MainNavigationItem,
    UiExtensionsService,
} from '../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import { getFolderOrWaitForIt } from '../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.saga';
import { DELIVERY_DETAILS_PATH } from './delivery-sidebar-provider';
import { DELIVERY_PATTERN_DETAILS_PATH } from '../../delivery-patterns/sidebar-provider/delivery-pattern-sidebar-provider';
import { DEFAULT_FOLDER_TAB } from '../../../../../../../../../core/xlr-ui/app/features/folders/folder-constants';

const { setSidebarMenu, setBackItem, updateBreadcrumbs, navigateTo } = navigation.actions;

export class FolderDeliveriesSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return (
            path.startsWith('/folders') && path.includes('/deliver') && !path.includes(DELIVERY_DETAILS_PATH) && !path.includes(DELIVERY_PATTERN_DETAILS_PATH)
        );
    }

    *provide(path: string) {
        const selectedFolder: Folder = yield call(getFolderOrWaitForIt);

        const uiExtensionsService: UiExtensionsService = yield call(getAngularService, 'UiExtensionsService');
        const folderTabs: MainNavigationItem[] = yield call(
            [uiExtensionsService, uiExtensionsService.getMenuItems],
            'xlrelease.sidebar.Folder',
            selectedFolder,
        );

        const deliveriesTabs = folderTabs.find((tab) => tab.id === 'xlrelease.sidebar.Folder.Deliveries')?.items;
        if (!deliveriesTabs) {
            // shouldn't happen
            return;
        }

        const folderSidebar = deliveriesTabs
            .filter((tab) => tab.permitted)
            .map((tab) => ({
                text: tab.label,
                startIconId: tab.icon,
                pathSuffix: `folders/${selectedFolder.id}/${tab.pathSuffix}`,
                selected: path.includes(tab.pathSuffix ?? ''),
                tabSuffix: tab.pathSuffix,
            }));

        const selectedTab = folderSidebar.find((s) => s.selected);
        if (selectedTab) {
            yield put(setSidebarMenu({ sidebarMenu: folderSidebar, withFolder: false }));
            yield put(
                setBackItem({
                    pathSuffix: `folders/${selectedFolder.id}/${DEFAULT_FOLDER_TAB}`,
                    title: selectedFolder.title,
                    text: selectedFolder.title,
                }),
            );

            const folderPathService: FolderPathService = yield call(getAngularService, 'FolderPathService');
            const parentFolders: Array<Folder> = yield call([folderPathService, folderPathService.getPathFromParentFolderId], selectedFolder.id);
            const folderBreadcrumbs: BreadcrumbItem[] = [];
            folderBreadcrumbs.push(...parentFolders.map((f) => ({ text: f.title, href: `/folders/${f.id}/${selectedTab.tabSuffix}` })));
            yield put(updateBreadcrumbs(folderBreadcrumbs));
        } else {
            yield put(navigateTo({ pathSuffix: folderSidebar[0].pathSuffix }));
        }
    }
}

registerSidebarProvider(new FolderDeliveriesSidebarProvider());
