import { useEffect, useRef } from 'react';

import IdsFactory from '../../../../../../../../../../../core/xlr-ui/app/js/util/ids';
import { TaskInputPropertyValue } from '../../../../../../../../../../../core/xlr-ui/app/types';

const Ids = IdsFactory();

export const isDeliveryStageId = (stageId?: string | null) => {
    if (!stageId) {
        return false;
    }
    const stageName = Ids.getName(stageId);
    return stageName.startsWith('Stage');
};

export const isDeliveryId = (deliveryId?: string | null) => {
    if (!deliveryId) {
        return false;
    }
    const deliveryName = Ids.getName(deliveryId);
    return deliveryName.startsWith('Delivery');
};

export const useCleanValueWhenChanged = (onChange: (inputValue: TaskInputPropertyValue) => void, dependencies: Array<string>) => {
    const mountedRef = useRef(false);

    useEffect(() => {
        if (mountedRef.current) {
            onChange(null);
        } else {
            mountedRef.current = true;
        }
    }, dependencies);
};
