import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Delivery } from '../types';

interface DeliveryTasksState {
    deliveriesOrPatterns: Array<Delivery>;
    deliveryOrPattern: Delivery | null;
    patterns: Array<Delivery>;
}

export interface LoadDeliveryOrPatternAction {
    id: string;
    isDelivery: boolean;
}

export interface SearchDeliveriesOrPatternsAction {
    isDelivery: boolean;
}

export const initialState: DeliveryTasksState = {
    deliveryOrPattern: null,
    deliveriesOrPatterns: [],
    patterns: [],
};

export const deliveryTasks = createSlice({
    name: 'deliveryTasks',
    initialState,
    reducers: {
        loadDeliveryOrPattern: (_state: DeliveryTasksState, _action: PayloadAction<LoadDeliveryOrPatternAction>) => noop(),
        searchDeliveriesOrPatterns: (_state: DeliveryTasksState, _action: PayloadAction<SearchDeliveriesOrPatternsAction>) => noop(),
        searchPatterns: (_state: DeliveryTasksState) => noop(),
        setDeliveryOrPattern: (state: DeliveryTasksState, action: PayloadAction<Delivery | null>) => {
            state.deliveryOrPattern = action.payload;
        },
        setDeliveriesOrPatterns: (state: DeliveryTasksState, action: PayloadAction<Array<Delivery>>) => {
            state.deliveriesOrPatterns = action.payload;
        },
        setPatterns: (state: DeliveryTasksState, action: PayloadAction<Array<Delivery>>) => {
            state.patterns = action.payload;
        },
    },
});

export const getDeliveryTasksState = (state: RootState) => state.deliveryTasks;
