/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import com.xebialabs.xlrelease.utils.ScopedTokenPermissionValidator$;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005\t}f\u0001B\u0010!\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!q\u0005A!b\u0001\n\u0007y\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011e\u0003!Q1A\u0005\u0004iC\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tg\u0002\u0011)\u0019!C\u0001i\"AQ\u0010\u0001B\u0001B\u0003%Q\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\t)\n\u0001C!\u0003/Cq!a'\u0001\t\u0003\ni\nC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0001\u0003\u0004!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011Y\u0004\u0001C!\u0005{AqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t5\u0004\u0001\"\u0011\u0003p!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u00119\n\u0001C\u0005\u00053\u0013QcU9m\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QEJ\u0001\tI\u0016d\u0017N^3ss*\u0011q\u0005K\u0001\nq2\u0014X\r\\3bg\u0016T!!\u000b\u0016\u0002\u0013a,'-[1mC\n\u001c(\"A\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kYj\u0011AI\u0005\u0003o\t\u0012!\u0003R3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\u0019B-\u001a7jm\u0016\u0014\u0018\u0010U3sg&\u001cH/\u001a8dKB\u0011!(P\u0007\u0002w)\u0011A\bI\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002?w\t\u0019B)\u001a7jm\u0016\u0014\u0018\u0010U3sg&\u001cH/\u001a8dK\u0006IB-\u001a7jm\u0016\u0014\u00180T3nE\u0016\u0014\b+\u001a:tSN$XM\\2f!\tQ\u0014)\u0003\u0002Cw\tIB)\u001a7jm\u0016\u0014\u00180T3nE\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003Y!(/Y2lK\u0012LE/Z7QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u001eF\u0013\t15H\u0001\fUe\u0006\u001c7.\u001a3Ji\u0016l\u0007+\u001a:tSN$XM\\2f\u0003Q\u0019\u0018\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feB\u0011\u0011\nT\u0007\u0002\u0015*\u0011\u0011e\u0013\u0006\u0003G\u0019J!!\u0014&\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0011M,7-\u001e:jifT!!\u0016\u0015\u0002\u0011\u0011,\u0007\u000f\\8zSRL!a\u0016*\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM]\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000fI\u0001\bI&\fG.Z2u+\u0005Y\u0006C\u0001/p\u001d\tiFN\u0004\u0002_U:\u0011q\f\u001b\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011d\u0013A\u0002\u001fs_>$h(C\u0001,\u0013\tI#&\u0003\u0002(Q%\u0011\u0011NJ\u0001\u0003I\nL!!I6\u000b\u0005%4\u0013BA7o\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003C-L!\u0001]9\u0003\u000f\u0011K\u0017\r\\3di*\u0011QN\\\u0001\tI&\fG.Z2uA\u0005\u0001B-Z2pe\u0006$xN]*feZL7-Z\u000b\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\tS:$XM\u001d8bY*\u0011!PJ\u0001\u0004CBL\u0017B\u0001?x\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\u0002#\u0011,7m\u001c:bi>\u00148+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003\u0003\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003k\u00012!a\u0001\u0001\u001b\u0005\u0001\u0003\"\u0002\u001d\f\u0001\u0004I\u0004\"B \f\u0001\u0004\u0001\u0005\"B\"\f\u0001\u0004!\u0005\"B$\f\u0001\u0004A\u0005\"\u0002(\f\u0001\b\u0001\u0006\"B-\f\u0001\bY\u0006\u0006CA\b\u0003'\ty#!\r\u0011\t\u0005U\u00111F\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005u\u0011qD\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\t#a\t\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u0015\u0012qE\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011\u0011F\u0001\u0004_J<\u0017\u0002BA\u0017\u0003/\u0011\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0005\u0005M\u0012a\u0006=meJ+\u0007o\\:ji>\u0014\u0018pU9m\t&\fG.Z2u\u0011\u0015\u00198\u00021\u0001v\u0003\u0011\u0011X-\u00193\u0015\t\u0005m\u0012\u0011\n\t\u0005\u0003{\t)%\u0004\u0002\u0002@)\u0019Q%!\u0011\u000b\u0007\u0005\rc%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u000f\nyD\u0001\u0005EK2Lg/\u001a:z\u0011\u001d\tY\u0005\u0004a\u0001\u0003\u001b\n!\u0002Z3mSZ,'/_%e!\u0011\ty%a\u0016\u000f\t\u0005E\u00131\u000b\t\u0003EBJ1!!\u00161\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000b\u0019)\u00071\ty\u0006\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)G\\\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002j\u0005\r$AC%t%\u0016\fGm\u00148ms\u0006qq-\u001a;Cs&#wJ\u001d+ji2,G\u0003BA\u001e\u0003_Bq!!\u001d\u000e\u0001\u0004\ti%A\teK2Lg/\u001a:z\u0013\u0012|%\u000fV5uY\u0016D3!DA0\u0003\u0019\u0019'/Z1uKR!\u0011\u0011PA@!\ry\u00131P\u0005\u0004\u0003{\u0002$\u0001B+oSRDa!\n\bA\u0002\u0005m\u0012AB;qI\u0006$X\r\u0006\u0003\u0002z\u0005\u0015\u0005BB\u0013\u0010\u0001\u0004\tY$\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003\u0017\u000b\t\nE\u00020\u0003\u001bK1!a$1\u0005\u001d\u0011un\u001c7fC:Dq!a\u0013\u0011\u0001\u0004\ti\u0005K\u0002\u0011\u0003?\na\u0001Z3mKR,G\u0003BA=\u00033Cq!a\u0013\u0012\u0001\u0004\ti%\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0011\u0003?\u000b\t,!2\u0002R\u0006m\u0017Q]Au\u0003w\u0004b!!)\u0002,\u0006mb\u0002BAR\u0003Os1AYAS\u0013\u0005\t\u0014bAAUa\u00059\u0001/Y2lC\u001e,\u0017\u0002BAW\u0003_\u00131aU3r\u0015\r\tI\u000b\r\u0005\b\u0003g\u0013\u0002\u0019AA[\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,A\u0003g_Jl7OC\u0002\u0002@f\f!A^\u0019\n\t\u0005\r\u0017\u0011\u0018\u0002\u0018\u0003\n\u001cHO]1di\u0012+G.\u001b<fef4\u0015\u000e\u001c;feNDq!a2\u0013\u0001\u0004\tI-\u0001\u0003qC\u001e,\u0007\u0003BAf\u0003\u001bl\u0011aS\u0005\u0004\u0003\u001f\\%\u0001\u0002)bO\u0016Dq!a5\u0013\u0001\u0004\t).A\u0004pe\u0012,'OQ=\u0011\t\u0005]\u0016q[\u0005\u0005\u00033\fILA\tEK2Lg/\u001a:z\u001fJ$WM]'pI\u0016Dq!!8\u0013\u0001\u0004\ty.\u0001\u0006qe&t7-\u001b9bYN\u0004b!!)\u0002b\u00065\u0013\u0002BAr\u0003_\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003O\u0014\u0002\u0019AAp\u0003\u001d\u0011x\u000e\\3JINDq!a;\u0013\u0001\u0004\ti/\u0001\tb]f|e\rU3s[&\u001c8/[8ogB1\u0011\u0011UAV\u0003_\u0004B!!=\u0002x6\u0011\u00111\u001f\u0006\u0004\u0003k\u0014\u0016A\u00039fe6L7o]5p]&!\u0011\u0011`Az\u0005)\u0001VM]7jgNLwN\u001c\u0005\n\u0003{\u0014\u0002\u0013!a\u0001\u0003\u0017\u000b!#\u001a8g_J\u001cW\rU3s[&\u001c8/[8og\"\u001a!#a\u0018\u0002!M,\u0017M]2iI\u0011,g-Y;mi\u0012:TC\u0001B\u0003U\u0011\tYIa\u0002,\u0005\t%\u0001\u0003\u0002B\u0006\u0005'i!A!\u0004\u000b\t\t=!\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00071\u0013\u0011\u0011)B!\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005tK\u0006\u00148\r[%egR!!1\u0004B\u000f!\u0019\t\t+a+\u0002N!9\u00111\u0017\u000bA\u0002\u0005U\u0006f\u0001\u000b\u0002`\u0005\u0011c-\u001b8e\t\u0016d\u0017N^3sS\u0016\u001c(+\u001a4fe\u0016t7-\u001b8h%\u0016dW-Y:f\u0013\u0012$BAa\u0007\u0003&!9!qE\u000bA\u0002\u00055\u0013!\u0003:fY\u0016\f7/Z%e\u0003\u001d2\u0017N\u001c3BGRLg/\u001a#fY&4XM]5fgJ+g-\u001a:f]\u000eLgn\u001a$pY\u0012,'/\u00133\u0015\t\t5\"Q\u0007\t\u0007\u0003C\u000bYKa\f\u0011\u0007i\u0012\t$C\u0002\u00034m\u0012QbQ5JI^KG\u000f\u001b+ji2,\u0007b\u0002B\u001c-\u0001\u0007\u0011QJ\u0001\tM>dG-\u001a:JI\"\u001aa#a\u0018\u00021\u0019Lg\u000e\u001a*fY\u0016\f7/Z:Cs\u0012+G.\u001b<fefLE\r\u0006\u0003\u0003@\t5\u0003CBAQ\u0003W\u0013\t\u0005\u0005\u0003\u0003D\t%SB\u0001B#\u0015\u0011\u00119%!0\u0002\u000bYLWm^:\n\t\t-#Q\t\u0002\u0018\t\u0016d\u0017N^3ss\u001acwn\u001e*fY\u0016\f7/Z%oM>Dq!a\u0013\u0018\u0001\u0004\ti\u0005K\u0002\u0018\u0003?\nA\u0002^8EK2Lg/\u001a:jKN$B!a(\u0003V!9!q\u000b\rA\u0002\te\u0013\u0001\u0002:poN\u0004b!!)\u0002,\nm\u0003c\u0001\u001e\u0003^%\u0019!qL\u001e\u0003\u0017\u0011+G.\u001b<fef\u0014vn^\u0001\u000bi>$U\r\\5wKJLHCBA\u001e\u0005K\u0012I\u0007C\u0004\u0003he\u0001\rAa\u0017\u0002\u0007I|w\u000fC\u0004\u0003le\u0001\rAa\u0007\u0002\u001b9,wOU3mK\u0006\u001cX-\u00133t\u000311\u0017N\u001c3G_2$WM]%e)\u0011\tiE!\u001d\t\u000f\u0005-#\u00041\u0001\u0002N!\u001a!$a\u0018\u0002%\u0019Lg\u000e\u001a)biR,'O\u001c\"z)&$H.\u001a\u000b\u0005\u0005s\u0012y\bE\u00030\u0005w\nY$C\u0002\u0003~A\u0012aa\u00149uS>t\u0007b\u0002BA7\u0001\u0007\u0011QJ\u0001\u0006i&$H.\u001a\u0015\u00047\u0005}\u0013A\f3fG>\u0014\u0018\r^3XSRDWI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=B]\u0012\u0004\u0016\r\u001e;fe:$U\r^1jYN$B!a(\u0003\n\"9!1\u0012\u000fA\u0002\u0005}\u0015A\u00033fY&4XM]5fg\u0006iQ.\u00199U_\u0012+G.\u001b<fef$BA!\u001f\u0003\u0012\"9!1S\u000fA\u0002\tU\u0015A\u00043fY&4XM]=S_^|\u0005\u000f\u001e\t\u0006_\tm$1L\u0001\u0015CJ,\u0017\n^3ng&sG+\u00192mK\u0016\u000bX/\u00197\u0015\r\u0005-%1\u0014BS\u0011\u001d\u0011iJ\ba\u0001\u0005?\u000bqa\u001c7e\u0013R,W\u000e\u0005\u0003\u0002>\t\u0005\u0016\u0002\u0002BR\u0003\u007f\u00111\u0002\u0016:bG.,G-\u0013;f[\"9!q\u0015\u0010A\u0002\t}\u0015a\u00028fo&#X-\u001c\u0015\u0004\u0001\t-\u0006\u0003BA1\u0005[KAAa,\u0002d\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eK\u0002\u0001\u0005g\u0003BA!.\u0003<6\u0011!q\u0017\u0006\u0005\u0005s\u000b\u0019#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!0\u00038\nQ!+\u001a9pg&$xN]=")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release delivery " + deliveryId + " not found", new Object[0]);
        });
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release delivery " + deliveryIdOrTitle + " not found", new Object[0]);
        });
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(originalDelivery.getTrackedItems()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala(), (Function1 & Serializable)x$1 -> x$1.getId(), (Function2 & Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.SetHasAsScala(originalDelivery.getReleaseIds()).asScala(), (Iterable)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, scala.collection.immutable.Seq<Permission> anyOfPermissions, boolean enforcePermissions) {
        scala.collection.immutable.Seq<DeliveryRow> seq;
        scala.collection.immutable.Seq<Permission> permissions;
        if (!enforcePermissions || this.permissionEnforcer().isCurrentUserAdmin() || this.permissionEnforcer().hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL})) {
            v0 = (scala.collection.immutable.Seq<Permission>)package$.MODULE$.Seq().empty();
        } else {
            ScopedTokenPermissionValidator$.MODULE$.checkPermissionSupportedinScopedToken(anyOfPermissions);
            v0 = permissions = anyOfPermissions;
        }
        if (filters.hasStatuses()) {
            String string;
            DeliverySqlBuilder deliverySqlBuilder = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withTrackedItemTitleLike(filters.getTrackedItemTitle(), filters.isStrictTrackedItemTitleMatch()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).withPermissions(permissions, principals, roleIds);
            AbstractDeliveryFilters abstractDeliveryFilters = filters;
            if (abstractDeliveryFilters instanceof DeliveryFilters) {
                DeliveryFilters deliveryFilters = (DeliveryFilters)abstractDeliveryFilters;
                string = deliveryFilters.getOriginPatternId();
            } else {
                string = null;
            }
            Tuple2 sqlWithParams = deliverySqlBuilder.withOriginPatternId(string).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        } else {
            seq = (scala.collection.immutable.Seq<DeliveryRow>)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<DeliveryRow> deliveryRows = seq;
        scala.collection.immutable.Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        if (this.permissionEnforcer().isCurrentUserAdmin() || this.permissionEnforcer().hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL})) {
            return deliveries;
        }
        return this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    public boolean search$default$7() {
        return true;
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).build();
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).map((Function1 & Serializable)x$4 -> x$4.domainId());
    }

    @Override
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false));
    }

    private scala.collection.immutable.Seq<Delivery> toDeliveries(scala.collection.immutable.Seq<DeliveryRow> rows) {
        Map<Object, scala.collection.immutable.Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)rows.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()))));
        return (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
    }

    private Delivery toDelivery(DeliveryRow row, scala.collection.immutable.Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content());
        Option option = deliveryOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Delivery delivery = (Delivery)some.value();
            delivery.setFolderId(row.folderId().absolute());
            Set mergedReleaseIds = (Set)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().map((Function1 & Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable)() -> oldId));
            delivery.setReleaseIds(new HashSet(CollectionConverters$.MODULE$.MutableSetHasAsJava(mergedReleaseIds).asJava()));
            return delivery;
        }
        if (None$.MODULE$.equals(option)) {
            throw new LogFriendlyNotFoundException("Error reading release delivery " + row.ciUid() + ", see logs for more details", new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    @Override
    @IsReadOnly
    public Option<Delivery> findPatternByTitle(String title) {
        return this.mapToDelivery(this.deliveryPersistence.findPatternByTitle(title));
    }

    private scala.collection.immutable.Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(scala.collection.immutable.Seq<Delivery> deliveries) {
        return (scala.collection.immutable.Seq)deliveries.map((Function1 & Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS(), (List)Nil$.MODULE$))).asJava());
            return delivery;
        });
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable)delivery -> (Delivery)this.decorateWithEffectiveSecurityAndPatternDetails((scala.collection.immutable.Seq<Delivery>)new .colon.colon(delivery, (List)Nil$.MODULE$)).head());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

