package com.xebialabs.xlrelease.delivery.transition.condition.time

import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService
import com.xebialabs.xlrelease.repository.Ids
import grizzled.slf4j.Logging
import org.quartz.{Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class TimeConditionQuartzJob extends Job with Logging {

  @Autowired
  var deliveryActorService: DeliveryActorService = _

  override def execute(context: JobExecutionContext): Unit = {
    val jobKey = context.getJobDetail.getKey
    val conditionId = jobKey.getName
    logger.debug(s"Quartz trigger for schedule ${context.getTrigger.getStartTime} and condition '$conditionId' has fired")

    Try {
      deliveryActorService.markConditionAsSatisfied(Ids.deliveryIdFrom(conditionId), conditionId)
    } match {
      case Failure(ex) => logger.error(s"Error marking fixed date condition '$conditionId' as satisfied", ex)
      case Success(_) => logger.debug(s"Quartz trigger processing finished")
    }

  }

}
