package com.xebialabs.xlrelease.delivery.service

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.security.RoleService
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator
import com.xebialabs.xlrelease.domain.delivery.Delivery
import com.xebialabs.xlrelease.domain.{CiWithInternalMetadata, Team}
import com.xebialabs.xlrelease.service.TeamService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class DeliverySecurityDecorator @Autowired()(roleService: RoleService,
                                                 teamService: TeamService)
  extends EffectiveSecurityDecorator(roleService, teamService) {

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[Delivery]

  override def getEffectiveTeams(container: CiWithInternalMetadata): Seq[Team] = {
    container match {
      case delivery: Delivery =>
        teamService.getEffectiveTeams(delivery.getFolderId).asScala.toSeq
      case _ => Seq.empty[Team]
    }
  }
}
