import { call, put, select } from 'redux-saga/effects';
import getAngularService from '../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';

import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { MainNavigationItem, UiExtensionsService } from '../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { Delivery } from '../../Tasks/js/components/types';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { BaseSidebarProvider } from '../../sidebar-provider/base-sidebar-provider';

const { setSidebarMenu, setBackItem } = navigation.actions;

export const selectDelivery = (state: RootState) => state.deliveryFlow.delivery;
export const DELIVERY_DETAILS_PATH = '/deliveries/Deliveries/';
export class DeliverySidebarProvider extends BaseSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.includes(DELIVERY_DETAILS_PATH);
    }

    *provide(path: string) {
        const delivery: Delivery = yield select(selectDelivery);
        const uiExtensionsService: UiExtensionsService = yield call(getAngularService, 'UiExtensionsService');
        const deliveryItems: MainNavigationItem[] = yield call([uiExtensionsService, uiExtensionsService.getMenuItems], 'xlrelease.DeliveryPageMenu', delivery);

        const sidebarMenu = deliveryItems
            .filter(({ permitted }) => permitted)
            .map(({ pathSuffix, label, weight, icon = 'file' }) => ({
                pathSuffix: this.fixPath(`deliveries/${delivery.id}/${pathSuffix}`),
                text: label,
                startIconId: icon,
                weight,
                selected: this.checkIfSelected(path, pathSuffix),
            }));

        yield put(setSidebarMenu({ sidebarMenu, withFolder: false }));
        yield put(
            setBackItem({
                pathSuffix: `folders/${delivery.folderId}/deliveries`,
                title: 'deliveries',
                text: delivery.title,
            }),
        );
    }
}

registerSidebarProvider(new DeliverySidebarProvider());
