import React from 'react';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { InputWithFolder } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-folder/input-with-folder.component';
import { useAppSelector } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getFolders } from '../../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.selectors';
import { findFolder } from '../../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.reducer';
import { TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { getPropertyFromInputProperties } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/helper/task.helper';
import { StringWithVariables } from './string-with-variables.component';
import './folder.component.less';

export const FolderWithVariables = (props: TaskInputCommonProps) => {
    return (
        <StringWithVariables {...props}>
            <FolderAutocomplete {...props} />
        </StringWithVariables>
    );
};

const FolderAutocomplete = ({ disabled, expanded, onChange, property, task }: TaskInputCommonProps) => {
    const folders = useAppSelector(getFolders);

    const selectedFolderId = getPropertyFromInputProperties(task, property.name) as string | undefined;
    let error = false;
    let selectedFolder: Folder | undefined = selectedFolderId ? (findFolder({ id: selectedFolderId }, folders) as Folder) : undefined;

    // we have folder selected but we couldn't find it
    if (selectedFolderId && !selectedFolder) {
        selectedFolder = {
            id: selectedFolderId,
            title: selectedFolderId,
        };
        error = true;
    }

    const handleFolderChange = (folder?: Folder) => {
        onChange(folder ? folder.id : null);
    };

    return (
        <div className="folder-autocomplete">
            <InputWithFolder
                description={error ? `You do not have permissions to view the selected folder or it doesn't exist` : property.description}
                disabled={disabled}
                error={error}
                isFolderFullWidth={expanded}
                label={property.label}
                onChange={handleFolderChange}
                required={property.required}
                value={selectedFolder}
            />
        </div>
    );
};
