package com.xebialabs.xlrelease.delivery.service

import com.xebialabs.xlrelease.delivery.activity.DeliveryActivity
import com.xebialabs.xlrelease.domain.ActivityCategory.{DELIVERY_EDIT, IMPORTANT, LIFECYCLE, OTHER}
import com.xebialabs.xlrelease.domain.{ActivityCategory, ActivityLogEntry}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.service.{BaseActivityLogsService, UserInfoResolver}
import com.xebialabs.xlrelease.views.LogsFilters
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.domain.Pageable
import org.springframework.stereotype.Service

import java.util
import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters._

@Service
class DeliveryActivityLogsService @Autowired()(userInfoResolver: UserInfoResolver,
                                               val activityLogRepository: ActivityLogRepository
                                              ) extends BaseActivityLogsService(userInfoResolver) {
  private lazy val deliveryActivityOps: util.List[DeliveryActivity] = DeliveryActivity.values().toList.asJava

  override def withCategories(logEntry: ActivityLogEntry, filters: LogsFilters): Boolean = {
    val allowedCategories = ListBuffer.empty[ActivityCategory]
    if (filters.withImportant) allowedCategories += IMPORTANT
    if (filters.withLifecycle) allowedCategories += LIFECYCLE
    if (filters.withDeliveryEdit) allowedCategories += DELIVERY_EDIT
    if (filters.withOther) allowedCategories += OTHER

    val activityCategories = DeliveryActivity.safeValueOf(logEntry.getActivityType).getCategories.asScala
    allowedCategories exists activityCategories
  }

  override def fetchLogs(containerId: String, logsFilters: LogsFilters, pageable: Pageable): List[ActivityLogEntry] = {
    activityLogRepository.findAllLogsOf(containerId, logsFilters, deliveryActivityOps, pageable).asScala.toList
  }
}
