/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Statics;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\r%h\u0001B\u001d;\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005%\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003\\\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011%\u0004!Q1A\u0005\u0002)D\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t_\u0002\u0011)\u0019!C\u0001a\"Aq\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005y\u0001\t\u0015\r\u0011\"\u0001z\u0011!i\bA!A!\u0002\u0013Q\b\u0002\u0003@\u0001\u0005\u000b\u0007I\u0011A@\t\u0015\u0005E\u0001A!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u0014\u0001\u0011)\u0019!C\u0001\u0003+A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003\u000b\u0004A\u0011AAh\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002r\u0002!\t!a=\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002\"\u0003B)\u0001E\u0005I\u0011\u0001B*\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqAa\u001e\u0001\t\u0003\u0011I\bC\u0005\u0003\u001a\u0002\t\n\u0011\"\u0001\u0003\u001c\"9!q\u0014\u0001\u0005\u0002\t\u0005\u0006b\u0002B<\u0001\u0011\u0005!q\u0017\u0005\b\u0005\u0003\u0004A\u0011\u0001Bb\u0011%\u0011y\rAI\u0001\n\u0003\u0011\u0019\u0006C\u0004\u0003R\u0002!\tAa5\t\u000f\tu\u0007\u0001\"\u0001\u0003`\"9!Q\u001c\u0001\u0005\u0002\tM\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0005{\u0004A\u0011AB\u0004\u0011\u001d\u0019y\u0001\u0001C\u0001\u0007#Aqaa\u0007\u0001\t\u0013\u0019i\u0002C\u0004\u00048\u0001!Ia!\u000f\t\u000f\ru\u0002\u0001\"\u0001\u0004@!91Q\b\u0001\u0005\u0002\r\r\u0003bBB&\u0001\u0011\u00051Q\n\u0005\b\u0007#\u0002A\u0011BB*\u0011\u001d\u0019\t\u0007\u0001C\u0005\u0007GBqaa\u001a\u0001\t\u0003\u0019I\u0007C\u0005\u0004r\u0001\t\n\u0011\"\u0001\u0003T!911\u000f\u0001\u0005\n\rU\u0004bBBB\u0001\u0011%1Q\u0011\u0005\b\u0007\u007f\u0003A\u0011BBa\u0011%\u0019I\rAI\u0001\n\u0013\u0019Y\rC\u0004\u0004P\u0002!\tf!5\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:\u001cVM\u001d<jG\u0016T!a\u000f\u001f\u0002\u000fM,'O^5dK*\u0011QHP\u0001\tI\u0016d\u0017N^3ss*\u0011q\bQ\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0011\"\u0002\u0013a,'-[1mC\n\u001c(\"A\"\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011E\n\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001b:k\u0011AO\u0005\u0003\u001fj\u0012A\u0003R3mSZ,'/_*feZL7-Z+uS2\u001c\u0018A\u00053fY&4XM]=SKB|7/\u001b;pef,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+r\n!B]3q_NLGo\u001c:z\u0013\t9FK\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018a\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t1\f\u0005\u0002]=6\tQL\u0003\u0002V}%\u0011q,\u0018\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001d!\t!g-D\u0001f\u0015\tYd(\u0003\u0002hK\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002WB\u0011A\r\\\u0005\u0003[\u0016\u00141bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AOP\u0001\u0003I\nL!A^:\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u0005iam\u001c7eKJ\u001cVM\u001d<jG\u0016,\u0012A\u001f\t\u0003InL!\u0001`3\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u000391w\u000e\u001c3feN+'O^5dK\u0002\n1B]8mKN+'O^5dKV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003!\u0019XmY;sSRL(bAA\u0006\u0001\u0006AA-\u001a9m_fLG/\u0003\u0003\u0002\u0010\u0005\u0015!a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fAB]8mKN+'O^5dK\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;q\u0014AB3wK:$8/\u0003\u0003\u0002\"\u0005m!!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011\b\t\u0003\u001b\u0002AQ\u0001U\tA\u0002ICQ!W\tA\u0002mCQ!Y\tA\u0002\rDQ![\tA\u0002-DQa\\\tA\u0002EDQ\u0001_\tA\u0002iDaA`\tA\u0002\u0005\u0005\u0001bBA\n#\u0001\u0007\u0011q\u0003\u0015\u0004#\u0005u\u0002\u0003BA \u0003+j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u000bC:tw\u000e^1uS>t'\u0002BA$\u0003\u0013\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002L\u00055\u0013!\u00022fC:\u001c(\u0002BA(\u0003#\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003'\n1a\u001c:h\u0013\u0011\t9&!\u0011\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AC4fiB\u000bG\u000f^3s]R!\u0011QLA6!\u0011\ty&a\u001a\u000e\u0005\u0005\u0005$bA\u001f\u0002d)\u0019\u0011Q\r \u0002\r\u0011|W.Y5o\u0013\u0011\tI'!\u0019\u0003\u0011\u0011+G.\u001b<fefDq!!\u001c\u0013\u0001\u0004\ty'A\u0005qCR$XM\u001d8JIB!\u0011\u0011OA@\u001d\u0011\t\u0019(a\u001f\u0011\u0007\u0005U\u0004*\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010#\u0002\rq\u0012xn\u001c;?\u0013\r\ti\bS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00151\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0004\nK\u0002\u0013\u0003\u000f\u0003B!!#\u0002\u001a6\u0011\u00111\u0012\u0006\u0005\u0003\u0007\niI\u0003\u0003\u0002\u0010\u0006E\u0015\u0001B2pe\u0016TA!a%\u0002\u0016\u0006QQ.[2s_6,G/\u001a:\u000b\u0005\u0005]\u0015AA5p\u0013\u0011\tY*a#\u0003\u000bQKW.\u001a3\u0002+\u001d,G\u000fU1ui\u0016\u0014hNQ=JI>\u0013H+\u001b;mKR!\u0011QLAQ\u0011\u001d\t\u0019k\u0005a\u0001\u0003_\n\u0001\u0003]1ui\u0016\u0014h.\u00133PeRKG\u000f\\3)\u0007M\t9)\u0001\ffq&\u001cHo\u001d)biR,'O\\,ji\"$\u0016\u000e\u001e7f)\u0019\tY+!-\u00026B\u0019q)!,\n\u0007\u0005=\u0006JA\u0004C_>dW-\u00198\t\u000f\u0005MF\u00031\u0001\u0002p\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003o#\u0002\u0019AA8\u0003\u0015!\u0018\u000e\u001e7fQ\r!\u0012qQ\u0001\u000eKbL7\u000f^:QCR$XM\u001d8\u0015\t\u0005-\u0016q\u0018\u0005\b\u0003\u0003,\u0002\u0019AA8\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004+\u0005\u001d\u0015!F2sK\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003;\nI\rC\u0004\u0002LZ\u0001\r!!\u0018\u0002\u000fA\fG\u000f^3s]\"\u001aa#a\"\u0015\r\u0005u\u0013\u0011[Aj\u0011\u001d\tYm\u0006a\u0001\u0003;Bq!!6\u0018\u0001\u0004\tY+\u0001\ntQ>,H\u000e\u001a*fg\u0016$\b+\u0019;uKJt\u0007fA\f\u0002\b\u0006)R\u000f\u001d3bi\u0016$U\r\\5wKJL\b+\u0019;uKJtG\u0003BA/\u0003;Dq!a8\u0019\u0001\u0004\ti&A\u0004va\u0012\fG/\u001a3)\u0007a\t9)A\u000beK2,G/\u001a#fY&4XM]=QCR$XM\u001d8\u0015\t\u0005\u001d\u0018Q\u001e\t\u0004\u000f\u0006%\u0018bAAv\u0011\n!QK\\5u\u0011\u001d\ti'\u0007a\u0001\u0003_B3!GAD\u0003a!W\u000f\u001d7jG\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0007\u0003;\n)0a>\t\u000f\u00055$\u00041\u0001\u0002p!9\u0011\u0011 \u000eA\u0002\u0005m\u0018A\u00029be\u0006l7\u000f\u0005\u0003\u0002~\n-QBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u000b\u0019|'/\\:\u000b\t\t\u0015!qA\u0001\u0003mFR1A!\u0003?\u0003\r\t\u0007/[\u0005\u0005\u0005\u001b\tyP\u0001\rEkBd\u0017nY1uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:D3AGAD\u0003e\u0019'/Z1uK\u0012+G.\u001b<fef4%o\\7QCR$XM\u001d8\u0015\r\u0005u#Q\u0003B\f\u0011\u001d\tig\u0007a\u0001\u0003_BqA!\u0007\u001c\u0001\u0004\u0011Y\"\u0001\u0006qCJ\fW.\u001a;feN\u0004B!!@\u0003\u001e%!!qDA\u0000\u00059\u0019%/Z1uK\u0012+G.\u001b<fefD3aGAD\u00039\u0019X-\u0019:dQB\u000bG\u000f^3s]N$\u0002Ba\n\u00038\t\u0005#1\n\t\u0007\u0005S\u0011\u0019$!\u0018\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\tA!\u001e;jY*\u0011!\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00036\t-\"\u0001\u0002'jgRDqA!\u000f\u001d\u0001\u0004\u0011Y$A\u0004gS2$XM]:\u0011\t\u0005u(QH\u0005\u0005\u0005\u007f\tyP\u0001\fEK2Lg/\u001a:z!\u0006$H/\u001a:o\r&dG/\u001a:t\u0011\u001d\u0011\u0019\u0005\ba\u0001\u0005\u000b\nA\u0001]1hKB\u0019ALa\u0012\n\u0007\t%SL\u0001\u0003QC\u001e,\u0007\"\u0003B'9A\u0005\t\u0019AAV\u0003I)gNZ8sG\u0016\u0004VM]7jgNLwN\\:)\u0007q\t9)\u0001\rtK\u0006\u00148\r\u001b)biR,'O\\:%I\u00164\u0017-\u001e7uIM*\"A!\u0016+\t\u0005-&qK\u0016\u0003\u00053\u0002BAa\u0017\u0003d5\u0011!Q\f\u0006\u0005\u0005?\u0012\t'A\u0005v]\u000eDWmY6fI*\u0019\u00111\t%\n\t\t\u0015$Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!C4fiN#\u0018mZ3t)\u0011\u0011YGa\u001d\u0011\r\t%\"1\u0007B7!\u0011\tyFa\u001c\n\t\tE\u0014\u0011\r\u0002\u0006'R\fw-\u001a\u0005\b\u0003[r\u0002\u0019AA8Q\rq\u0012qQ\u0001\tC\u0012$7\u000b^1hKRA!Q\u000eB>\u0005{\u0012\t\tC\u0004\u0002n}\u0001\r!a\u001c\t\u000f\t}t\u00041\u0001\u0003n\u0005)1\u000f^1hK\"I!1Q\u0010\u0011\u0002\u0003\u0007!QQ\u0001\ta>\u001c\u0018\u000e^5p]B1!\u0011\u0006BD\u0005\u0017KAA!#\u0003,\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0003\u000e\nMUB\u0001BH\u0015\u0011\u0011\tJa\f\u0002\t1\fgnZ\u0005\u0005\u0005+\u0013yIA\u0004J]R,w-\u001a:)\u0007}\t9)\u0001\nbI\u0012\u001cF/Y4fI\u0011,g-Y;mi\u0012\u001aTC\u0001BOU\u0011\u0011)Ia\u0016\u0002\u001f\u0005$Gm\u0015;bO\u0016\u0014U\r^<fK:$\"B!\u001c\u0003$\n\u0015&q\u0015BY\u0011\u001d\ti'\ta\u0001\u0003_BqAa \"\u0001\u0004\u0011i\u0007C\u0004\u0003*\u0006\u0002\rAa+\u0002\r\t,gm\u001c:f!\u00159%QVA8\u0013\r\u0011y\u000b\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tM\u0016\u00051\u0001\u0003,\u0006)\u0011M\u001a;fe\"\u001a\u0011%a\"\u0015\u0011\t5$\u0011\u0018B^\u0005{Cq!a3#\u0001\u0004\ti\u0006C\u0004\u0003\u0000\t\u0002\rA!\u001c\t\u000f\t\r%\u00051\u0001\u0003\u0006\"\u001a!%a\"\u0002\u0017U\u0004H-\u0019;f'R\fw-\u001a\u000b\t\u0005[\u0012)Ma2\u0003J\"9\u0011QN\u0012A\u0002\u0005=\u0004bBApG\u0001\u0007!Q\u000e\u0005\n\u0005\u0017\u001c\u0003\u0013!a\u0001\u0003W\u000b\u0011B\u001a:p[\n\u000bGo\u00195)\u0007\r\n9)A\u000bva\u0012\fG/Z*uC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017\u0011,G.\u001a;f'R\fw-\u001a\u000b\u0007\u0003O\u0014)Na6\t\u000f\u00055T\u00051\u0001\u0002p!9!\u0011\\\u0013A\u0002\u0005=\u0014aB:uC\u001e,\u0017\n\u001a\u0015\u0004K\u0005\u001d\u0015!D1eIR\u0013\u0018M\\:ji&|g\u000e\u0006\u0005\u0003b\n\u001d(\u0011\u001eBw!\u0011\tyFa9\n\t\t\u0015\u0018\u0011\r\u0002\u000b)J\fgn]5uS>t\u0007bBA7M\u0001\u0007\u0011q\u000e\u0005\b\u0005W4\u0003\u0019AA8\u00039\u0019H/Y4f\u0013\u0012|%\u000fV5uY\u0016DqAa<'\u0001\u0004\u0011\t/\u0001\u0006ue\u0006t7/\u001b;j_:D3AJAD)!\u0011\tO!>\u0003x\ne\bbBAfO\u0001\u0007\u0011Q\f\u0005\b\u0005W<\u0003\u0019AA8\u0011\u001d\u0011yo\na\u0001\u0005CD3aJAD\u0003A)\b\u000fZ1uKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0003b\u000e\u000511\u0001\u0005\b\u0003[B\u0003\u0019AA8\u0011\u001d\ty\u000e\u000ba\u0001\u0005CD3\u0001KAD)\u0019\u0011\to!\u0003\u0004\f!9\u00111Z\u0015A\u0002\u0005u\u0003bBApS\u0001\u0007!\u0011\u001d\u0015\u0004S\u0005\u001d\u0015\u0001\u00053fY\u0016$X\r\u0016:b]NLG/[8o)\u0019\t9oa\u0005\u0004\u0016!9\u0011Q\u000e\u0016A\u0002\u0005=\u0004bBB\fU\u0001\u0007\u0011qN\u0001\riJ\fgn]5uS>t\u0017\n\u001a\u0015\u0004U\u0005\u001d\u0015\u0001G4f]\u0016\u0014\u0018\r^3USRdW-\u00134OK\u000e,7o]1ssR1\u0011q]B\u0010\u0007CAqAa ,\u0001\u0004\u0011i\u0007C\u0004\u0004$-\u0002\ra!\n\u0002\rM$\u0018mZ3t!\u0019\u00199c!\r\u0003n9!1\u0011FB\u0017\u001d\u0011\t)ha\u000b\n\u0003%K1aa\fI\u0003\u001d\u0001\u0018mY6bO\u0016LAaa\r\u00046\t\u00191+Z9\u000b\u0007\r=\u0002*\u0001\bdQ\u0016\u001c7.S:QCR$XM\u001d8\u0015\t\u0005\u001d81\b\u0005\u0007{1\u0002\r!!\u0018\u0002\u001fY\fG.\u001b3bi\u0016\u0004\u0016\r\u001e;fe:$B!a:\u0004B!1Q(\fa\u0001\u0003;\"b!a:\u0004F\r\u001d\u0003BB\u001f/\u0001\u0004\ti\u0006C\u0004\u0004J9\u0002\r!a+\u0002\u0017]LG\u000f[)vKJLWm]\u0001%m\u0006d\u0017\u000eZ1uKN#\u0018mZ3t\u0003:$GK]1og&$\u0018n\u001c8t\u0003:$\u0017\n^3ngR!\u0011q]B(\u0011\u001d\tYm\fa\u0001\u0003;\n\u0001C^1mS\u0012\fG/\u001a(foN#\u0018mZ3\u0015\u0011\u0005\u001d8QKB,\u00073Bqaa\t1\u0001\u0004\u0019)\u0003C\u0004\u0003\u0000A\u0002\rA!\u001c\t\u000f\t\r\u0005\u00071\u0001\u0004\\A\u0019qi!\u0018\n\u0007\r}\u0003JA\u0002J]R\fqC^1mS\u0012\fG/Z*uC\u001e,\u0007K]8qKJ$\u0018.Z:\u0015\t\u0005\u001d8Q\r\u0005\b\u0005\u007f\n\u0004\u0019\u0001B7\u00031\u0011Xm]3u!\u0006$H/\u001a:o)\u0019\t9oa\u001b\u0004n!9\u00111\u001a\u001aA\u0002\u0005u\u0003\"CB8eA\u0005\t\u0019AAV\u0003-1wN]2f\u001d\u0016<\u0018\nZ:\u0002-I,7/\u001a;QCR$XM\u001d8%I\u00164\u0017-\u001e7uII\naB]3tKR\u001cuN\u001c3ji&|g\u000e\u0006\u0004\u0002h\u000e]4\u0011\u0010\u0005\b\u0005_$\u0004\u0019\u0001Bq\u0011\u001d\u0019Y\b\u000ea\u0001\u0007{\n\u0011bY8oI&$\u0018n\u001c8\u0011\t\u0005}3qP\u0005\u0005\u0007\u0003\u000b\tGA\u0005D_:$\u0017\u000e^5p]\u0006\u0011r-\u001a8fe\u0006$Xm\u0014:Va\u0012\fG/Z%e+\u0011\u00199ia(\u0015\u0015\r%5\u0011WB[\u0007s\u001bi\f\u0006\u0003\u0002p\r-\u0005\"CBGk\u0005\u0005\t9ABH\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0007#\u001b9ja'\u000e\u0005\rM%bABK\u0011\u00069!/\u001a4mK\u000e$\u0018\u0002BBM\u0007'\u0013\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0007;\u001by\n\u0004\u0001\u0005\u000f\r\u0005VG1\u0001\u0004$\n\tA+\u0005\u0003\u0004&\u000e-\u0006cA$\u0004(&\u00191\u0011\u0016%\u0003\u000f9{G\u000f[5oOB\u0019qi!,\n\u0007\r=\u0006JA\u0002B]fDqaa-6\u0001\u0004\ty'\u0001\u0006fq&\u001cH/\u001b8h\u0013\u0012Dqaa.6\u0001\u0004\ty'A\u0006pY\u0012\u0004\u0016M]3oi&#\u0007bBB^k\u0001\u0007\u0011qN\u0001\f]\u0016<\b+\u0019:f]RLE\rC\u0004\u0004pU\u0002\r!a+\u0002)\u0005d'/Z1es\u0016C\u0018n\u001d;t\u0005f$\u0016\u000e\u001e7f)\u0019\tYka1\u0004H\"91Q\u0019\u001cA\u0002\u0005=\u0014\u0001\u00049biR,'O\u001c+ji2,\u0007\"CA7mA\u0005\t\u0019AA8\u0003y\tGN]3bIf,\u00050[:ug\nKH+\u001b;mK\u0012\"WMZ1vYR$#'\u0006\u0002\u0004N*\"\u0011q\u000eB,\u0003A\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0004\u0002h\u000eM7q\u001b\u0005\b\u0007+D\u0004\u0019AA/\u0003A)\u00070[:uS:<G)\u001a7jm\u0016\u0014\u0018\u0010C\u0005\u0004Zb\u0002\n\u00111\u0001\u0002p\u00051\u0011m\u0019;j_:D3\u0001ABo!\u0011\u0019yn!:\u000e\u0005\r\u0005(\u0002BBr\u0003\u001b\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00199o!9\u0003\u000fM+'O^5dK\u0002")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public Delivery getPattern(String patternId) {
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return pattern;
    }

    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return pattern;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        return this.createDeliveryPattern(pattern, true);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern, boolean shouldResetPattern) {
        Checks.checkNotNull((Object)pattern, (String)"Release delivery");
        this.logger().debug((Function0 & Serializable)() -> "Creating new delivery pattern '" + pattern + "'");
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        if (shouldResetPattern) {
            this.resetPattern(pattern, this.resetPattern$default$2());
        }
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating delivery pattern '" + updated + "'");
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting release delivery pattern '" + patternId + "'");
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable)() -> "Duplicating delivery pattern '" + patternId + "' with parameters '" + params + "'");
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$"));
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])c))).length() == pattern.getTitle().length()) {
                pattern.setTitle(pattern.getTitle() + " (0)");
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1)));
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), "(" + Integer.toString(++orderNumber) + ")");
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable)() -> "Creating new delivery from pattern '" + patternId + "' with parameters '" + parameters + "'");
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        delivery.setAutoComplete(parameters.isAutoComplete());
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable)event -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, event);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public java.util.List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page, boolean enforcePermissions) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search((AbstractDeliveryFilters)filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (scala.collection.immutable.Seq<Permission>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())), enforcePermissions)).asJava();
    }

    public boolean searchPatterns$default$3() {
        return true;
    }

    @Timed
    public java.util.List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) == BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) {
                    return this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                }
                throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
            }
            if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) == 0) {
                return this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
        }
        if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) == pattern.getStages().size() - 1) {
                return this.addStage(pattern, stage, Optional.empty());
            }
            throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
        }
        if (pattern.getStages().isEmpty()) {
            return this.addStage(pattern, stage, Optional.empty());
        }
        throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable)() -> "Adding new stage '" + stage + "' to pattern '" + pattern.getId() + "'");
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        this.generateTitleIfNecessary(stage, (scala.collection.immutable.Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((scala.collection.immutable.Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated, boolean fromBatch) {
        this.logger().debug((Function0 & Serializable)() -> "Updating stage '" + updated + "' on pattern '" + patternId + "'");
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        Stage originalBeforeChanges = (Stage)CiCloneHelper.cloneCi((ConfigurationItem)original);
        if (!fromBatch) {
            this.validateNewStage((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)stages.diff((Seq)new .colon.colon((Object)original, (List)Nil$.MODULE$))), updated, stages.indexOf((Object)original));
        }
        original.setTitle(updated.getTitle());
        original.setOwner(updated.getOwner());
        original.setTeam(updated.getTeam());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(originalBeforeChanges, original, pattern));
        return original;
    }

    public boolean updateStage$default$3() {
        return false;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> "Removing stage '" + stageId + "' from pattern '" + patternId + "'");
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable)() -> "Adding new transition '" + transition + "' to pattern '" + pattern.getId() + "'");
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)x$2));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating transition '" + updated + "' on pattern '" + pattern.getId() + "'");
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)x$3));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable)() -> "Removing transition '" + transitionId + "' from pattern '" + patternId + "'");
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, scala.collection.immutable.Seq<Stage> stages) {
        Checks.checkNotNull((Object)stage, (String)"Stage");
        if (stage.getTitle() == null) {
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
            return;
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)(delivery.getId() + " must be a Delivery Pattern"), (Object[])new Object[0]);
    }

    public void validatePattern(Delivery delivery) {
        this.validatePattern(delivery, true);
    }

    public void validatePattern(Delivery delivery, boolean withQueries) {
        this.validate(delivery, withQueries);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        if (withQueries) {
            Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)("Pattern with title '" + delivery.getTitle() + "' already exists"), (Object[])new Object[0]);
            return;
        }
    }

    public void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)stage);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTitle());
        Buffer duplicateStages = (Buffer)((SeqOps)stageTitles.diff((Seq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)("Stages with duplicate titles [" + duplicateStages.mkString(", ") + "] are not allowed in pattern"), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getTrackedItems()).asScala().map((Function1 & Serializable)x$6 -> x$6.getTitle().toLowerCase());
        Buffer duplicateItems = (Buffer)((SeqOps)trackedItemTitles.diff((Seq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)("Tracked items with duplicate titles [" + duplicateItems.mkString(", ") + "] are not allowed in pattern"), (Object[])new Object[0]);
    }

    private void validateNewStage(scala.collection.immutable.Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)stage, (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)("Title must not contain reserved character " + DbConstants$.MODULE$.ESCAPE_CHAR()), (Object[])new Object[0]);
    }

    public void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    public boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        boolean idNotDefined;
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean bl = idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        if (forceNewIds || idNotDefined) {
            return this.factory().createUniqueId(newParentId, evidence$1);
        }
        return existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds((AbstractDeliveryFilters)filters).exists((Function1 & Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent event) {
        $this.eventBus().publish(event);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pattern$2.getStages()).asScala().zipWithIndex()).find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        if (index$1.elem > 0) {
            return "New Stage (" + index$1.elem + ")";
        }
        return "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

