/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryDeletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rba\u0002\u0010 !\u0003\r\tA\u000b\u0005\u0006s\u0001!\tA\u000f\u0005\b}\u0001\u0011\rQ\"\u0001@\u0011\u001d1\u0005A1A\u0007\u0002\u001dCqA\u0014\u0001C\u0002\u001b\u0005q\nC\u0004V\u0001\t\u0007i\u0011\u0001,\t\u000fu\u0003!\u0019!D\u0001=\"9!\r\u0001b\u0001\u000e\u0003\u0019\u0007b\u00027\u0001\u0005\u00045\t!\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0005s\u0011\u0015I\bA\"\u0005{\u0011%\t\u0019\u0003AI\u0001\n#\t)\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\f\u0001\u0005\u0012\u0005\u0005\u0004bBA4\u0001\u0011E\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011CA8\u0011\u001d\ti\u0007\u0001C\t\u0003gBq!!!\u0001\t#\t\u0019\tC\u0004\u0002\b\u0002!\t\"!#\t\u000f\u0005\u0005\u0006\u0001\"\u0005\u0002$\"9\u0011q\u0015\u0001\u0005\u0012\u0005%\u0006bBA_\u0001\u0011E\u0011q\u0018\u0005\b\u0003#\u0004A\u0011CAj\u0011%\t9\u0010AI\u0001\n#\tI\u0010C\u0005\u0002~\u0002\t\n\u0011\"\u0005\u0002\u0000\"I!1\u0001\u0001\u0012\u0002\u0013E\u0011q \u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0011%\u0011)\u0002AI\u0001\n\u0013\tI\u0010C\u0004\u0003\u0018\u0001!IA!\u0007\u0003)\u0011+G.\u001b<fef\u001cVM\u001d<jG\u0016,F/\u001b7t\u0015\t\u0001\u0013%A\u0004tKJ4\u0018nY3\u000b\u0005\t\u001a\u0013\u0001\u00033fY&4XM]=\u000b\u0005\u0011*\u0013!\u0003=me\u0016dW-Y:f\u0015\t1s%A\u0005yK\nL\u0017\r\\1cg*\t\u0001&A\u0002d_6\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0014\u0001C4sSjTH.\u001a3\n\u0005a\u001a$a\u0002'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003m\u0002\"\u0001\f\u001f\n\u0005uj#\u0001B+oSR\f!\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ssV\t\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002DC\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0015\u0013%A\u0005#fY&4XM]=SKB|7/\u001b;pef\f\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111jI\u0001\u0007KZ,g\u000e^:\n\u00055S%!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,W#\u0001)\u0011\u0005E\u001bV\"\u0001*\u000b\u0005\u0001\u001a\u0013B\u0001+S\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\f\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!AW\u0012\u0002\u0005\u0011\u0014\u0017B\u0001/Z\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/A\u0007g_2$WM]*feZL7-Z\u000b\u0002?B\u0011\u0011\u000bY\u0005\u0003CJ\u0013QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017a\u0003:pY\u0016\u001cVM\u001d<jG\u0016,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0001b]3dkJLG/\u001f\u0006\u0003S\u0016\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003W\u001a\u00141BU8mKN+'O^5dK\u0006Y1-[%e'\u0016\u0014h/[2f+\u0005q\u0007CA)p\u0013\t\u0001(KA\u0006DS&#7+\u001a:wS\u000e,\u0017a\u00024bGR|'/_\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011a/I\u0001\u0005kRLG.\u0003\u0002yk\n)B)\u001a7jm\u0016\u0014\u0018p\u00142kK\u000e$h)Y2u_JL\u0018\u0001E2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197f)\u0011Y40!\u0003\t\u000bqT\u0001\u0019A?\u0002!\u0015D\u0018n\u001d;j]\u001e$U\r\\5wKJL\bc\u0001@\u0002\u00065\tqPC\u0002#\u0003\u0003Q1!a\u0001$\u0003\u0019!w.\\1j]&\u0019\u0011qA@\u0003\u0011\u0011+G.\u001b<fefD\u0011\"a\u0003\u000b!\u0003\u0005\r!!\u0004\u0002\r\u0005\u001cG/[8o!\u0011\ty!!\b\u000f\t\u0005E\u0011\u0011\u0004\t\u0004\u0003'iSBAA\u000b\u0015\r\t9\"K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mQ&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037i\u0013AG2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197fI\u0011,g-Y;mi\u0012\u0012TCAA\u0014U\u0011\ti!!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcZ3u\t\u0016d\u0017N^3ss>\u0013\b+\u0019;uKJtGcA?\u0002@!9\u0011\u0011\t\u0007A\u0002\u00055\u0011A\u00033fY&4XM]=JI\"\u001aA\"!\u0012\u0011\t\u0005\u001d\u00131K\u0007\u0003\u0003\u0013RA!!\u000e\u0002L)!\u0011QJA(\u0003\u001diW\r\u001e:jGNT1!!\u0015(\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA+\u0003\u0013\u0012Q\u0001V5nK\u0012\f1bZ3u\r>dG-\u001a:JIR!\u0011QBA.\u0011\u001d\t\t%\u0004a\u0001\u0003\u001bA3!DA#\u0003!!w.\u00169eCR,GcA?\u0002d!1\u0011Q\r\bA\u0002u\fq!\u001e9eCR,G-\u0001\u0005e_\u0012+G.\u001a;f)\rY\u00141\u000e\u0005\b\u0003\u0003z\u0001\u0019AA\u0007\u0003!1\u0018\r\\5eCR,GcA\u001e\u0002r!)!\u0005\u0005a\u0001{R)1(!\u001e\u0002x!)!%\u0005a\u0001{\"9\u0011\u0011P\tA\u0002\u0005m\u0014aC<ji\"\fV/\u001a:jKN\u00042\u0001LA?\u0013\r\ty(\f\u0002\b\u0005>|G.Z1o\u0003A1\u0018\r\\5eCR,G)\u001a7jm\u0016\u0014\u0018\u0010F\u0002<\u0003\u000bCQA\t\nA\u0002u\f!C^1mS\u0012\fG/\u001a+sC:\u001c\u0018\u000e^5p]R91(a#\u0002\u000e\u0006]\u0005\"\u0002\u0012\u0014\u0001\u0004i\bbBAH'\u0001\u0007\u0011\u0011S\u0001\u0006gR\fw-\u001a\t\u0004}\u0006M\u0015bAAK\u007f\n)1\u000b^1hK\"9\u0011\u0011T\nA\u0002\u0005m\u0015A\u0003;sC:\u001c\u0018\u000e^5p]B\u0019a0!(\n\u0007\u0005}uP\u0001\u0006Ue\u0006t7/\u001b;j_:\fqb\u00195fG.L5\u000fR3mSZ,'/\u001f\u000b\u0004w\u0005\u0015\u0006\"\u0002\u0012\u0015\u0001\u0004i\u0018!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011\u00111\u0016\t\u0007\u0003[\u000b9,!\u0004\u000f\t\u0005=\u00161\u0017\b\u0005\u0003'\t\t,C\u0001/\u0013\r\t),L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI,a/\u0003\u0011%#XM]1cY\u0016T1!!..\u00039\u0019WO\u001d:f]R\u0014v\u000e\\3JIN,\"!!1\u0011\r\u0005\r\u0017QZA\u0007\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017l\u0013AC2pY2,7\r^5p]&!\u0011qZAc\u0005\u0019\u0011UO\u001a4fe\u0006)2m\\7qkR,\u0017I\u001c3Va\u0012\fG/\u001a#bi\u0016\u001cH#C\u001e\u0002V\u0006]\u0017\u0011]Az\u0011\u0015\u0011s\u00031\u0001~\u0011%\tIn\u0006I\u0001\u0002\u0004\tY.A\u0006ekJ\fG/[8o\u001fB$\bc\u0001\u0017\u0002^&\u0019\u0011q\\\u0017\u0003\u0007%sG\u000fC\u0005\u0002d^\u0001\n\u00111\u0001\u0002f\u0006a1\u000f^1si\u0012\u000bG/Z(qiB!\u0011q]Ax\u001b\t\tIOC\u0002w\u0003WT!!!<\u0002\t)\fg/Y\u0005\u0005\u0003c\fIO\u0001\u0003ECR,\u0007\"CA{/A\u0005\t\u0019AAs\u0003))g\u000e\u001a#bi\u0016|\u0005\u000f^\u0001 G>l\u0007/\u001e;f\u0003:$W\u000b\u001d3bi\u0016$\u0015\r^3tI\u0011,g-Y;mi\u0012\u0012TCAA~U\u0011\tY.!\u000b\u0002?\r|W\u000e];uK\u0006sG-\u00169eCR,G)\u0019;fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0002)\"\u0011Q]A\u0015\u0003}\u0019w.\u001c9vi\u0016\fe\u000eZ+qI\u0006$X\rR1uKN$C-\u001a4bk2$H\u0005N\u0001\u0013G\u0006d7-\u001e7bi\u0016|E\u000f[3s\t\u0006$X\r\u0006\u0005\u0002f\n%!Q\u0002B\t\u0011\u001d\u0011Ya\u0007a\u0001\u0003K\fA\u0001Z1uK\"9!qB\u000eA\u0002\u0005m\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\t\u0013\tM1\u0004%AA\u0002\u0005m\u0017\u0001C1eI&$\u0018n\u001c8\u00029\r\fGnY;mCR,w\n\u001e5fe\u0012\u000bG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005\t2-\u00197dk2\fG/\u001a#ve\u0006$\u0018n\u001c8\u0015\r\u0005m'1\u0004B\u0010\u0011\u001d\u0011i\"\ba\u0001\u0003K\f\u0011b\u001d;beR$\u0015\r^3\t\u000f\t\u0005R\u00041\u0001\u0002f\u00069QM\u001c3ECR,\u0007")
public interface DeliveryServiceUtils
extends Logging {
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory var1);

    public DeliveryRepository deliveryRepository();

    public XLReleaseEventBus eventBus();

    public ReleaseService releaseService();

    public ArchivedReleases archivedReleases();

    public FolderService folderService();

    public RoleService roleService();

    public CiIdService ciIdService();

    public DeliveryObjectFactory factory();

    public void checkIsUpdatable(Delivery var1, String var2);

    public static /* synthetic */ String checkIsUpdatable$default$2$(DeliveryServiceUtils $this) {
        return $this.checkIsUpdatable$default$2();
    }

    default public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static /* synthetic */ Delivery getDeliveryOrPattern$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getDeliveryOrPattern(deliveryId);
    }

    @Timed
    default public Delivery getDeliveryOrPattern(String deliveryId) {
        return this.deliveryRepository().read(deliveryId);
    }

    public static /* synthetic */ String getFolderId$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getFolderId(deliveryId);
    }

    @Timed
    default public String getFolderId(String deliveryId) {
        return this.deliveryRepository().findFolderId(deliveryId);
    }

    public static /* synthetic */ Delivery doUpdate$(DeliveryServiceUtils $this, Delivery updated) {
        return $this.doUpdate(updated);
    }

    default public Delivery doUpdate(Delivery updated) {
        Delivery original = this.deliveryRepository().read(updated.getId());
        this.checkIsUpdatable(original, this.checkIsUpdatable$default$2());
        original.setTitle(updated.getTitle());
        original.setDescription(updated.getDescription());
        original.setAutoComplete(updated.isAutoComplete());
        this.computeAndUpdateDates(original, Predef$.MODULE$.Integer2int(updated.getPlannedDuration()), updated.getStartDate(), updated.getEndDate());
        if (Strings.isNotBlank((String)updated.getFolderId())) {
            original.setFolderId(updated.getFolderId());
        }
        this.deliveryRepository().update(original);
        this.eventBus().publish((XLReleaseEvent)new DeliveryUpdatedEvent(original));
        return original;
    }

    public static /* synthetic */ void doDelete$(DeliveryServiceUtils $this, String deliveryId) {
        $this.doDelete(deliveryId);
    }

    default public void doDelete(String deliveryId) {
        if (this.deliveryRepository().exists(deliveryId)) {
            Delivery delivery = this.deliveryRepository().read(deliveryId);
            this.checkIsUpdatable(delivery, "delete");
            this.deliveryRepository().delete(deliveryId);
            this.eventBus().publish((XLReleaseEvent)new DeliveryDeletedEvent(delivery));
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Release delivery [" + deliveryId + "] already deleted");
    }

    public static /* synthetic */ void validate$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validate(delivery);
    }

    default public void validate(Delivery delivery) {
        this.validate(delivery, true);
    }

    public static /* synthetic */ void validate$(DeliveryServiceUtils $this, Delivery delivery, boolean withQueries) {
        $this.validate(delivery, withQueries);
    }

    default public void validate(Delivery delivery, boolean withQueries) {
        Checks.checkNotNull((Object)delivery, (String)"Release delivery");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((delivery.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!delivery.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)("Title must not contain reserved character " + DbConstants$.MODULE$.ESCAPE_CHAR()), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)delivery.getFolderId()) ? 1 : 0) != 0, (String)("Provided folder ID '" + delivery.getFolderId() + "' must not be a root folder"), (Object[])new Object[0]);
        if (withQueries) {
            Checks.checkArgument((boolean)this.folderService().exists(delivery.getFolderId()), (String)("Provided folder ID '" + delivery.getFolderId() + "' must exist in the database"), (Object[])new Object[0]);
        }
        if (Strings.isNotEmpty((String)delivery.getDescription())) {
            Checks.checkArgument((delivery.getDescription().length() < 1024 ? 1 : 0) != 0, (String)"Description must be 1024 characters or less", (Object[])new Object[0]);
            return;
        }
    }

    public static /* synthetic */ void validateDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validateDelivery(delivery);
    }

    default public void validateDelivery(Delivery delivery) {
        this.validate(delivery);
        this.checkIsDelivery(delivery);
        Checks.checkArgument((delivery.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((delivery.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)delivery.getEndDate().after(delivery.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
    }

    public static /* synthetic */ void validateTransition$(DeliveryServiceUtils $this, Delivery delivery, Stage stage, Transition transition) {
        $this.validateTransition(delivery, stage, transition);
    }

    default public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        Checks.checkNotNull((Object)transition, (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)("Title must not contain reserved character " + DbConstants$.MODULE$.ESCAPE_CHAR()), (Object[])new Object[0]);
        Checks.checkArgument((!delivery.isLastStage(stage) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        CollectionConverters$.MODULE$.ListHasAsScala(transition.getAllConditions()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.validate(delivery);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void checkIsDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.checkIsDelivery(delivery);
    }

    default public void checkIsDelivery(Delivery delivery) {
        Checks.checkArgument((!delivery.isTemplate() ? 1 : 0) != 0, (String)(delivery.getId() + " must be a Delivery"), (Object[])new Object[0]);
    }

    public static /* synthetic */ Iterable currentPrincipals$(DeliveryServiceUtils $this) {
        return $this.currentPrincipals();
    }

    default public Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    public static /* synthetic */ Buffer currentRoleIds$(DeliveryServiceUtils $this) {
        return $this.currentRoleIds();
    }

    default public Buffer<String> currentRoleIds() {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$2 -> x$2.getId());
    }

    public static /* synthetic */ void computeAndUpdateDates$(DeliveryServiceUtils $this, Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        $this.computeAndUpdateDates(delivery, durationOpt, startDateOpt, endDateOpt);
    }

    default public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        Tuple3 tuple3;
        Function1 & Serializable isNotEmptyDate = (Function1 & Serializable)date -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$1(date));
        int plannedDuration = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)durationOpt)).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(delivery.getPlannedDuration())));
        if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt)) && BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            v0 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.calculateDuration(startDateOpt, endDateOpt)), (Object)startDateOpt, (Object)endDateOpt);
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt))) {
            v0 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDateOpt, (Object)this.calculateOtherDate(startDateOpt, plannedDuration, this.calculateOtherDate$default$3()));
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            v0 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)this.calculateOtherDate(endDateOpt, plannedDuration, -1), (Object)endDateOpt);
        } else {
            Date startDate = Date.from(Instant.now());
            v0 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDate, (Object)this.calculateOtherDate(startDate, plannedDuration, this.calculateOtherDate$default$3()));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int duration = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Date startDate = (Date)tuple3._2();
        Date endDate = (Date)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)duration), (Object)startDate, (Object)endDate);
        int duration2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        Date startDate2 = (Date)tuple32._2();
        Date endDate2 = (Date)tuple32._3();
        delivery.setPlannedDuration(Predef$.MODULE$.int2Integer(duration2));
        delivery.setStartDate(startDate2);
        delivery.setEndDate(endDate2);
    }

    public static /* synthetic */ int computeAndUpdateDates$default$2$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$2();
    }

    default public int computeAndUpdateDates$default$2() {
        return 0;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$3$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$3();
    }

    default public Date computeAndUpdateDates$default$3() {
        return null;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$4$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$4();
    }

    default public Date computeAndUpdateDates$default$4() {
        return null;
    }

    private Date calculateOtherDate(Date date, int duration, int addition) {
        if (duration > 0) {
            return DateUtils.addHours((Date)date, (int)(duration * addition));
        }
        return DateUtils.addMonths((Date)date, (int)(1 * addition));
    }

    private int calculateOtherDate$default$3() {
        return 1;
    }

    private int calculateDuration(Date startDate, Date endDate) {
        LocalDateTime localScheduledStartDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.systemDefault());
        LocalDateTime localDueDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate.getTime()), ZoneId.systemDefault());
        return (int)localScheduledStartDate.until(localDueDate, ChronoUnit.HOURS);
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$2(Date x$3) {
        return x$3.getTime() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$1(Date date) {
        return Option$.MODULE$.apply((Object)date).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$2(x$3)));
    }

    public static void $init$(DeliveryServiceUtils $this) {
        $this.com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(new DeliveryObjectFactory($this.ciIdService()));
    }
}

