package com.xebialabs.xlrelease.delivery.actors

import akka.actor.{Actor, ActorLogging, ActorRef, Props}
import com.xebialabs.xlrelease.delivery.actors.DeliveryActor._


object DeliveryProcessingActor {
  def props(deliveryActorMaker: DeliveryActorMaker) = Props(new DeliveryProcessingActor(deliveryActorMaker))

  def name = "delivery-processing-actor"
}

class DeliveryProcessingActor(deliveryActorMaker: DeliveryActorMaker) extends Actor with ActorLogging {

  def createOrFind(deliveryId: String, msg: AnyRef): ActorRef = {
    context.child(deliveryId.deliveryActorName).getOrElse {
      log.debug(s"DeliveryProcessingActor - creating an actor tree for $deliveryId (triggered by $msg)")
      deliveryActorMaker(context, deliveryId.deliveryActorName)
    }
  }

  override def receive: Receive = {
    case msg: DeliveryAction => createOrFind(msg.deliveryId, msg) forward msg
  }

}